/**
 * Generated by Apache Royale Compiler from org/apache/royale/reflection/utils/getStaticConstantsByConvention.as
 * org.apache.royale.reflection.utils.getStaticConstantsByConvention
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.utils.getStaticConstantsByConvention');
goog.provide('org.apache.royale.reflection.utils.getStaticConstantsByConvention.warningMap');

goog.require('org.apache.royale.reflection.CompilationData');
goog.require('org.apache.royale.reflection.ExtraData');
goog.require('org.apache.royale.reflection.utils.defaultConstantConventionCheck');



/**
 *  A utility method to retrieve public static constants that is only reliable
 *  in a cross-target way by using a convention check.
 *  For this to work, javascript output needs js-default-initializers=true
 *  By default this assumes all candidates with names that are upper case only with possible underscores
 *  
 *  @asparam classRef the class reference to inspect
 *  @asparam conventionCheck optional replacement check for default check described above
 *  		should be a function that inspects a string and returns true or false depending on whether it matches the convention or not.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *
 * @export
 * @param {Object} classRef
 * @param {Function=} conventionCheck
 * @return {Array}
 */
org.apache.royale.reflection.utils.getStaticConstantsByConvention = function(classRef, conventionCheck) {
  conventionCheck = typeof conventionCheck !== 'undefined' ? conventionCheck : null;
  var /** @type {Array} */ ret = [];
  if (!conventionCheck)
    conventionCheck = org.apache.royale.reflection.utils.defaultConstantConventionCheck;
  var /** @type {string} */ item;
  
  var /** @type {Array} */ statics;
  if (classRef.prototype.ROYALE_REFLECTION_INFO) {
    if (org.apache.royale.reflection.CompilationData.hasCompilationOption((classRef.prototype.ROYALE_COMPILE_FLAGS) >>> 0, org.apache.royale.reflection.CompilationData.WITH_DEFAULT_INITIALIZERS)) {
      statics = classRef.prototype.ROYALE_INITIAL_STATICS;
    } else {
      if (goog.DEBUG) {
        if (!org.apache.royale.reflection.utils.getStaticConstantsByConvention.warningMap.get(classRef)) {
          org.apache.royale.reflection.utils.getStaticConstantsByConvention.warningMap.set(classRef, true);
          console.warn('[WARNING] getStaticConstantsByConvention :: the reflection target ' + classRef.prototype.ROYALE_CLASS_INFO.names[0].qName + ' was not ' + org.apache.royale.reflection.CompilationData.describeSingleFlag(org.apache.royale.reflection.CompilationData.WITH_DEFAULT_INITIALIZERS));
        }
      }
      statics = Object.keys(classRef);
    }
  } else {
    statics = org.apache.royale.reflection.ExtraData.hasData(classRef) ? org.apache.royale.reflection.ExtraData.getData(classRef)['ROYALE_INITIAL_STATICS'] : null;
  }
  if (statics) {
    statics = statics.slice();
    var /** @type {number} */ l = (statics.length) >>> 0;
    for (var /** @type {number} */ i = 0; i < l; i++) {
      item = org.apache.royale.utils.Language.string(statics[i]);
      if (conventionCheck(item))
        ret.push(item);
    }
  }
  return ret;
}


/**
 * @type {Map}
 */
org.apache.royale.reflection.utils.getStaticConstantsByConvention.warningMap = new Map()