/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/supportClasses/util/positionInsideBoundingClientRect.as
 * org.apache.royale.jewel.supportClasses.util.positionInsideBoundingClientRect
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.supportClasses.util.positionInsideBoundingClientRect');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.geom.Point');
goog.require('org.apache.royale.utils.PointUtils');



/**
 *  Determines the position of the popUp related to a point to avoid
 *  the component get partialy out of sight.
 * 
 *  Ensure the popup has width before performing this operation to work properly
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * 
 *  @royaleignorecoercion org.apache.royale.core.IUIBase 
 * @export
 * @param {org.apache.royale.core.IStrand} _strand
 * @param {Object} popUp
 * @param {org.apache.royale.geom.Point} point
 * @return {org.apache.royale.geom.Point}
 */
org.apache.royale.jewel.supportClasses.util.positionInsideBoundingClientRect = function(_strand, popUp, point) {
  var /** @type {number} */ outerWidth;
  var /** @type {number} */ outerHeight;
  outerWidth = document.body.getBoundingClientRect().width;
  outerHeight = document.body.getBoundingClientRect().height;
  var /** @type {number} */ popUpWidth = popUp.width;
  var /** @type {number} */ popUpHeight = popUp.height;
  point = org.apache.royale.utils.PointUtils.localToGlobal(point, _strand);
  point.x = Math.max(point.x, 0);
  point.y = Math.max(point.y, 0);
  var /** @type {number} */ extraHeight = 1 + point.y + popUpHeight - outerHeight;
  if (extraHeight > 0) {
    point.y -= extraHeight;
  }
  var /** @type {number} */ extraWidth = 1 + point.x + popUpWidth - outerWidth;
  if (extraWidth > 0) {
    point.x -= extraWidth;
  }
  return point;
}