/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/views/VirtualListView.as
 * org.apache.royale.jewel.beads.views.VirtualListView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.views.VirtualListView');

goog.require('org.apache.royale.core.IIndexedItemRenderer');
goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.IRollOverModel');
goog.require('org.apache.royale.core.ISelectableItemRenderer');
goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.html.beads.VirtualDataContainerView');
goog.require('org.apache.royale.utils.getSelectionRenderBead');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.html.beads.VirtualDataContainerView}
 */
org.apache.royale.jewel.beads.views.VirtualListView = function() {
  org.apache.royale.jewel.beads.views.VirtualListView.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.views.VirtualListView, org.apache.royale.html.beads.VirtualDataContainerView);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.views.VirtualListView', org.apache.royale.jewel.beads.views.VirtualListView);


/**
 * @protected
 * @type {org.apache.royale.core.ISelectionModel}
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.listModel;


/**
 * @protected
 * @type {number}
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.lastSelectedIndex = -1;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.ISelectionModel
 * @protected
 * @override
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.handleInitComplete = function(event) {
  this.listModel = this._strand.getBeadByType(org.apache.royale.core.ISelectionModel);
  this.listModel.addEventListener("selectionChanged", org.apache.royale.utils.Language.closure(this.selectionChangeHandler, this, 'selectionChangeHandler'));
  this.listModel.addEventListener("rollOverIndexChanged", org.apache.royale.utils.Language.closure(this.rollOverIndexChangeHandler, this, 'rollOverIndexChangeHandler'));
  org.apache.royale.jewel.beads.views.VirtualListView.superClass_.handleInitComplete.apply(this, [ event] );
};


/**
 * @protected
 * @type {number}
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.firstElementIndex = 1;


/**
 * Retrieve the renderer for a given index
 * @royaleignorecoercion org.apache.royale.core.IIndexedItemRenderer
 * @royaleignorecoercion org.apache.royale.core.IItemRenderer
 * @export
 * @override
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.getItemRendererForIndex = function(index) {
  if (this.contentView.numElements == 0)
    return null;
  var /** @type {number} */ firstIndex = this.contentView.getElementAt(this.firstElementIndex).index;
  if (index < firstIndex)
    return null;
  if (index >= (firstIndex + this.contentView.numElements))
    return null;
  return this.contentView.getElementAt((index - firstIndex + this.firstElementIndex) >> 0);
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IItemRenderer
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.selectionChangeHandler = function(event) {
  var /** @type {org.apache.royale.core.ISelectableItemRenderer} */ selectionBead;
  var /** @type {Object} */ ir = this.dataGroup.getItemRendererForIndex(this.lastSelectedIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.selected = false;
  }
  ir = this.dataGroup.getItemRendererForIndex(this.listModel.selectedIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.selected = true;
  }
  this.lastSelectedIndex = this.listModel.selectedIndex;
};


/**
 * @protected
 * @type {number}
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.lastRollOverIndex = -1;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IIndexedItemRenderer
 * @royaleignorecoercion org.apache.royale.core.IRollOverModel
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.rollOverIndexChangeHandler = function(event) {
  var /** @type {org.apache.royale.core.ISelectableItemRenderer} */ selectionBead;
  var /** @type {org.apache.royale.core.IItemRenderer} */ ir = this.dataGroup.getItemRendererForIndex(this.lastRollOverIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.hovered = false;
  }
  ir = this.dataGroup.getItemRendererForIndex(this.listModel.rollOverIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.hovered = true;
  }
  this.lastRollOverIndex = this.listModel.rollOverIndex;
};


/**
 * @protected
 * @override
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.dataProviderChangeHandler = function(event) {
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'VirtualListView', qName: 'org.apache.royale.jewel.beads.views.VirtualListView', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    methods: function () {
      return {
        'VirtualListView': { type: '', declaredBy: 'org.apache.royale.jewel.beads.views.VirtualListView'},
        'getItemRendererForIndex': { type: 'org.apache.royale.core.IItemRenderer', declaredBy: 'org.apache.royale.jewel.beads.views.VirtualListView', parameters: function () { return [ 'int', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.views.VirtualListView.prototype.ROYALE_COMPILE_FLAGS = 10;