/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/views/ListView.as
 * org.apache.royale.jewel.beads.views.ListView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.views.ListView');

goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.IItemRendererOwnerView');
goog.require('org.apache.royale.core.ILayoutView');
goog.require('org.apache.royale.core.IRenderedObject');
goog.require('org.apache.royale.core.IRollOverModel');
goog.require('org.apache.royale.core.ISelectableItemRenderer');
goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.KeyboardEvent');
goog.require('org.apache.royale.html.beads.DataContainerView');
goog.require('org.apache.royale.jewel.beads.models.ListPresentationModel');
goog.require('org.apache.royale.jewel.supportClasses.list.IListPresentationModel');
goog.require('org.apache.royale.utils.getSelectionRenderBead');
goog.require('org.apache.royale.jewel.beads.views.IScrollToIndexView');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.html.beads.DataContainerView}
 * @implements {org.apache.royale.jewel.beads.views.IScrollToIndexView}
 */
org.apache.royale.jewel.beads.views.ListView = function() {
  org.apache.royale.jewel.beads.views.ListView.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.views.ListView, org.apache.royale.html.beads.DataContainerView);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.views.ListView', org.apache.royale.jewel.beads.views.ListView);


/**
 * @private
 * @type {org.apache.royale.core.IItemRendererOwnerView}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.org_apache_royale_jewel_beads_views_ListView__dataGroup;


/**
 * @protected
 * @type {org.apache.royale.core.ISelectionModel}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.listModel;


/**
 * @protected
 * @type {number}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.lastSelectedIndex = -1;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.ISelectionModel
 * @protected
 * @override
 */
org.apache.royale.jewel.beads.views.ListView.prototype.handleInitComplete = function(event) {
  this.listModel = this._strand.getBeadByType(org.apache.royale.core.ISelectionModel);
  this.listModel.addEventListener("selectionChanged", org.apache.royale.utils.Language.closure(this.selectionChangeHandler, this, 'selectionChangeHandler'));
  this.listModel.addEventListener("rollOverIndexChanged", org.apache.royale.utils.Language.closure(this.rollOverIndexChangeHandler, this, 'rollOverIndexChangeHandler'));
  goog.events.listen(org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IRenderedObject).element, 'keydown', org.apache.royale.utils.Language.closure(this.keyEventHandler, this, 'keyEventHandler'));
  org.apache.royale.jewel.beads.views.ListView.superClass_.handleInitComplete.apply(this, [ event] );
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.KeyboardEvent} event
 */
org.apache.royale.jewel.beads.views.ListView.prototype.keyEventHandler = function(event) {
  event.preventDefault();
  var /** @type {number} */ prevIndex = this.listModel.selectedIndex;
  if (event.key === org.apache.royale.events.KeyboardEvent.KEYCODE__UP) {
    if (prevIndex > 0)
      this.listModel.selectedIndex -= 1;
  } else if (event.key === org.apache.royale.events.KeyboardEvent.KEYCODE__DOWN) {
    this.listModel.selectedIndex += 1;
  }
  if (prevIndex != this.listModel.selectedIndex) {
    this.selectionChangeHandler(null);
    this.scrollToIndex(this.listModel.selectedIndex);
  }
};


/**
 * @asprivate
 * Ensure the list selects the selectedItem if some is set by the user at creation time
 * @protected
 * @override
 */
org.apache.royale.jewel.beads.views.ListView.prototype.itemsCreatedHandler = function(event) {
  org.apache.royale.jewel.beads.views.ListView.superClass_.itemsCreatedHandler.apply(this, [ event] );
  if (this.listModel.selectedIndex != -1)
    this.selectionChangeHandler(null);
};


/**
 * @royaleignorecoercion org.apache.royale.core.IItemRenderer
 * @royaleignorecoercion org.apache.royale.core.ISelectableItemRenderer
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.views.ListView.prototype.selectionChangeHandler = function(event) {
  var /** @type {Object} */ selectionBead;
  var /** @type {Object} */ ir = this.dataGroup.getItemRendererForIndex(this.lastSelectedIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.selected = false;
  }
  ir = this.dataGroup.getItemRendererForIndex(this.listModel.selectedIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.selected = true;
  }
  this.lastSelectedIndex = this.listModel.selectedIndex;
};


/**
 * @protected
 * @type {number}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.lastRollOverIndex = -1;


/**
 * @royaleignorecoercion org.apache.royale.core.IItemRenderer
 * @royaleignorecoercion org.apache.royale.core.IRollOverModel
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.views.ListView.prototype.rollOverIndexChangeHandler = function(event) {
  var /** @type {org.apache.royale.core.ISelectableItemRenderer} */ selectionBead;
  var /** @type {Object} */ ir = this.dataGroup.getItemRendererForIndex(this.lastRollOverIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.hovered = false;
  }
  ir = this.dataGroup.getItemRendererForIndex(this.listModel.rollOverIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.hovered = true;
  }
  this.lastRollOverIndex = this.listModel.rollOverIndex;
};


/**
 *  Ensures that the data provider item at the given index is visible.
 *  
 *  If the item is visible, the <code>verticalScrollPosition</code>
 *  property is left unchanged even if the item is not the first visible
 *  item. If the item is not currently visible, the 
 *  <code>verticalScrollPosition</code>
 *  property is changed make the item the first visible item, unless there
 *  aren't enough rows to do so because the 
 *  <code>verticalScrollPosition</code> value is limited by the 
 *  <code>maxVerticalScrollPosition</code> property.
 *
 *  @asparam index The index of the item in the data provider.
 *
 *  @asreturn <code>true</code> if <code>verticalScrollPosition</code> changed.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.9.7
 * @export
 * @param {number} index
 * @return {boolean}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.scrollToIndex = function(index) {
  var /** @type {HTMLElement} */ scrollArea = org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IRenderedObject).element;
  var /** @type {number} */ oldScroll = scrollArea.scrollTop;
  var /** @type {number} */ totalHeight = 0;
  var /** @type {org.apache.royale.jewel.supportClasses.list.IListPresentationModel} */ pm = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.jewel.supportClasses.list.IListPresentationModel), org.apache.royale.jewel.supportClasses.list.IListPresentationModel);
  if (pm.variableRowHeight) {
    var /** @type {number} */ n = (this.listModel.dataProvider.length) >> 0;
    var /** @type {Array} */ irHeights = [];
    for (var /** @type {number} */ i = 0; i <= index; i++) {
      var /** @type {org.apache.royale.core.IItemRenderer} */ ir = org.apache.royale.utils.Language.as(this.dataGroup.getItemRendererForIndex(i), org.apache.royale.core.IItemRenderer);
      totalHeight += ir.element.clientHeight;
      irHeights.push(totalHeight + ir.element.clientHeight - scrollArea.clientHeight);
    }
    scrollArea.scrollTop = Math.min(irHeights[index], totalHeight);
  } else {
    var /** @type {number} */ rowHeight;
    rowHeight = isNaN(pm.rowHeight) ? org.apache.royale.jewel.beads.models.ListPresentationModel.DEFAULT_ROW_HEIGHT : rowHeight;
    totalHeight = this.listModel.dataProvider.length * rowHeight - scrollArea.clientHeight;
    scrollArea.scrollTop = Math.min(index * rowHeight, totalHeight);
  }
  return oldScroll != scrollArea.scrollTop;
};


org.apache.royale.jewel.beads.views.ListView.prototype.get__dataGroup = function() {
  if (!this.org_apache_royale_jewel_beads_views_ListView__dataGroup) {
    var /** @type {org.apache.royale.core.ILayoutView} */ c = this.contentView;
    if (c && org.apache.royale.utils.Language.is(c, org.apache.royale.core.IItemRendererOwnerView))
      this.org_apache_royale_jewel_beads_views_ListView__dataGroup = c;
    else
      this.org_apache_royale_jewel_beads_views_ListView__dataGroup = org.apache.royale.jewel.beads.views.ListView.superClass_.get__dataGroup.apply(this);
  }
  return this.org_apache_royale_jewel_beads_views_ListView__dataGroup;
};


Object.defineProperties(org.apache.royale.jewel.beads.views.ListView.prototype, /** @lends {org.apache.royale.jewel.beads.views.ListView.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IItemRendererOwnerView} */
dataGroup: {
get: org.apache.royale.jewel.beads.views.ListView.prototype.get__dataGroup}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'ListView', qName: 'org.apache.royale.jewel.beads.views.ListView', kind: 'class' }], interfaces: [org.apache.royale.jewel.beads.views.IScrollToIndexView] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'dataGroup': { type: 'org.apache.royale.core.IItemRendererOwnerView', access: 'readonly', declaredBy: 'org.apache.royale.jewel.beads.views.ListView'}
      };
    },
    methods: function () {
      return {
        'ListView': { type: '', declaredBy: 'org.apache.royale.jewel.beads.views.ListView'},
        'scrollToIndex': { type: 'Boolean', declaredBy: 'org.apache.royale.jewel.beads.views.ListView', parameters: function () { return [ 'int', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.views.ListView.prototype.ROYALE_COMPILE_FLAGS = 10;