/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/validators/CreditCardValidator.as
 * org.apache.royale.jewel.beads.validators.CreditCardValidator
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.validators.CreditCardValidator');

goog.require('org.apache.royale.core.IPopUpHost');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.beads.validators.StringValidator');
goog.require('org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType');
goog.require('org.apache.royale.utils.UIUtils');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 *  
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.6
 * @constructor
 * @extends {org.apache.royale.jewel.beads.validators.StringValidator}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator = function() {
  org.apache.royale.jewel.beads.validators.CreditCardValidator.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.validators.CreditCardValidator, org.apache.royale.jewel.beads.validators.StringValidator);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.validators.CreditCardValidator', org.apache.royale.jewel.beads.validators.CreditCardValidator);


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.DECIMAL_DIGITS = "0123456789";


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.MISSING_CARD_TYPE = "The value being validated doesn't contain a cardType property.";


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.MISSING_CARD_NUMBER = "The value being validated doesn't contain a cardNumber property.";


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.CNS_ATTRIBUTE = "The cardNumberSource attribute, '{0}', can not be of type String.";


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.CTS_ATTRIBUTE = "The cardTypeSource attribute, '{0}', can not be of type String.";


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.INVALID_FORMAT_CHARS = "The allowedFormatChars parameter is invalid. It cannot contain any digits.";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__allowedFormatChars = " -";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__invalidCharError = "Invalid characters in your credit card number. (Enter numbers only.)";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__invalidNumberError = "The credit card number is invalid.";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__noNumError = "No credit card number is specified.";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__noTypeError = "No credit card type is specified or the type is not valid.";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__wrongLengthError = "Your credit card number contains the wrong number of digits.";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__wrongTypeError = "Incorrect card type is specified.";


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__cardTypeProperty;


/**
 * @private
 * @type {Object}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__cardTypeSource;


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator__triggerCardTypeEvent;


/**
 *  Override of the base class validate() method to validate a the host textinput as email.
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.6
 * @export
 * @override
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.validate = function(event) {
  event = typeof event !== 'undefined' ? event : null;
  if (org.apache.royale.jewel.beads.validators.CreditCardValidator.superClass_.validate.apply(this, [ event] )) {
    var /** @type {Object} */ value = this.org_apache_royale_jewel_beads_validators_CreditCardValidator_getValueFromSource();
    var /** @type {string} */ errors = this.org_apache_royale_jewel_beads_validators_CreditCardValidator_validateCreditCard(value);
    if (errors) {
      this.createErrorTip(errors);
    } else {
      var /** @type {org.apache.royale.core.IPopUpHost} */ host = org.apache.royale.utils.UIUtils.findPopUpHost(this.hostComponent);
      org.apache.royale.utils.Language.as(host, org.apache.royale.core.IUIBase).dispatchEvent(new org.apache.royale.events.Event("cleanValidationErrors"));
    }
  }
  return !this.isError;
};


/**
 *  Convenience method for calling a validator.
 *  Each of the standard Flex validators has a similar convenience method.
 *
 *  @asparam validator The CreditCardValidator instance.
 *
 *  @asparam value A field to validate, which must contain
 *  the following fields:
 *  <ul>
 *    <li><code>cardType</code> - Specifies the type of credit card being validated. 
 *    Use the static constants
 *    <code>CreditCardValidatorCardType.MASTER_CARD</code>, 
 *    <code>CreditCardValidatorCardType.VISA</code>,
 *    <code>CreditCardValidatorCardType.AMERICAN_EXPRESS</code>,
 *    <code>CreditCardValidatorCardType.DISCOVER</code>, or
 *    <code>CreditCardValidatorCardType.DINERS_CLUB</code>.</li>
 *    <li><code>cardNumber</code> - Specifies the number of the card
 *    being validated.</li></ul>
 *
 *  @asparam baseField Text representation of the subfield
 *  specified in the value parameter. 
 *  For example, if the <code>value</code> parameter
 *  specifies value.date, the <code>baseField</code> value is "date".
 *
 *  @asreturn An Array of ValidationResult objects, with one ValidationResult 
 *  object for each field examined by the validator. 
 *
 *  @see mx.validators.ValidationResult
 *  
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.6
 * @private
 * @param {Object} value
 * @return {string}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator_validateCreditCard = function(value) {
  var /** @type {number} */ tempdigit = 0;
  var /** @type {number} */ i = 0;
  var /** @type {number} */ n = 0;
  var /** @type {string} */ allowedFormatChars = this.allowedFormatChars;
  var /** @type {string} */ valid = org.apache.royale.jewel.beads.validators.CreditCardValidator.DECIMAL_DIGITS + allowedFormatChars;
  var /** @type {string} */ cardType = org.apache.royale.utils.Language.string(value ? value.cardType : null);
  var /** @type {string} */ cardNum = org.apache.royale.utils.Language.string(value ? value.cardNumber : null);
  var /** @type {string} */ digitsOnlyCardNum = "";
  //var /** @type {number} */ n = 0;
  //var /** @type {number} */ i = 0;
  if (!cardType) {
    return org.apache.royale.jewel.beads.validators.CreditCardValidator.MISSING_CARD_TYPE;
  }
  if (!cardNum) {
    return org.apache.royale.jewel.beads.validators.CreditCardValidator.MISSING_CARD_NUMBER;
  }
  if (this.required > 1) {
    if (cardType.length == 0) {
      return this.requiredFieldError;
    }
    if (!cardNum) {
      return this.requiredFieldError;
    }
  }
  n = (allowedFormatChars.length) >> 0;
  for (i = 0; i < n; i++) {
    if (org.apache.royale.jewel.beads.validators.CreditCardValidator.DECIMAL_DIGITS.indexOf(allowedFormatChars.charAt(i)) != -1) {
      return org.apache.royale.jewel.beads.validators.CreditCardValidator.INVALID_FORMAT_CHARS;
    }
  }
  if (!cardType) {
    return this.noTypeError;
  } else if (cardType != org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.MASTER_CARD && cardType != org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.VISA && cardType != org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.AMERICAN_EXPRESS && cardType != org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.DISCOVER && cardType != org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.DINERS_CLUB) {
    return this.wrongTypeError;
  }
  if (!cardNum) {
    return this.noNumError;
  }
  if (cardNum) {
    n = (cardNum.length) >> 0;
    for (i = 0; i < n; i++) {
      var /** @type {string} */ temp = "" + cardNum.substring(i, i + 1);
      if (valid.indexOf(temp) == -1) {
        return this.invalidCharError;
      }
      if (org.apache.royale.jewel.beads.validators.CreditCardValidator.DECIMAL_DIGITS.indexOf(temp) != -1) {
        digitsOnlyCardNum += temp;
      }
    }
  }
  var /** @type {number} */ cardNumLen = (digitsOnlyCardNum.toString().length) >> 0;
  var /** @type {number} */ correctLen = -1;
  var /** @type {number} */ correctLen2 = -1;
  var /** @type {Array} */ correctPrefixArray = [];
  if (cardType == org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.DINERS_CLUB && digitsOnlyCardNum.charAt(0) == "5") {
    cardType = org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.MASTER_CARD;
  }
  switch (cardType) {
    case org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.MASTER_CARD:
      correctLen = 16;
      correctPrefixArray.push("51");
      correctPrefixArray.push("52");
      correctPrefixArray.push("53");
      correctPrefixArray.push("54");
      correctPrefixArray.push("55");
      break;
    case org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.VISA:
      correctLen = 13;
      correctLen2 = 16;
      correctPrefixArray.push("4");
      break;
    case org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.AMERICAN_EXPRESS:
      correctLen = 15;
      correctPrefixArray.push("34");
      correctPrefixArray.push("37");
      break;
    case org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.DISCOVER:
      correctLen = 16;
      correctPrefixArray.push("6011");
      break;
    case org.apache.royale.jewel.supportClasses.validators.CreditCardValidatorCardType.DINERS_CLUB:
      correctLen = 14;
      correctPrefixArray.push("300");
      correctPrefixArray.push("301");
      correctPrefixArray.push("302");
      correctPrefixArray.push("303");
      correctPrefixArray.push("304");
      correctPrefixArray.push("305");
      correctPrefixArray.push("36");
      correctPrefixArray.push("38");
      break;
    default:
      return this.wrongTypeError;
  }
  if ((cardNumLen != correctLen) && (cardNumLen != correctLen2)) {
    return this.wrongLengthError;
  }
  var /** @type {boolean} */ foundPrefix = false;
  for (i = (correctPrefixArray.length - 1) >> 0; i >= 0; i--) {
    if (digitsOnlyCardNum.indexOf(org.apache.royale.utils.Language.string(correctPrefixArray[i])) == 0) {
      foundPrefix = true;
      break;
    }
  }
  if (!foundPrefix) {
    return this.invalidNumberError;
  }
  var /** @type {boolean} */ doubledigit = false;
  var /** @type {number} */ checkdigit = 0;
  //var /** @type {number} */ tempdigit = 0;
  for (i = (cardNumLen - 1) >> 0; i >= 0; i--) {
    tempdigit = (Number(digitsOnlyCardNum.charAt(i))) >> 0;
    if (doubledigit) {
      tempdigit *= 2;
      checkdigit += ((tempdigit % 10)) >> 0;
      if ((tempdigit / 10) >= 1.0)
        checkdigit++;
      doubledigit = false;
    } else {
      checkdigit = (checkdigit + tempdigit) >> 0;
      doubledigit = true;
    }
  }
  if ((checkdigit % 10) != 0) {
    return this.invalidNumberError;
  }
  return null;
};


/**
 *  @asprivate
 *  Grabs the data for the validator from two different sources
 * @private
 * @return {Object}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.org_apache_royale_jewel_beads_validators_CreditCardValidator_getValueFromSource = function() {
  var /** @type {Object} */ value = {};
  if (this.cardTypeSource && this.cardTypeProperty) {
    value.cardType = this.cardTypeSource[this.cardTypeProperty];
  }
  value.cardNumber = this.hostComponent["text"];
  return value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__allowedFormatChars = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__allowedFormatChars;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__allowedFormatChars = function(value) {
  if (value != null) {
    var /** @type {number} */ n = (value.length) >> 0;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      if (org.apache.royale.jewel.beads.validators.CreditCardValidator.DECIMAL_DIGITS.indexOf(value.charAt(i)) != -1) {
        value = " -";
      }
    }
  }
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__allowedFormatChars = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__invalidCharError = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__invalidCharError;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__invalidCharError = function(value) {
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__invalidCharError = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__invalidNumberError = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__invalidNumberError;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__invalidNumberError = function(value) {
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__invalidNumberError = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__noNumError = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__noNumError;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__noNumError = function(value) {
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__noNumError = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__noTypeError = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__noTypeError;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__noTypeError = function(value) {
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__noTypeError = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__wrongLengthError = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__wrongLengthError;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__wrongLengthError = function(value) {
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__wrongLengthError = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__wrongTypeError = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__wrongTypeError;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__wrongTypeError = function(value) {
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__wrongTypeError = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__cardTypeProperty = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__cardTypeProperty;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__cardTypeProperty = function(value) {
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__cardTypeProperty = value;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__cardTypeSource = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__cardTypeSource;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__cardTypeSource = function(value) {
  if (this.org_apache_royale_jewel_beads_validators_CreditCardValidator__cardTypeSource == value)
    return;
  this.org_apache_royale_jewel_beads_validators_CreditCardValidator__cardTypeSource = value;
  this.triggerCardTypeEvent = org.apache.royale.events.Event.CHANGE;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__triggerCardTypeEvent = function() {
  return this.org_apache_royale_jewel_beads_validators_CreditCardValidator__triggerCardTypeEvent;
};


org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__triggerCardTypeEvent = function(value) {
  if (this.triggerCardTypeEvent != value) {
    if (this.cardTypeSource) {
      if (this.triggerCardTypeEvent) {
        this.cardTypeSource.removeEventListener(this.triggerEvent, org.apache.royale.utils.Language.closure(this.validate, this, 'validate'));
      }
      if (value) {
        this.cardTypeSource.addEventListener(value, org.apache.royale.utils.Language.closure(this.validate, this, 'validate'));
      }
    }
    this.org_apache_royale_jewel_beads_validators_CreditCardValidator__triggerCardTypeEvent = value;
    if (this.hostComponent != null) {
      this.hostComponent.dispatchEvent(new org.apache.royale.events.Event("triggerCardTypeEventChanged"));
    }
  }
};


Object.defineProperties(org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype, /** @lends {org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype} */ {
/**
  * @export
  * @type {string} */
allowedFormatChars: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__allowedFormatChars,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__allowedFormatChars},
/**
  * @export
  * @type {string} */
invalidCharError: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__invalidCharError,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__invalidCharError},
/**
  * @export
  * @type {string} */
invalidNumberError: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__invalidNumberError,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__invalidNumberError},
/**
  * @export
  * @type {string} */
noNumError: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__noNumError,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__noNumError},
/**
  * @export
  * @type {string} */
noTypeError: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__noTypeError,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__noTypeError},
/**
  * @export
  * @type {string} */
wrongLengthError: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__wrongLengthError,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__wrongLengthError},
/**
  * @export
  * @type {string} */
wrongTypeError: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__wrongTypeError,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__wrongTypeError},
/**
  * @export
  * @type {string} */
cardTypeProperty: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__cardTypeProperty,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__cardTypeProperty},
/**
  * @export
  * @type {Object} */
cardTypeSource: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__cardTypeSource,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__cardTypeSource},
/**
  * @export
  * @type {string} */
triggerCardTypeEvent: {
get: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.get__triggerCardTypeEvent,
set: org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.set__triggerCardTypeEvent}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'CreditCardValidator', qName: 'org.apache.royale.jewel.beads.validators.CreditCardValidator', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'allowedFormatChars': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'invalidCharError': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'invalidNumberError': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'noNumError': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'noTypeError': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'wrongLengthError': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'wrongTypeError': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'cardTypeProperty': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'cardTypeSource': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'triggerCardTypeEvent': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'triggerCardTypeEventChanged' } ] } ]; }}
      };
    },
    methods: function () {
      return {
        'CreditCardValidator': { type: '', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator'},
        'validate': { type: 'Boolean', declaredBy: 'org.apache.royale.jewel.beads.validators.CreditCardValidator', parameters: function () { return [ 'org.apache.royale.events.Event', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.validators.CreditCardValidator.prototype.ROYALE_COMPILE_FLAGS = 10;