/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/models/DateChooserModel.as
 * org.apache.royale.jewel.beads.models.DateChooserModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.models.DateChooserModel');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.core.IDateChooserModel');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IDateChooserModel}
 */
org.apache.royale.jewel.beads.models.DateChooserModel = function() {
  
  this.org_apache_royale_jewel_beads_models_DateChooserModel__dayNames = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
  this.org_apache_royale_jewel_beads_models_DateChooserModel__monthNames = ["JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"];
  this.org_apache_royale_jewel_beads_models_DateChooserModel__years = new Array(org.apache.royale.jewel.beads.models.DateChooserModel.NUM_YEARS_VIEW);
  this.org_apache_royale_jewel_beads_models_DateChooserModel__months = [];
  org.apache.royale.jewel.beads.models.DateChooserModel.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.models.DateChooserModel, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.models.DateChooserModel', org.apache.royale.jewel.beads.models.DateChooserModel);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__strand;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__viewState = 0;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__dayNames;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__monthNames;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.MINIMUM_YEAR = 1900;


org.apache.royale.jewel.beads.models.DateChooserModel.get__MAXIMUM_YEAR = function() {
  var value = new Date().getFullYear() + 100;
  Object.defineProperty(org.apache.royale.jewel.beads.models.DateChooserModel, 'MAXIMUM_YEAR', { value: value, writable: false });
  return value;
};
/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.MAXIMUM_YEAR;

Object.defineProperties(org.apache.royale.jewel.beads.models.DateChooserModel, /** @lends {org.apache.royale.jewel.beads.models.DateChooserModel} */ {
/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
MAXIMUM_YEAR: {
  get: org.apache.royale.jewel.beads.models.DateChooserModel.get__MAXIMUM_YEAR,
  configurable: true}});


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel_navigateYearsChanged;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__navigateYears;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__firstDayOfWeek = 0;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.NUM_DAYS_VIEW = 42;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__days;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.NUM_YEARS_VIEW = 24;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__years;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__months;


/**
 * @private
 * @type {Date}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate;


/**
 * @export
 * @param {number} newYear
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.changeYear = function(newYear) {
  this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear = newYear;
  this.org_apache_royale_jewel_beads_models_DateChooserModel__viewState = 2;
  if (this.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate)
    this.selectedDate.setFullYear(this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear, this.selectedDate.getMonth(), this.selectedDate.getDate());
  this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
  this.dispatchEvent(new org.apache.royale.events.Event("yearChanged"));
};


/**
 * @export
 * @param {number} newMonth
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.changeMonth = function(newMonth) {
  this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth = newMonth;
  this.org_apache_royale_jewel_beads_models_DateChooserModel__viewState = 0;
  if (this.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate)
    this.selectedDate.setMonth(this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth, this.selectedDate.getDate());
  this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
  this.dispatchEvent(new org.apache.royale.events.Event("monthChanged"));
};


/**
 * Cycle days array for offsetting when change firstDayOfWeek
 * 
 * @asparam array , the array to get a position
 * @asparam index, the index in the array to use
 * @asparam offset, the offset to apply, this could be positive or negative
 * @asreturn the cycled position
 * @export
 * @param {Array} array
 * @param {number} index
 * @param {number} offset
 * @return {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.cycleArray = function(array, index, offset) {
  return ((index + offset) % array.length + array.length) % array.length;
};


/**
 * @asprivate
 * @private
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar = function() {
  var /** @type {number} */ i = 0;
  //var /** @type {number} */ i = 0;
  if (this.viewState == 0) {
    var /** @type {Date} */ firstDay = new Date(this.displayedYear, this.displayedMonth, 1);
    this.org_apache_royale_jewel_beads_models_DateChooserModel__days = new Array(org.apache.royale.jewel.beads.models.DateChooserModel.NUM_DAYS_VIEW);
    i = (org.apache.royale.jewel.beads.models.DateChooserModel.cycleArray(this.org_apache_royale_jewel_beads_models_DateChooserModel__dayNames, firstDay.getDay(), -this.firstDayOfWeek)) >> 0;
    var /** @type {number} */ dayNumber = 1;
    var /** @type {number} */ numDays = this.org_apache_royale_jewel_beads_models_DateChooserModel_numberOfDaysInMonth(this.displayedMonth, this.displayedYear);
    while (dayNumber <= numDays) {
      this.org_apache_royale_jewel_beads_models_DateChooserModel__days[i++] = new Date(this.displayedYear, this.displayedMonth, dayNumber++);
    }
  } else if (this.viewState == 1) {
    i = 0;
    var /** @type {number} */ yearNumber = ((this.org_apache_royale_jewel_beads_models_DateChooserModel_navigateYearsChanged ? this.navigateYears : this.displayedYear) - org.apache.royale.jewel.beads.models.DateChooserModel.NUM_YEARS_VIEW / 2) >> 0;
    while (i < org.apache.royale.jewel.beads.models.DateChooserModel.NUM_YEARS_VIEW) {
      this.org_apache_royale_jewel_beads_models_DateChooserModel__years[i] = new Date(yearNumber + i++, this.displayedMonth, 1);
    }
  } else {
    i = 0;
    var /** @type {number} */ numMonths = 12;
    while (i < numMonths) {
      this.org_apache_royale_jewel_beads_models_DateChooserModel__months[i] = new Date(this.displayedYear, i++, 1);
    }
  }
};


/**
 * @asprivate
 * @private
 * @param {number} month
 * @param {number} year
 * @return {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.org_apache_royale_jewel_beads_models_DateChooserModel_numberOfDaysInMonth = function(month, year) {
  var /** @type {number} */ n = 0;
  //var /** @type {number} */ n = 0;
  if (month == 1) {
    if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0))
      n = 29;
    else
      n = 28;
  }
  else if (month == 3 || month == 5 || month == 8 || month == 10)
    n = 30;
  else
    n = 31;
  return n;
};


/**
 * @asprivate
 * @export
 * @return {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.getIndexForSelectedDate = function() {
  var /** @type {number} */ i = 0, /** @type {Date} */ test;
  //var /** @type {number} */ i = 0, /** @type {Date} */ test;
  if (this.viewState == 0 && this.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate) {
    var /** @type {string} */ str = this.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate.toDateString();
    for (i = 0; i < this.org_apache_royale_jewel_beads_models_DateChooserModel__days.length; i++) {
      test = org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_models_DateChooserModel__days[i], Date);
      if (test && test.toDateString() == str) {
        return i;
      }
    }
  } else if (this.viewState == 1 && this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear) {
    for (i = 0; i < this.org_apache_royale_jewel_beads_models_DateChooserModel__years.length; i++) {
      test = org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_models_DateChooserModel__years[i], Date);
      if (test.getFullYear() == this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear) {
        return i;
      }
    }
  } else if (this.viewState == 2 && this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth) {
    for (i = 0; i < this.org_apache_royale_jewel_beads_models_DateChooserModel__months.length; i++) {
      test = org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_models_DateChooserModel__months[i], Date);
      if (test.getMonth() == this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth) {
        return i;
      }
    }
  }
  return -1;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__strand = function(value) {
  this.org_apache_royale_jewel_beads_models_DateChooserModel__strand = value;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__viewState = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__viewState;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__viewState = function(value) {
  this.org_apache_royale_jewel_beads_models_DateChooserModel__viewState = value;
  this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
  this.dispatchEvent(new org.apache.royale.events.Event("viewStateChanged"));
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__dayNames = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__dayNames;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__dayNames = function(value) {
  this.org_apache_royale_jewel_beads_models_DateChooserModel__dayNames = value;
  this.dispatchEvent(new org.apache.royale.events.Event("dayNamesChanged"));
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__monthNames = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__monthNames;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__monthNames = function(value) {
  this.org_apache_royale_jewel_beads_models_DateChooserModel__monthNames = value;
  this.dispatchEvent(new org.apache.royale.events.Event("monthNames"));
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__displayedYear = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__displayedYear = function(value) {
  if (value != this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear = value;
    this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
    this.dispatchEvent(new org.apache.royale.events.Event("displayedYearChanged"));
  }
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__navigateYears = function() {
  if (!this.org_apache_royale_jewel_beads_models_DateChooserModel__navigateYears)
    return this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear;
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__navigateYears;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__navigateYears = function(value) {
  if (value != this.org_apache_royale_jewel_beads_models_DateChooserModel__navigateYears && (value >= org.apache.royale.jewel.beads.models.DateChooserModel.MINIMUM_YEAR - org.apache.royale.jewel.beads.models.DateChooserModel.NUM_YEARS_VIEW / 2) && (value <= org.apache.royale.jewel.beads.models.DateChooserModel.MAXIMUM_YEAR + org.apache.royale.jewel.beads.models.DateChooserModel.NUM_YEARS_VIEW / 2)) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__navigateYears = value;
    this.org_apache_royale_jewel_beads_models_DateChooserModel_navigateYearsChanged = true;
    this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
    this.org_apache_royale_jewel_beads_models_DateChooserModel_navigateYearsChanged = false;
    this.dispatchEvent(new org.apache.royale.events.Event("displayedYearChanged"));
  }
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__displayedMonth = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__displayedMonth = function(value) {
  if (this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth != value) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth = value;
    this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
    this.dispatchEvent(new org.apache.royale.events.Event("displayedMonthChanged"));
  }
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__firstDayOfWeek = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__firstDayOfWeek;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__firstDayOfWeek = function(value) {
  if (value != this.org_apache_royale_jewel_beads_models_DateChooserModel__firstDayOfWeek) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__firstDayOfWeek = value;
    this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
    this.dispatchEvent(new org.apache.royale.events.Event("firstDayOfWeekChanged"));
  }
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__days = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__days;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__days = function(value) {
  if (value != this.org_apache_royale_jewel_beads_models_DateChooserModel__days) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__days = value;
    this.dispatchEvent(new org.apache.royale.events.Event("daysChanged"));
  }
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__years = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__years;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__years = function(value) {
  if (value != this.org_apache_royale_jewel_beads_models_DateChooserModel__years) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__years = value;
    this.dispatchEvent(new org.apache.royale.events.Event("yearsChanged"));
  }
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__months = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__months;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__months = function(value) {
  if (value != this.org_apache_royale_jewel_beads_models_DateChooserModel__months) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__months = value;
    this.dispatchEvent(new org.apache.royale.events.Event("monthsChanged"));
  }
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__selectedDate = function() {
  return this.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate;
};


org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__selectedDate = function(value) {
  if (value != this.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate) {
    this.org_apache_royale_jewel_beads_models_DateChooserModel__selectedDate = value;
    if (value != null) {
      var /** @type {boolean} */ needsUpdate = false;
      if (value.getMonth() != this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth) {
        needsUpdate = true;
        this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedMonth = value.getMonth();
      }
      if (value.getFullYear() != this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear) {
        needsUpdate = true;
        this.org_apache_royale_jewel_beads_models_DateChooserModel__displayedYear = value.getFullYear();
      }
      if (needsUpdate)
        this.org_apache_royale_jewel_beads_models_DateChooserModel_updateCalendar();
    }
    this.dispatchEvent(new org.apache.royale.events.Event("selectedDateChanged"));
  }
};


Object.defineProperties(org.apache.royale.jewel.beads.models.DateChooserModel.prototype, /** @lends {org.apache.royale.jewel.beads.models.DateChooserModel.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__strand},
/**
  * @export
  * @type {number} */
viewState: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__viewState,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__viewState},
/**
  * @export
  * @type {Array} */
dayNames: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__dayNames,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__dayNames},
/**
  * @export
  * @type {Array} */
monthNames: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__monthNames,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__monthNames},
/**
  * @export
  * @type {number} */
displayedYear: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__displayedYear,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__displayedYear},
/**
  * @export
  * @type {number} */
navigateYears: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__navigateYears,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__navigateYears},
/**
  * @export
  * @type {number} */
displayedMonth: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__displayedMonth,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__displayedMonth},
/**
  * @export
  * @type {number} */
firstDayOfWeek: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__firstDayOfWeek,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__firstDayOfWeek},
/**
  * @export
  * @type {Array} */
days: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__days,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__days},
/**
  * @export
  * @type {Array} */
years: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__years,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__years},
/**
  * @export
  * @type {Array} */
months: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__months,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__months},
/**
  * @export
  * @type {Date} */
selectedDate: {
get: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.get__selectedDate,
set: org.apache.royale.jewel.beads.models.DateChooserModel.prototype.set__selectedDate}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DateChooserModel', qName: 'org.apache.royale.jewel.beads.models.DateChooserModel', kind: 'class' }], interfaces: [org.apache.royale.core.IDateChooserModel] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'viewState': { type: 'int', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'dayNames': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'monthNames': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'displayedYear': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'navigateYears': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'displayedMonth': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'firstDayOfWeek': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'days': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'years': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'months': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'selectedDate': { type: 'Date', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'}
      };
    },
    methods: function () {
      return {
        'DateChooserModel': { type: '', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'},
        'changeYear': { type: 'void', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel', parameters: function () { return [ 'Number', false ]; }},
        'changeMonth': { type: 'void', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel', parameters: function () { return [ 'Number', false ]; }},
        '|cycleArray': { type: 'Number', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel', parameters: function () { return [ 'Array', false ,'Number', false ,'Number', false ]; }},
        'getIndexForSelectedDate': { type: 'Number', declaredBy: 'org.apache.royale.jewel.beads.models.DateChooserModel'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.models.DateChooserModel.prototype.ROYALE_COMPILE_FLAGS = 10;