/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/layouts/TileLayout.as
 * org.apache.royale.jewel.beads.layouts.TileLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.layouts.TileLayout');

goog.require('org.apache.royale.core.IBorderPaddingMarginValuesImpl');
goog.require('org.apache.royale.core.IParentIUIBase');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.LayoutBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.ValuesManager');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.core.layout.EdgeData');
goog.require('org.apache.royale.core.layout.ILayoutStyleProperties');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.core.LayoutBase}
 * @implements {org.apache.royale.core.layout.ILayoutStyleProperties}
 */
org.apache.royale.jewel.beads.layouts.TileLayout = function() {
  
  this.org_apache_royale_jewel_beads_layouts_TileLayout__columnWidth = Number["NaN"];
  this.org_apache_royale_jewel_beads_layouts_TileLayout__rowHeight = Number["NaN"];
  org.apache.royale.jewel.beads.layouts.TileLayout.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.layouts.TileLayout, org.apache.royale.core.LayoutBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.layouts.TileLayout', org.apache.royale.jewel.beads.layouts.TileLayout);


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.org_apache_royale_jewel_beads_layouts_TileLayout__numColumns = 4;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.org_apache_royale_jewel_beads_layouts_TileLayout__columnWidth;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.org_apache_royale_jewel_beads_layouts_TileLayout__rowHeight;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.org_apache_royale_jewel_beads_layouts_TileLayout_verticalGapInitialized;


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.VERTICAL_GAP_STYLE = "verticalGap";


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.org_apache_royale_jewel_beads_layouts_TileLayout__verticalGap = 0;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.org_apache_royale_jewel_beads_layouts_TileLayout_horizontalGapInitialized;


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.HORIZONTAL_GAP_STYLE = "horizontalGap";


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.org_apache_royale_jewel_beads_layouts_TileLayout__horizontalGap = 0;


/**
 *  Get the component layout style and apply to if exists
 * 
 *  @asparam component the IUIBase component that host this layout
 *  @asparam cssProperty the style property in css set for the component to retrieve
 * 
 *  @see org.apache.royale.core.layout.ILayoutStyleProperties#applyStyleToLayout(component:IUIBase, cssProperty:String):void
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.core.IUIBase} component
 * @param {string} cssProperty
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.applyStyleToLayout = function(component, cssProperty) {
  var /** @type {*} */ cssValue = org.apache.royale.core.ValuesManager["valuesImpl"].getValue(component, cssProperty);
  if (cssValue !== undefined) {
    switch (cssProperty) {
      case org.apache.royale.jewel.beads.layouts.TileLayout.VERTICAL_GAP_STYLE:
        if (!this.org_apache_royale_jewel_beads_layouts_TileLayout_verticalGapInitialized) {
          this.verticalGap = Number(cssValue);
        }
        break;
      default:
        break;
    }
  }
};


/**
 *  Layout children
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 *  @royaleignorecoercion org.apache.royale.core.ILayoutHost
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @override
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.layout = function() {
  var /** @type {number} */ i = 0;
  
  var /** @type {org.apache.royale.core.IParentIUIBase} */ contentView = org.apache.royale.utils.Language.as(this.layoutView, org.apache.royale.core.IParentIUIBase);
  var /** @type {org.apache.royale.core.UIBase} */ c = org.apache.royale.utils.Language.as(contentView, org.apache.royale.core.UIBase);
  c.element.classList.add("layout");
  c.element.classList.add("tile");
  var /** @type {Array} */ children = contentView.internalChildren();
  //var /** @type {number} */ i = 0;
  var /** @type {number} */ n = (children.length) >> 0;
  if (n === 0)
    return false;
  var /** @type {number} */ realN = n;
  for (i = 0; i < n; i++) {
    child = children[i].royale_wrapper;
    if (!child.visible)
      realN--;
  }
  var /** @type {number} */ useWidth = this.columnWidth;
  var /** @type {number} */ useHeight = this.rowHeight;
  var /** @type {boolean} */ needWidth = isNaN(useWidth);
  var /** @type {boolean} */ needHeight = isNaN(useHeight);
  var /** @type {org.apache.royale.core.layout.EdgeData} */ borderMetrics = org.apache.royale.utils.Language.as(org.apache.royale.core.ValuesManager["valuesImpl"], org.apache.royale.core.IBorderPaddingMarginValuesImpl).getBorderMetrics(this.host);
  var /** @type {number} */ adjustedWidth = Math.floor(this.host.width - borderMetrics.left - borderMetrics.right);
  var /** @type {number} */ adjustedHeight = Math.floor(this.host.height - borderMetrics.top - borderMetrics.bottom);
  var /** @type {number} */ numRows = Math.ceil(realN / (this.numColumns + this.org_apache_royale_jewel_beads_layouts_TileLayout__verticalGap));
  if (needWidth || needHeight) {
    if (needWidth)
      useWidth = Math.floor(adjustedWidth / this.numColumns);
    if (needHeight) {
      if (this.host.isHeightSizedToContent())
        useHeight = 30;
      else
        useHeight = Math.floor(adjustedHeight / numRows);
    }
  }
  var /** @type {org.apache.royale.core.UIBase} */ child;
  var /** @type {number} */ numCols = Math.floor(1 + (adjustedWidth - useWidth) / (useWidth + this.org_apache_royale_jewel_beads_layouts_TileLayout__horizontalGap));
  for (i = 0; i < n; i++) {
    child = children[i].royale_wrapper;
    if (!child.visible)
      continue;
    child.width = useWidth;
    child.height = useHeight;
    var /** @type {Object} */ childW = children[i];
    if (childW == null)
      continue;
    if (i < numCols) {
      childW.style.marginTop = 0 + 'px';
    } else {
      childW.style.marginTop = this.org_apache_royale_jewel_beads_layouts_TileLayout__verticalGap + 'px';
    }
    if (i % numCols) {
      childW.style.marginLeft = this.org_apache_royale_jewel_beads_layouts_TileLayout__horizontalGap + 'px';
    } else {
      childW.style.marginLeft = 0 + 'px';
    }
    childW.royale_wrapper.dispatchEvent('sizeChanged');
  }
  return true;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__numColumns = function() {
  return this.org_apache_royale_jewel_beads_layouts_TileLayout__numColumns;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__numColumns = function(value) {
  this.org_apache_royale_jewel_beads_layouts_TileLayout__numColumns = value;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__columnWidth = function() {
  return this.org_apache_royale_jewel_beads_layouts_TileLayout__columnWidth;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__columnWidth = function(value) {
  this.org_apache_royale_jewel_beads_layouts_TileLayout__columnWidth = value;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__rowHeight = function() {
  return this.org_apache_royale_jewel_beads_layouts_TileLayout__rowHeight;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__rowHeight = function(value) {
  this.org_apache_royale_jewel_beads_layouts_TileLayout__rowHeight = value;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__verticalGap = function() {
  return this.org_apache_royale_jewel_beads_layouts_TileLayout__verticalGap;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__verticalGap = function(value) {
  this.org_apache_royale_jewel_beads_layouts_TileLayout__verticalGap = value;
  this.org_apache_royale_jewel_beads_layouts_TileLayout_verticalGapInitialized = true;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__horizontalGap = function() {
  return this.org_apache_royale_jewel_beads_layouts_TileLayout__horizontalGap;
};


org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__horizontalGap = function(value) {
  this.org_apache_royale_jewel_beads_layouts_TileLayout__horizontalGap = value;
  this.org_apache_royale_jewel_beads_layouts_TileLayout_horizontalGapInitialized = true;
};


Object.defineProperties(org.apache.royale.jewel.beads.layouts.TileLayout.prototype, /** @lends {org.apache.royale.jewel.beads.layouts.TileLayout.prototype} */ {
/**
  * @export
  * @type {number} */
numColumns: {
get: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__numColumns,
set: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__numColumns},
/**
  * @export
  * @type {number} */
columnWidth: {
get: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__columnWidth,
set: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__columnWidth},
/**
  * @export
  * @type {number} */
rowHeight: {
get: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__rowHeight,
set: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__rowHeight},
/**
  * @export
  * @type {number} */
verticalGap: {
get: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__verticalGap,
set: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__verticalGap},
/**
  * @export
  * @type {number} */
horizontalGap: {
get: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.get__horizontalGap,
set: org.apache.royale.jewel.beads.layouts.TileLayout.prototype.set__horizontalGap}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'TileLayout', qName: 'org.apache.royale.jewel.beads.layouts.TileLayout', kind: 'class' }], interfaces: [org.apache.royale.core.layout.ILayoutStyleProperties] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'numColumns': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout'},
        'columnWidth': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout'},
        'rowHeight': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout'},
        'verticalGap': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout'},
        'horizontalGap': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout'}
      };
    },
    methods: function () {
      return {
        'TileLayout': { type: '', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout'},
        'applyStyleToLayout': { type: 'void', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout', parameters: function () { return [ 'org.apache.royale.core.IUIBase', false ,'String', false ]; }},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.royale.jewel.beads.layouts.TileLayout'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.layouts.TileLayout.prototype.ROYALE_COMPILE_FLAGS = 10;