/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/controls/tabbar/AssignTabContent.as
 * org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent');

goog.require('org.apache.royale.collections.ArrayList');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.TabBar');
goog.require('org.apache.royale.jewel.TabBarContent');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent', org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent);


/**
 * @protected
 * @type {org.apache.royale.jewel.TabBar}
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.tabbar;


/**
 *  This bead adds the content to the tabbar parent, other strategies could be done
 *  extending this bead.
 * @protected
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.updateHost = function() {
  if (this.tabbar) {
    this.tabbar.parent.addElement(this.content);
    if (this.tabbar.dataProvider)
      this.content.selectedContent = org.apache.royale.utils.Language.string(this.tabbar.selectedItem[this.selectedContentProperty]);
  }
};


/**
 *  Select the right content for the selected tabbar button.
 *  Or if the dataprovider changes and a content was already selected, tries
 *  to select the tabbar button (if exits).
 * 
 *  @asparam event 
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.selectionChangedHandler = function(event) {
  if (this.content && this.tabbar.selectedIndex != -1) {
    this.content.selectedContent = org.apache.royale.utils.Language.string(this.tabbar.selectedItem[this.selectedContentProperty]);
  } else if (this.tabbar.selectedIndex == -1 && this.content.selectedContent) {
    var /** @type {number} */ len = (this.tabbar.dataProvider.length) >> 0;
    var /** @type {Object} */ item;
    for (var /** @type {number} */ index = 0; index < len; index++) {
      item = org.apache.royale.utils.Language.as(this.tabbar.dataProvider, org.apache.royale.collections.ArrayList).getItemAt(index);
      if (item[this.selectedContentProperty] == this.content.selectedContent) {
        this.tabbar.selectedItem = item;
        return;
      }
    }
  }
};


/**
 * @private
 * @type {org.apache.royale.jewel.TabBarContent}
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.org_apache_royale_jewel_beads_controls_tabbar_AssignTabContent__content;


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.org_apache_royale_jewel_beads_controls_tabbar_AssignTabContent__selectedContentProperty;


org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.set__strand = function(value) {
  this.tabbar = org.apache.royale.utils.Language.as(value, org.apache.royale.jewel.TabBar);
  this.tabbar.addEventListener("selectionChanged", org.apache.royale.utils.Language.closure(this.selectionChangedHandler, this, 'selectionChangedHandler'));
  this.updateHost();
};


org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.get__content = function() {
  return this.org_apache_royale_jewel_beads_controls_tabbar_AssignTabContent__content;
};


org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.set__content = function(value) {
  this.org_apache_royale_jewel_beads_controls_tabbar_AssignTabContent__content = value;
  this.updateHost();
};


org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.get__selectedContentProperty = function() {
  return this.org_apache_royale_jewel_beads_controls_tabbar_AssignTabContent__selectedContentProperty;
};


org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.set__selectedContentProperty = function(value) {
  this.org_apache_royale_jewel_beads_controls_tabbar_AssignTabContent__selectedContentProperty = value;
};


Object.defineProperties(org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype, /** @lends {org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.set__strand},
/**
  * @export
  * @type {org.apache.royale.jewel.TabBarContent} */
content: {
get: org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.get__content,
set: org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.set__content},
/**
  * @export
  * @type {string} */
selectedContentProperty: {
get: org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.get__selectedContentProperty,
set: org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.set__selectedContentProperty}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'AssignTabContent', qName: 'org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent'},
        'content': { type: 'org.apache.royale.jewel.TabBarContent', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent'},
        'selectedContentProperty': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent'}
      };
    },
    methods: function () {
      return {
        'AssignTabContent': { type: '', declaredBy: 'org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.tabbar.AssignTabContent.prototype.ROYALE_COMPILE_FLAGS = 10;