/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/controls/datagrid/DataGridColumnLabelsChange.as
 * org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange');

goog.require('org.apache.royale.collections.ArrayList');
goog.require('org.apache.royale.core.Bead');
goog.require('org.apache.royale.core.IDataGridModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.DataGrid');
goog.require('org.apache.royale.jewel.beads.views.DataGridView');
goog.require('org.apache.royale.jewel.supportClasses.datagrid.DataGridButtonBar');
goog.require('org.apache.royale.jewel.supportClasses.datagrid.IDataGridColumn');
goog.require('org.apache.royale.jewel.supportClasses.datagrid.IDataGridPresentationModel');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 * @constructor
 * @extends {org.apache.royale.core.Bead}
 */
org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange = function() {
  org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange, org.apache.royale.core.Bead);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange', org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange);


/**
 *  Iterate the columns array and change each column's label with the corresponding string
 *  in the presentation model columnLabels Array.
 * 
 *  @asparam event 
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype.columnLabelsChangedHandler = function(event) {
  var /** @type {org.apache.royale.jewel.DataGrid} */ _dg = org.apache.royale.utils.Language.as(this._strand, org.apache.royale.jewel.DataGrid);
  var /** @type {org.apache.royale.core.IDataGridModel} */ _sharedModel = org.apache.royale.utils.Language.as(_dg.model, org.apache.royale.core.IDataGridModel);
  var /** @type {org.apache.royale.jewel.supportClasses.datagrid.IDataGridPresentationModel} */ _presentationModel = org.apache.royale.utils.Language.as(_dg.presentationModel, org.apache.royale.jewel.supportClasses.datagrid.IDataGridPresentationModel);
  var /** @type {org.apache.royale.jewel.supportClasses.datagrid.DataGridButtonBar} */ _header = org.apache.royale.utils.Language.as(org.apache.royale.utils.Language.as(_dg.view, org.apache.royale.jewel.beads.views.DataGridView).header, org.apache.royale.jewel.supportClasses.datagrid.DataGridButtonBar);
  var /** @type {Array} */ dp = org.apache.royale.utils.Language.as(_sharedModel.columns, Array);
  var /** @type {number} */ len = (dp.length) >> 0;
  for (var /** @type {number} */ index = 0; index < len; index++) {
    var /** @type {org.apache.royale.jewel.supportClasses.datagrid.IDataGridColumn} */ column = org.apache.royale.utils.Language.as(dp[index], org.apache.royale.jewel.supportClasses.datagrid.IDataGridColumn);
    column.label = org.apache.royale.utils.Language.string(_presentationModel.columnLabels[index]);
  }
  _header.dataProvider = new org.apache.royale.collections.ArrayList(_sharedModel.columns);
};


org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype.set__strand = function(value) {
  this._strand = value;
  this.listenOnStrand("columnLabelsChanged", org.apache.royale.utils.Language.closure(this.columnLabelsChangedHandler, this, 'columnLabelsChangedHandler'));
};


Object.defineProperties(org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype, /** @lends {org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DataGridColumnLabelsChange', qName: 'org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange'}
      };
    },
    methods: function () {
      return {
        'DataGridColumnLabelsChange': { type: '', declaredBy: 'org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.datagrid.DataGridColumnLabelsChange.prototype.ROYALE_COMPILE_FLAGS = 10;