/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/controls/ToolTip.as
 * org.apache.royale.jewel.beads.controls.ToolTip
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.controls.ToolTip');

goog.require('org.apache.royale.core.IParentIUIBase');
goog.require('org.apache.royale.core.IPopUpHost');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.MouseEvent');
goog.require('org.apache.royale.geom.Point');
goog.require('org.apache.royale.jewel.supportClasses.tooltip.ToolTipLabel');
goog.require('org.apache.royale.utils.OSUtils');
goog.require('org.apache.royale.utils.PointUtils');
goog.require('org.apache.royale.utils.UIUtils');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.core.IToolTipBead');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 * @implements {org.apache.royale.core.IToolTipBead}
 */
org.apache.royale.jewel.beads.controls.ToolTip = function() {// Compiler generated Binding support implementation:
org.apache.royale.jewel.beads.controls.ToolTip.base(this, 'constructor');


this.org_apache_royale_jewel_beads_controls_ToolTip__xPos = org.apache.royale.jewel.beads.controls.ToolTip.RIGHT;
this.org_apache_royale_jewel_beads_controls_ToolTip__yPos = org.apache.royale.jewel.beads.controls.ToolTip.BOTTOM;
};
// Compiler generated Binding support implementation:
goog.inherits(org.apache.royale.jewel.beads.controls.ToolTip, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.controls.ToolTip', org.apache.royale.jewel.beads.controls.ToolTip);


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.TOP = 10000;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.BOTTOM = 10001;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.LEFT = 10002;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.RIGHT = 10003;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.MIDDLE = 10004;


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.org_apache_royale_jewel_beads_controls_ToolTip__toolTip;


/**
 * @private
 * @type {org.apache.royale.jewel.supportClasses.tooltip.ToolTipLabel}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.org_apache_royale_jewel_beads_controls_ToolTip_tt;


/**
 * @private
 * @type {org.apache.royale.core.IPopUpHost}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.org_apache_royale_jewel_beads_controls_ToolTip_host;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.org_apache_royale_jewel_beads_controls_ToolTip__xPos;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.org_apache_royale_jewel_beads_controls_ToolTip__yPos;


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.org_apache_royale_jewel_beads_controls_ToolTip__strand;


/**
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.changeHandler = function(event) {
this.org_apache_royale_jewel_beads_controls_ToolTip_tt.html = this.toolTip;
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IUIBase
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @param {org.apache.royale.events.MouseEvent} event
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.rollOverHandler = function(event) {
if (!this.toolTip || this.org_apache_royale_jewel_beads_controls_ToolTip_tt)
  return;
this.org_apache_royale_jewel_beads_controls_ToolTip__strand.addEventListener("change", org.apache.royale.utils.Language.closure(this.changeHandler, this, 'changeHandler'), false);
this.org_apache_royale_jewel_beads_controls_ToolTip__strand.addEventListener(org.apache.royale.events.MouseEvent.ROLL_OUT, org.apache.royale.utils.Language.closure(this.rollOutHandler, this, 'rollOutHandler'), false);
var /** @type {Object} */ comp = this.org_apache_royale_jewel_beads_controls_ToolTip__strand;
this.org_apache_royale_jewel_beads_controls_ToolTip_host = org.apache.royale.utils.UIUtils.findPopUpHost(comp);
if (this.org_apache_royale_jewel_beads_controls_ToolTip_tt)
  this.org_apache_royale_jewel_beads_controls_ToolTip_host.popUpParent.removeElement(this.org_apache_royale_jewel_beads_controls_ToolTip_tt);
this.org_apache_royale_jewel_beads_controls_ToolTip_tt = new org.apache.royale.jewel.supportClasses.tooltip.ToolTipLabel();
this.org_apache_royale_jewel_beads_controls_ToolTip_tt.html = this.toolTip;
this.org_apache_royale_jewel_beads_controls_ToolTip_host.popUpParent.addElement(this.org_apache_royale_jewel_beads_controls_ToolTip_tt, false);
var /** @type {org.apache.royale.geom.Point} */ pt = this.determinePosition();
this.org_apache_royale_jewel_beads_controls_ToolTip_tt.x = pt.x;
this.org_apache_royale_jewel_beads_controls_ToolTip_tt.y = pt.y;
};


/**
 * @asprivate
 * Determines the position of the toolTip.
 * @royaleignorecoercion org.apache.royale.core.IUIBase
 * @protected
 * @return {org.apache.royale.geom.Point}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.determinePosition = function() {
var /** @type {number} */ ttWidth = this.org_apache_royale_jewel_beads_controls_ToolTip_tt.width;
var /** @type {number} */ ttHeight = this.org_apache_royale_jewel_beads_controls_ToolTip_tt.height;
var /** @type {Object} */ comp = this.org_apache_royale_jewel_beads_controls_ToolTip__strand;
var /** @type {number} */ x;
var /** @type {number} */ y;
switch (this.org_apache_royale_jewel_beads_controls_ToolTip__xPos) {
  case org.apache.royale.jewel.beads.controls.ToolTip.LEFT:
    x = -ttWidth;
    break;
  case org.apache.royale.jewel.beads.controls.ToolTip.MIDDLE:
    x = (comp.width - ttWidth) / 2;
    break;
  case org.apache.royale.jewel.beads.controls.ToolTip.RIGHT:
    x = comp.width;
    break;
}
switch (this.org_apache_royale_jewel_beads_controls_ToolTip__yPos) {
  case org.apache.royale.jewel.beads.controls.ToolTip.TOP:
    y = -ttHeight;
    break;
  case org.apache.royale.jewel.beads.controls.ToolTip.MIDDLE:
    y = (comp.height - ttHeight) / 2;
    break;
  case org.apache.royale.jewel.beads.controls.ToolTip.BOTTOM:
    y = comp.height;
    break;
}
var /** @type {org.apache.royale.geom.Point} */ pt = new org.apache.royale.geom.Point(x, y);
pt = org.apache.royale.utils.PointUtils.localToGlobal(pt, comp);
pt.x = Math.max(pt.x, 0);
pt.y = Math.max(pt.y, 0);
var /** @type {number} */ screenHeight = org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_controls_ToolTip_host.popUpParent, org.apache.royale.core.IParentIUIBase).height;
var /** @type {number} */ extraHeight = 1 + pt.y + ttHeight - screenHeight;
if (extraHeight > 0) {
  pt.y -= extraHeight;
}
var /** @type {number} */ screenWidth = org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_controls_ToolTip_host.popUpParent, org.apache.royale.core.IParentIUIBase).width;
var /** @type {number} */ extraWidth = 1 + pt.x + ttWidth - screenWidth;
if (extraWidth > 0) {
  pt.x -= extraWidth;
}
return pt;
};


/**
 * rollOutHandler
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.MouseEvent=} event
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.rollOutHandler = function(event) {
event = typeof event !== 'undefined' ? event : null;
this.removeTip();
};


/**                         	
 *  @copy org.apache.royale.core.IToolTipBead#removeTip()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 *  @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @export
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.removeTip = function() {
this.org_apache_royale_jewel_beads_controls_ToolTip__strand.removeEventListener("change", org.apache.royale.utils.Language.closure(this.changeHandler, this, 'changeHandler'), false);
this.org_apache_royale_jewel_beads_controls_ToolTip__strand.removeEventListener(org.apache.royale.events.MouseEvent.MOUSE_OUT, org.apache.royale.utils.Language.closure(this.rollOutHandler, this, 'rollOutHandler'), false);
if (this.org_apache_royale_jewel_beads_controls_ToolTip_tt) {
  this.org_apache_royale_jewel_beads_controls_ToolTip_host.popUpParent.removeElement(this.org_apache_royale_jewel_beads_controls_ToolTip_tt);
  this.org_apache_royale_jewel_beads_controls_ToolTip_tt = null;
}
};


org.apache.royale.jewel.beads.controls.ToolTip.prototype.get__toolTip = function() {
return this.org_apache_royale_jewel_beads_controls_ToolTip__toolTip;
};


org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__toolTip = function(value) {
this.org_apache_royale_jewel_beads_controls_ToolTip__toolTip = value;
};


org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__xPos = function(pos) {
this.org_apache_royale_jewel_beads_controls_ToolTip__xPos = pos;
};


org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__yPos = function(pos) {
this.org_apache_royale_jewel_beads_controls_ToolTip__yPos = pos;
};


org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__strand = function(value) {
this.org_apache_royale_jewel_beads_controls_ToolTip__strand = value;
if (org.apache.royale.utils.OSUtils.getOS() != org.apache.royale.utils.OSUtils.IOS_OS) {
  this.org_apache_royale_jewel_beads_controls_ToolTip__strand.addEventListener(org.apache.royale.events.MouseEvent.ROLL_OVER, org.apache.royale.utils.Language.closure(this.rollOverHandler, this, 'rollOverHandler'), false);
}
};


Object.defineProperties(org.apache.royale.jewel.beads.controls.ToolTip.prototype, /** @lends {org.apache.royale.jewel.beads.controls.ToolTip.prototype} */ {
/**
  * @export
  * @type {string} */
toolTip: {
get: org.apache.royale.jewel.beads.controls.ToolTip.prototype.get__toolTip,
set: org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__toolTip},
/**
  * @export
  * @type {number} */
xPos: {
set: org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__xPos},
/**
  * @export
  * @type {number} */
yPos: {
set: org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__yPos},
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.controls.ToolTip.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'ToolTip', qName: 'org.apache.royale.jewel.beads.controls.ToolTip', kind: 'class' }], interfaces: [org.apache.royale.core.IBead, org.apache.royale.core.IToolTipBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.ROYALE_REFLECTION_INFO = function () {
return {
  accessors: function () {
    return {
      'toolTip': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.controls.ToolTip', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'toolTipChanged' } ] } ]; }},
      'xPos': { type: 'int', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controls.ToolTip'},
      'yPos': { type: 'int', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controls.ToolTip'},
      'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controls.ToolTip'}
    };
  },
  methods: function () {
    return {
      'ToolTip': { type: '', declaredBy: 'org.apache.royale.jewel.beads.controls.ToolTip'},
      'removeTip': { type: 'void', declaredBy: 'org.apache.royale.jewel.beads.controls.ToolTip'}
    };
  }
};
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.ToolTip.prototype.ROYALE_COMPILE_FLAGS = 10;