/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/Wizard.as
 * org.apache.royale.jewel.Wizard
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.Wizard');

goog.require('org.apache.royale.core.IChild');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.Group');
goog.require('org.apache.royale.jewel.WizardContent');
goog.require('org.apache.royale.jewel.WizardPage');
goog.require('org.apache.royale.jewel.beads.models.WizardModel');
goog.require('org.apache.royale.jewel.beads.models.WizardStep');
goog.require('org.apache.royale.jewel.beads.views.WizardView');
goog.require('org.apache.royale.core.IContainerBaseStrandChildrenHost');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.Group}
 * @implements {org.apache.royale.core.IContainerBaseStrandChildrenHost}
 */
org.apache.royale.jewel.Wizard = function() {
  org.apache.royale.jewel.Wizard.base(this, 'constructor');
  this.typeNames = "jewel wizard";
};
goog.inherits(org.apache.royale.jewel.Wizard, org.apache.royale.jewel.Group);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.Wizard', org.apache.royale.jewel.Wizard);


/**
 * Update currentStep by name finding the appropiate step
 * 
 * @asparam stepName, that is the "id" of the content (the WizardPage) to activate
 * 
 * @see org.apache.royale.jewel.WizardContent.selectedContent
 * @export
 * @param {string} stepName
 */
org.apache.royale.jewel.Wizard.prototype.showPage = function(stepName) {
  var /** @type {org.apache.royale.jewel.beads.models.WizardStep} */ step = this.findStepByName(stepName);
  if (step) {
    this.currentStep = step;
  } else {
    throw new Error('Unknown wizard step:' + stepName);
  }
};


/**
 * @export
 * @param {string} name
 * @return {org.apache.royale.jewel.beads.models.WizardStep}
 */
org.apache.royale.jewel.Wizard.prototype.findStepByName = function(name) {
  var /** @type {number} */ n = this.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.royale.jewel.WizardPage} */ page = org.apache.royale.utils.Language.as(this.getElementAt(i), org.apache.royale.jewel.WizardPage);
    if (page.step.name == name) {
      return page.step;
    }
  }
  return null;
};


/**
 * @export
 * @type {org.apache.royale.core.UIBase}
 */
org.apache.royale.jewel.Wizard.prototype.previousButton = null;


/**
 * @export
 * @type {org.apache.royale.core.UIBase}
 */
org.apache.royale.jewel.Wizard.prototype.nextButton = null;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.jewel.beads.views.WizardView
 * @royaleignorecoercion org.apache.royale.jewel.WizardPage
 * @export
 * @override
 */
org.apache.royale.jewel.Wizard.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  var /** @type {Object} */ page = c;
  page.model = this.model;
  var /** @type {Object} */ wizardView = this.view;
  wizardView.contentArea.addElement(page, dispatchEvent);
  wizardView.contentArea.dispatchEvent(new org.apache.royale.events.Event("layoutNeeded"));
  page.step.page = c;
  page.addWizardListeners(this);
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.jewel.beads.views.WizardView
 * @royaleignorecoercion org.apache.royale.jewel.WizardPage
 * @export
 * @override
 */
org.apache.royale.jewel.Wizard.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  var /** @type {Object} */ page = c;
  page.model = this.model;
  var /** @type {Object} */ wizardView = this.view;
  wizardView.contentArea.addElementAt(page, index, dispatchEvent);
  wizardView.contentArea.dispatchEvent(new org.apache.royale.events.Event("layoutNeeded"));
  page.step.page = c;
  page.addWizardListeners(this);
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.jewel.beads.views.WizardView
 * @royaleignorecoercion org.apache.royale.jewel.WizardPage
 * @export
 * @override
 */
org.apache.royale.jewel.Wizard.prototype.getElementIndex = function(c) {
  var /** @type {Object} */ wizardView = this.view;
  return wizardView.contentArea.getElementIndex(c);
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.jewel.beads.views.WizardView
 * @royaleignorecoercion org.apache.royale.jewel.WizardPage
 * @export
 * @override
 */
org.apache.royale.jewel.Wizard.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  var /** @type {Object} */ wizardView = this.view;
  wizardView.contentArea.removeElement(c, dispatchEvent);
  var /** @type {Object} */ page = c;
  page.removeWizardListeners(this);
  page.step.page = null;
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.jewel.beads.views.WizardView
 * @export
 * @override
 */
org.apache.royale.jewel.Wizard.prototype.getElementAt = function(index) {
  var /** @type {Object} */ wizardView = this.view;
  return wizardView.contentArea.getElementAt(index);
};


/**
 * @export
 * @param {org.apache.royale.core.IChild} c
 * @param {boolean=} dispatchEvent
 */
org.apache.royale.jewel.Wizard.prototype.$addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.royale.jewel.Wizard.superClass_.addElement.apply(this, [ c, dispatchEvent] );
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {org.apache.royale.core.IChild} c
 * @param {number} index
 * @param {boolean=} dispatchEvent
 */
org.apache.royale.jewel.Wizard.prototype.$addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.royale.jewel.Wizard.superClass_.addElementAt.apply(this, [ c, index, dispatchEvent] );
};


/**
 * @export
 * @param {number} index
 * @return {org.apache.royale.core.IChild}
 */
org.apache.royale.jewel.Wizard.prototype.$getElementAt = function(index) {
  return org.apache.royale.jewel.Wizard.superClass_.getElementAt.apply(this, [ index] );
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {org.apache.royale.core.IChild} c
 * @param {boolean=} dispatchEvent
 */
org.apache.royale.jewel.Wizard.prototype.$removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.royale.jewel.Wizard.superClass_.removeElement.apply(this, [ c, dispatchEvent] );
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {org.apache.royale.core.IChild} c
 * @return {number}
 */
org.apache.royale.jewel.Wizard.prototype.$getElementIndex = function(c) {
  return org.apache.royale.jewel.Wizard.superClass_.getElementIndex.apply(this, [ c] );
};


org.apache.royale.jewel.Wizard.prototype.get__title = function() {
  return this.model.text;
};


org.apache.royale.jewel.Wizard.prototype.set__title = function(value) {
  this.model.text = value;
};


org.apache.royale.jewel.Wizard.prototype.get__activateEffect = function() {
  return this.model.activateEffect;
};


org.apache.royale.jewel.Wizard.prototype.set__activateEffect = function(value) {
  this.model.activateEffect = value;
};


org.apache.royale.jewel.Wizard.prototype.get__htmlTitle = function() {
  return this.model.html;
};


org.apache.royale.jewel.Wizard.prototype.set__htmlTitle = function(value) {
  this.model.html = value;
};


org.apache.royale.jewel.Wizard.prototype.get__content = function() {
  return org.apache.royale.utils.Language.as(org.apache.royale.utils.Language.as(this.view, org.apache.royale.jewel.beads.views.WizardView).contentArea, org.apache.royale.jewel.WizardContent);
};


org.apache.royale.jewel.Wizard.prototype.get__currentStep = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.WizardModel, true).currentStep;
};


org.apache.royale.jewel.Wizard.prototype.set__currentStep = function(value) {
  this.model.currentStep = value;
};


org.apache.royale.jewel.Wizard.prototype.get__numElements = function() {
  var /** @type {org.apache.royale.jewel.beads.views.WizardView} */ wizardView = this.view;
  return wizardView.contentArea.numElements;
};


org.apache.royale.jewel.Wizard.prototype.get__$numElements = function() {
  return org.apache.royale.jewel.Wizard.superClass_.get__numElements.apply(this);
};


Object.defineProperties(org.apache.royale.jewel.Wizard.prototype, /** @lends {org.apache.royale.jewel.Wizard.prototype} */ {
/**
  * @export
  * @type {string} */
title: {
get: org.apache.royale.jewel.Wizard.prototype.get__title,
set: org.apache.royale.jewel.Wizard.prototype.set__title},
/**
  * @export
  * @type {boolean} */
activateEffect: {
get: org.apache.royale.jewel.Wizard.prototype.get__activateEffect,
set: org.apache.royale.jewel.Wizard.prototype.set__activateEffect},
/**
  * @export
  * @type {string} */
htmlTitle: {
get: org.apache.royale.jewel.Wizard.prototype.get__htmlTitle,
set: org.apache.royale.jewel.Wizard.prototype.set__htmlTitle},
/**
  * @export
  * @type {org.apache.royale.jewel.WizardContent} */
content: {
get: org.apache.royale.jewel.Wizard.prototype.get__content},
/**
  * @export
  * @type {org.apache.royale.jewel.beads.models.WizardStep} */
currentStep: {
get: org.apache.royale.jewel.Wizard.prototype.get__currentStep,
set: org.apache.royale.jewel.Wizard.prototype.set__currentStep},
/**
  * @export
  * @type {number} */
numElements: {
get: org.apache.royale.jewel.Wizard.prototype.get__numElements},
/**
  * @export
  * @type {number} */
$numElements: {
get: org.apache.royale.jewel.Wizard.prototype.get__$numElements}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.Wizard.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Wizard', qName: 'org.apache.royale.jewel.Wizard', kind: 'class' }], interfaces: [org.apache.royale.core.IContainerBaseStrandChildrenHost] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.Wizard.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'previousButton': { type: 'org.apache.royale.core.UIBase', get_set: function (/** org.apache.royale.jewel.Wizard */ inst, /** * */ v) {return v !== undefined ? inst.previousButton = v : inst.previousButton;}},
        'nextButton': { type: 'org.apache.royale.core.UIBase', get_set: function (/** org.apache.royale.jewel.Wizard */ inst, /** * */ v) {return v !== undefined ? inst.nextButton = v : inst.nextButton;}}
      };
    },
    accessors: function () {
      return {
        'title': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Wizard'},
        'activateEffect': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Wizard'},
        'htmlTitle': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Wizard'},
        'content': { type: 'org.apache.royale.jewel.WizardContent', access: 'readonly', declaredBy: 'org.apache.royale.jewel.Wizard'},
        'currentStep': { type: 'org.apache.royale.jewel.beads.models.WizardStep', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Wizard', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change' } ] } ]; }},
        'numElements': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.jewel.Wizard'},
        '$numElements': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.jewel.Wizard'}
      };
    },
    methods: function () {
      return {
        'Wizard': { type: '', declaredBy: 'org.apache.royale.jewel.Wizard'},
        'showPage': { type: 'void', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'String', false ]; }},
        'findStepByName': { type: 'org.apache.royale.jewel.beads.models.WizardStep', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'String', false ]; }},
        'addElement': { type: 'void', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ,'Boolean', true ]; }},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ,'int', false ,'Boolean', true ]; }},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ]; }},
        'removeElement': { type: 'void', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ,'Boolean', true ]; }},
        'getElementAt': { type: 'org.apache.royale.core.IChild', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'int', false ]; }},
        '$addElement': { type: 'void', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ,'Boolean', true ]; }},
        '$addElementAt': { type: 'void', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ,'int', false ,'Boolean', true ]; }},
        '$getElementAt': { type: 'org.apache.royale.core.IChild', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'int', false ]; }},
        '$removeElement': { type: 'void', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ,'Boolean', true ]; }},
        '$getElementIndex': { type: 'int', declaredBy: 'org.apache.royale.jewel.Wizard', parameters: function () { return [ 'org.apache.royale.core.IChild', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.Wizard.prototype.ROYALE_COMPILE_FLAGS = 10;