/**
 * Generated by Apache Royale Compiler from org/apache/royale/display/GraphicsStroke.as
 * org.apache.royale.display.GraphicsStroke
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.display.GraphicsStroke');
/* Royale Static Dependency List: org.apache.royale.display.CapsStyle,org.apache.royale.display.JointStyle,org.apache.royale.display.LineScaleMode*/

goog.require('org.apache.royale.display.CapsStyle');
goog.require('org.apache.royale.display.Graphics');
goog.require('org.apache.royale.display.IGraphicsFill');
goog.require('org.apache.royale.display.JointStyle');
goog.require('org.apache.royale.display.LineScaleMode');
goog.require('org.apache.royale.display.IGraphicsData');
goog.require('org.apache.royale.display.IGraphicsStroke');



/**
 * @constructor
 * @implements {org.apache.royale.display.IGraphicsStroke}
 * @implements {org.apache.royale.display.IGraphicsData}
 * @param {number=} thickness
 * @param {boolean=} pixelHinting
 * @param {string=} scaleMode
 * @param {string=} caps
 * @param {string=} joints
 * @param {number=} miterLimit
 * @param {org.apache.royale.display.IGraphicsFill=} fill
 */
org.apache.royale.display.GraphicsStroke = function(thickness, pixelHinting, scaleMode, caps, joints, miterLimit, fill) {
  thickness = typeof thickness !== 'undefined' ? thickness : NaN;
  pixelHinting = typeof pixelHinting !== 'undefined' ? pixelHinting : false;
  scaleMode = typeof scaleMode !== 'undefined' ? scaleMode : "normal";
  caps = typeof caps !== 'undefined' ? caps : "none";
  joints = typeof joints !== 'undefined' ? joints : "round";
  miterLimit = typeof miterLimit !== 'undefined' ? miterLimit : 3.0;
  fill = typeof fill !== 'undefined' ? fill : null;
  this.thickness = thickness;
  this.pixelHinting = pixelHinting;
  this.scaleMode = scaleMode;
  this.caps = caps;
  this.joints = joints;
  this.miterLimit = miterLimit;
  this.fill = fill;
};


/**
 * @private
 * @const
 * @type {Array}
 */
org.apache.royale.display.GraphicsStroke.VALID_CAPS = [org.apache.royale.display.CapsStyle.ROUND, org.apache.royale.display.CapsStyle.NONE, org.apache.royale.display.CapsStyle.SQUARE];


/**
 * @private
 * @const
 * @type {Array}
 */
org.apache.royale.display.GraphicsStroke.VALID_JOINTS = [org.apache.royale.display.JointStyle.ROUND, org.apache.royale.display.JointStyle.BEVEL, org.apache.royale.display.JointStyle.MITER];


/**
 * @private
 * @const
 * @type {Array}
 */
org.apache.royale.display.GraphicsStroke.VALID_SCALE_MODES = [org.apache.royale.display.LineScaleMode.NORMAL, org.apache.royale.display.LineScaleMode.HORIZONTAL, org.apache.royale.display.LineScaleMode.NONE, org.apache.royale.display.LineScaleMode.VERTICAL];


/**
 * @private
 * @type {string}
 */
org.apache.royale.display.GraphicsStroke.prototype.org_apache_royale_display_GraphicsStroke__caps;


/**
 * @type {org.apache.royale.display.IGraphicsFill}
 */
org.apache.royale.display.GraphicsStroke.prototype.fill;


/**
 * @private
 * @type {string}
 */
org.apache.royale.display.GraphicsStroke.prototype.org_apache_royale_display_GraphicsStroke__joints;


/**
 * @type {number}
 */
org.apache.royale.display.GraphicsStroke.prototype.miterLimit = 3;


/**
 * @type {boolean}
 */
org.apache.royale.display.GraphicsStroke.prototype.pixelHinting = false;


/**
 * @private
 * @type {string}
 */
org.apache.royale.display.GraphicsStroke.prototype.org_apache_royale_display_GraphicsStroke__scaleMode;


/**
 * @type {number}
 */
org.apache.royale.display.GraphicsStroke.prototype.thickness = NaN;


/**
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPathElement} element
 * @return {SVGPathElement}
 */
org.apache.royale.display.GraphicsStroke.prototype.apply = function(graphics, element) {
  var /** @type {number} */ thickness = this.thickness;
  if (isNaN(thickness)) {
    element.setAttributeNS(null, 'stroke', 'none');
    return element;
  }
  element = this.fill.applyStroke(graphics, element);
  if (thickness < 0)
    thickness = 0;
  if (thickness > 255)
    thickness = 255;
  if (thickness == 0) {
    element.setAttributeNS(null, 'vector-effect', 'non-scaling-stroke');
    element.setAttributeNS(null, 'stroke-width', '0.5');
  } else {
    element.setAttributeNS(null, 'stroke-width', '' + thickness);
  }
  var /** @type {string} */ str_val = this.caps;
  if (str_val == org.apache.royale.display.CapsStyle.NONE)
    str_val = 'butt';
  element.setAttributeNS(null, 'stroke-linecap', str_val);
  str_val = this.joints;
  element.setAttributeNS(null, 'stroke-linejoin', str_val);
  if (str_val == org.apache.royale.display.JointStyle.MITER) {
    var /** @type {number} */ mVal = this.miterLimit;
    if (mVal < 1)
      mVal = 1;
    if (mVal > 255)
      mVal = 255;
    element.setAttributeNS(null, 'stroke-miterlimit', mVal.toString());
  }
  str_val = this.scaleMode;
  if (str_val == org.apache.royale.display.LineScaleMode.NONE && thickness > 0) {
    element.setAttributeNS(null, 'vector-effect', 'non-scaling-stroke');
  }
  return element;
};


org.apache.royale.display.GraphicsStroke.prototype.get__caps = function() {
  return this.org_apache_royale_display_GraphicsStroke__caps ? this.org_apache_royale_display_GraphicsStroke__caps : (this.org_apache_royale_display_GraphicsStroke__caps = org.apache.royale.utils.Language.string(org.apache.royale.display.GraphicsStroke.VALID_CAPS[0]));
};


org.apache.royale.display.GraphicsStroke.prototype.set__caps = function(value) {
  if (org.apache.royale.display.GraphicsStroke.VALID_CAPS.indexOf(value) != -1) {
    this.org_apache_royale_display_GraphicsStroke__caps = value;
  }
  else
    throw new Error('Error #2008: Parameter caps must be one of the accepted values.');
};


org.apache.royale.display.GraphicsStroke.prototype.get__joints = function() {
  return this.org_apache_royale_display_GraphicsStroke__joints ? this.org_apache_royale_display_GraphicsStroke__joints : (this.org_apache_royale_display_GraphicsStroke__joints = org.apache.royale.utils.Language.string(org.apache.royale.display.GraphicsStroke.VALID_JOINTS[0]));
};


org.apache.royale.display.GraphicsStroke.prototype.set__joints = function(value) {
  if (org.apache.royale.display.GraphicsStroke.VALID_JOINTS.indexOf(value) != -1) {
    this.org_apache_royale_display_GraphicsStroke__joints = value;
  }
  else
    throw new Error('Error #2008: Parameter joints must be one of the accepted values.');
};


org.apache.royale.display.GraphicsStroke.prototype.get__scaleMode = function() {
  return this.org_apache_royale_display_GraphicsStroke__scaleMode ? this.org_apache_royale_display_GraphicsStroke__scaleMode : (this.org_apache_royale_display_GraphicsStroke__scaleMode = org.apache.royale.utils.Language.string(org.apache.royale.display.GraphicsStroke.VALID_SCALE_MODES[0]));
};


org.apache.royale.display.GraphicsStroke.prototype.set__scaleMode = function(value) {
  if (org.apache.royale.display.GraphicsStroke.VALID_SCALE_MODES.indexOf(value) != -1) {
    this.org_apache_royale_display_GraphicsStroke__scaleMode = value;
  }
  else
    throw new Error('Error #2008: Parameter scaleMode must be one of the accepted values.');
};


Object.defineProperties(org.apache.royale.display.GraphicsStroke.prototype, /** @lends {org.apache.royale.display.GraphicsStroke.prototype} */ {
/**
  * @type {string} */
caps: {
get: org.apache.royale.display.GraphicsStroke.prototype.get__caps,
set: org.apache.royale.display.GraphicsStroke.prototype.set__caps},
/**
  * @type {string} */
joints: {
get: org.apache.royale.display.GraphicsStroke.prototype.get__joints,
set: org.apache.royale.display.GraphicsStroke.prototype.set__joints},
/**
  * @type {string} */
scaleMode: {
get: org.apache.royale.display.GraphicsStroke.prototype.get__scaleMode,
set: org.apache.royale.display.GraphicsStroke.prototype.set__scaleMode}}
);