/**
 * Generated by Apache Royale Compiler from org/apache/royale/display/GraphicsSolidFill.as
 * org.apache.royale.display.GraphicsSolidFill
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.display.GraphicsSolidFill');

goog.require('org.apache.royale.display.Graphics');
goog.require('org.apache.royale.display.IGraphicsData');
goog.require('org.apache.royale.display.IGraphicsFill');



/**
 * @constructor
 * @implements {org.apache.royale.display.IGraphicsFill}
 * @implements {org.apache.royale.display.IGraphicsData}
 * @param {number=} color
 * @param {number=} alpha
 */
org.apache.royale.display.GraphicsSolidFill = function(color, alpha) {
  color = typeof color !== 'undefined' ? color : 0;
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  this.color = color;
  this.alpha = alpha;
};


/**
 * @type {number}
 */
org.apache.royale.display.GraphicsSolidFill.prototype.alpha = 1.0;


/**
 * @type {number}
 */
org.apache.royale.display.GraphicsSolidFill.prototype.color = 0;


/**
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPathElement} element
 */
org.apache.royale.display.GraphicsSolidFill.prototype.apply = function(graphics, element) {
  var /** @type {string} */ hex = '#' + ('00000' + this.color.toString(16)).substr(-6);
  element.setAttributeNS(null, 'fill', hex);
  var /** @type {number} */ alpha = this.alpha;
  if (alpha < 0)
    alpha = 0;
  if (alpha < 1) {
    element.setAttributeNS(null, 'fill-opacity', alpha.toString());
  }
};


/**
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPathElement} element
 * @return {SVGPathElement}
 */
org.apache.royale.display.GraphicsSolidFill.prototype.applyStroke = function(graphics, element) {
  var /** @type {string} */ hex = '#' + ('00000' + this.color.toString(16)).substr(-6);
  element.setAttributeNS(null, 'stroke', hex);
  var /** @type {number} */ alpha = this.alpha;
  if (alpha < 0)
    alpha = 0;
  if (alpha < 1) {
    element.setAttributeNS(null, 'stroke-opacity', alpha.toString());
  }
  return element;
};