/**
 * Generated by Apache Royale Compiler from org\apache\royale\graphics\PathBuilder.as
 * org.apache.royale.graphics.PathBuilder
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.graphics.PathBuilder');

goog.require('org.apache.royale.graphics.CubicCurve');
goog.require('org.apache.royale.graphics.IPathCommand');
goog.require('org.apache.royale.graphics.LineTo');
goog.require('org.apache.royale.graphics.MoveTo');
goog.require('org.apache.royale.graphics.QuadraticCurve');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @constructor
 * @param {boolean=} closedPath
 */
org.apache.royale.graphics.PathBuilder = function(closedPath) {
  closedPath = typeof closedPath !== 'undefined' ? closedPath : false;
  this.org_apache_royale_graphics_PathBuilder_commands = org.apache.royale.utils.Language.Vector();
  this.closedPath = closedPath;
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.graphics.PathBuilder', org.apache.royale.graphics.PathBuilder);


/**
 *  Clears the path data
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.8
 * @export
 */
org.apache.royale.graphics.PathBuilder.prototype.clear = function() {
  this.org_apache_royale_graphics_PathBuilder_commands.length = 0;
};


/**
 *  Gets a string representation of the path which can be used in SVG.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @export
 * @return {string}
 */
org.apache.royale.graphics.PathBuilder.prototype.getPathString = function() {
  var /** @type {string} */ pathString = this.org_apache_royale_graphics_PathBuilder_commands.join(" ");
  if (this.closedPath) {
    pathString += " Z";
  }
  return pathString;
};


/**
 * @export
 * @param {Object} ctx
 */
org.apache.royale.graphics.PathBuilder.prototype.draw = function(ctx) {
  var /** @type {number} */ i = -1;
  var /** @type {number} */ len = this.org_apache_royale_graphics_PathBuilder_commands.length;
  while (++i < len) {
    this.org_apache_royale_graphics_PathBuilder_commands[i].execute(ctx);
  }
};


/**
 * @private
 * @type {Array}
 */
org.apache.royale.graphics.PathBuilder.prototype.org_apache_royale_graphics_PathBuilder_commands;


/**
 * @export
 * @type {boolean}
 */
org.apache.royale.graphics.PathBuilder.prototype.closedPath;


/**
 *  Adds a lineTo command
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @export
 * @param {number} x
 * @param {number} y
 */
org.apache.royale.graphics.PathBuilder.prototype.lineTo = function(x, y) {
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x, y));
};


/**
 *  Adds a moveTo command
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @export
 * @param {number} x
 * @param {number} y
 */
org.apache.royale.graphics.PathBuilder.prototype.moveTo = function(x, y) {
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.MoveTo(x, y));
};


/**
 *  Adds a quadraticCurveTo command
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @export
 * @param {number} controlX
 * @param {number} controlY
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.royale.graphics.PathBuilder.prototype.quadraticCurveTo = function(controlX, controlY, anchorX, anchorY) {
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(controlX, controlY, anchorX, anchorY));
};


/**
 *  Adds a cubicCurveTo command
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @export
 * @param {number} controlX1
 * @param {number} controlY1
 * @param {number} controlX2
 * @param {number} controlY2
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.royale.graphics.PathBuilder.prototype.cubicCurveTo = function(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY) {
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.CubicCurve(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY));
};


/**
 *  Adds a drawRect command
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.royale.graphics.PathBuilder.prototype.drawRect = function(x, y, width, height) {
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.MoveTo(x, y));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x + width, y));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x + width, y + height));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x, y + height));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x, y));
};


/**
 *  Adds a drawRoundRectComplex command
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 0.6
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} topLeftRadius
 * @param {number} topRightRadius
 * @param {number} bottomLeftRadius
 * @param {number} bottomRightRadius
 */
org.apache.royale.graphics.PathBuilder.prototype.drawRoundRectComplex = function(x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius) {
  var /** @type {Array} */ b = [];
  var /** @type {number} */ xw = x + width;
  var /** @type {number} */ yh = y + height;
  var /** @type {number} */ minSize = width < height ? width * 2 : height * 2;
  topLeftRadius = topLeftRadius < minSize ? topLeftRadius : minSize;
  topRightRadius = topRightRadius < minSize ? topRightRadius : minSize;
  bottomLeftRadius = bottomLeftRadius < minSize ? bottomLeftRadius : minSize;
  bottomRightRadius = bottomRightRadius < minSize ? bottomRightRadius : minSize;
  var /** @type {number} */ a = bottomRightRadius * 0.292893218813453;
  var /** @type {number} */ s = bottomRightRadius * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.MoveTo(xw, yh - bottomRightRadius));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw, yh - s, xw - a, yh - a));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw - s, yh, xw - bottomRightRadius, yh));
  a = bottomLeftRadius * 0.292893218813453;
  s = bottomLeftRadius * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x + bottomLeftRadius, yh));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x + s, yh, x + a, yh - a));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x, yh - s, x, yh - bottomLeftRadius));
  a = topLeftRadius * 0.292893218813453;
  s = topLeftRadius * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x, y + topLeftRadius));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x, y + s, x + a, y + a));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x + s, y, x + topLeftRadius, y));
  a = topRightRadius * 0.292893218813453;
  s = topRightRadius * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(xw - topRightRadius, y));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw - s, y, xw - a, y + a));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw, y + s, xw, y + topRightRadius));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(xw, yh - bottomRightRadius));
};


/**
 * Draws a rounded rectangle using the size of individual x and y radii to 
 * draw the rounded corners. 
 * 
 * @asparam x The horizontal position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam y The vertical position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam width The width of the round rectangle, in pixels.
 * 
 * @asparam height The height of the round rectangle, in pixels.
 * 
 * @asparam radiusX The default radiusX to use, if corner-specific values are not specified.
 * This value must be specified.
 * 
 * @asparam radiusY The default radiusY to use, if corner-specific values are not specified. 
 * If 0, the value of radiusX is used.
 * 
 * @asparam topLeftRadiusX The x radius of the upper-left corner, in pixels. If NaN, 
 * the value of radiusX is used.
 * 
 * @asparam topLeftRadiusY The y radius of the upper-left corner, in pixels. If NaN,
 * the value of topLeftRadiusX is used.
 * 
 * @asparam topRightRadiusX The x radius of the upper-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam topRightRadiusY The y radius of the upper-right corner, in pixels. If NaN,
 * the value of topRightRadiusX is used.
 * 
 * @asparam bottomLeftRadiusX The x radius of the bottom-left corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomLeftRadiusY The y radius of the bottom-left corner, in pixels. If NaN,
 * the value of bottomLeftRadiusX is used.
 * 
 * @asparam bottomRightRadiusX The x radius of the bottom-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomRightRadiusY The y radius of the bottom-right corner, in pixels. If NaN,
 * the value of bottomRightRadiusX is used.
 * 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Royale 1.0.0
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} radiusX
 * @param {number} radiusY
 * @param {number} topLeftRadiusX
 * @param {number} topLeftRadiusY
 * @param {number} topRightRadiusX
 * @param {number} topRightRadiusY
 * @param {number} bottomLeftRadiusX
 * @param {number} bottomLeftRadiusY
 * @param {number} bottomRightRadiusX
 * @param {number} bottomRightRadiusY
 */
org.apache.royale.graphics.PathBuilder.prototype.drawRoundRectComplex2 = function(x, y, width, height, radiusX, radiusY, topLeftRadiusX, topLeftRadiusY, topRightRadiusX, topRightRadiusY, bottomLeftRadiusX, bottomLeftRadiusY, bottomRightRadiusX, bottomRightRadiusY) {
  var /** @type {number} */ xw = x + width;
  var /** @type {number} */ yh = y + height;
  var /** @type {number} */ maxXRadius = width / 2;
  var /** @type {number} */ maxYRadius = height / 2;
  if (radiusY == 0)
    radiusY = radiusX;
  if (isNaN(topLeftRadiusX))
    topLeftRadiusX = radiusX;
  if (isNaN(topLeftRadiusY))
    topLeftRadiusY = topLeftRadiusX;
  if (isNaN(topRightRadiusX))
    topRightRadiusX = radiusX;
  if (isNaN(topRightRadiusY))
    topRightRadiusY = topRightRadiusX;
  if (isNaN(bottomLeftRadiusX))
    bottomLeftRadiusX = radiusX;
  if (isNaN(bottomLeftRadiusY))
    bottomLeftRadiusY = bottomLeftRadiusX;
  if (isNaN(bottomRightRadiusX))
    bottomRightRadiusX = radiusX;
  if (isNaN(bottomRightRadiusY))
    bottomRightRadiusY = bottomRightRadiusX;
  if (topLeftRadiusX > maxXRadius)
    topLeftRadiusX = maxXRadius;
  if (topLeftRadiusY > maxYRadius)
    topLeftRadiusY = maxYRadius;
  if (topRightRadiusX > maxXRadius)
    topRightRadiusX = maxXRadius;
  if (topRightRadiusY > maxYRadius)
    topRightRadiusY = maxYRadius;
  if (bottomLeftRadiusX > maxXRadius)
    bottomLeftRadiusX = maxXRadius;
  if (bottomLeftRadiusY > maxYRadius)
    bottomLeftRadiusY = maxYRadius;
  if (bottomRightRadiusX > maxXRadius)
    bottomRightRadiusX = maxXRadius;
  if (bottomRightRadiusY > maxYRadius)
    bottomRightRadiusY = maxYRadius;
  var /** @type {number} */ aX = bottomRightRadiusX * 0.292893218813453;
  var /** @type {number} */ aY = bottomRightRadiusY * 0.292893218813453;
  var /** @type {number} */ sX = bottomRightRadiusX * 0.585786437626905;
  var /** @type {number} */ sY = bottomRightRadiusY * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.MoveTo(xw, yh - bottomRightRadiusY));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw, yh - sY, xw - aX, yh - aY));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw - sX, yh, xw - bottomRightRadiusX, yh));
  aX = bottomLeftRadiusX * 0.292893218813453;
  aY = bottomLeftRadiusY * 0.292893218813453;
  sX = bottomLeftRadiusX * 0.585786437626905;
  sY = bottomLeftRadiusY * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x + bottomLeftRadiusX, yh));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x + sX, yh, x + aX, yh - aY));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x, yh - sY, x, yh - bottomLeftRadiusY));
  aX = topLeftRadiusX * 0.292893218813453;
  aY = topLeftRadiusY * 0.292893218813453;
  sX = topLeftRadiusX * 0.585786437626905;
  sY = topLeftRadiusY * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(x, y + topLeftRadiusY));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x, y + sY, x + aX, y + aY));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(x + sX, y, x + topLeftRadiusX, y));
  aX = topRightRadiusX * 0.292893218813453;
  aY = topRightRadiusY * 0.292893218813453;
  sX = topRightRadiusX * 0.585786437626905;
  sY = topRightRadiusY * 0.585786437626905;
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(xw - topRightRadiusX, y));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw - sX, y, xw - aX, y + aY));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.QuadraticCurve(xw, y + sY, xw, y + topRightRadiusY));
  this.org_apache_royale_graphics_PathBuilder_commands.push(new org.apache.royale.graphics.LineTo(xw, yh - bottomRightRadiusY));
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.graphics.PathBuilder.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'PathBuilder', qName: 'org.apache.royale.graphics.PathBuilder', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.graphics.PathBuilder.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'closedPath': { type: 'Boolean'}
      };
    },
    accessors: function () {return {};},
    methods: function () {
      return {
        'PathBuilder': { type: '', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Boolean', optional: true } ]; }},
        'clear': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder'},
        'getPathString': { type: 'String', declaredBy: 'org.apache.royale.graphics.PathBuilder'},
        'draw': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'lineTo': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false } ]; }},
        'moveTo': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false } ]; }},
        'quadraticCurveTo': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false },{ index: 3, type: 'Number', optional: false },{ index: 4, type: 'Number', optional: false } ]; }},
        'cubicCurveTo': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false },{ index: 3, type: 'Number', optional: false },{ index: 4, type: 'Number', optional: false },{ index: 5, type: 'Number', optional: false },{ index: 6, type: 'Number', optional: false } ]; }},
        'drawRect': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false },{ index: 3, type: 'Number', optional: false },{ index: 4, type: 'Number', optional: false } ]; }},
        'drawRoundRectComplex': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false },{ index: 3, type: 'Number', optional: false },{ index: 4, type: 'Number', optional: false },{ index: 5, type: 'Number', optional: false },{ index: 6, type: 'Number', optional: false },{ index: 7, type: 'Number', optional: false },{ index: 8, type: 'Number', optional: false } ]; }},
        'drawRoundRectComplex2': { type: 'void', declaredBy: 'org.apache.royale.graphics.PathBuilder', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false },{ index: 3, type: 'Number', optional: false },{ index: 4, type: 'Number', optional: false },{ index: 5, type: 'Number', optional: false },{ index: 6, type: 'Number', optional: false },{ index: 7, type: 'Number', optional: false },{ index: 8, type: 'Number', optional: false },{ index: 9, type: 'Number', optional: false },{ index: 10, type: 'Number', optional: false },{ index: 11, type: 'Number', optional: false },{ index: 12, type: 'Number', optional: false },{ index: 13, type: 'Number', optional: false },{ index: 14, type: 'Number', optional: false } ]; }}
      };
    }
  };
};