/**
 * Generated by Apache Royale Compiler from org\apache\royale\events\DragEvent.as
 * org.apache.royale.events.DragEvent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.events.DragEvent');
/* Royale Static Dependency List: org.apache.royale.events.DragEvent*/

goog.require('org.apache.royale.core.IDragInitiator');
goog.require('org.apache.royale.events.DragEventBase');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.MouseEvent');
goog.require('org.apache.royale.geom.Point');
goog.require('org.apache.royale.utils.PointUtils');



/**
 *  Constructor.  Do not call 'new DragEvent', use the
 *  createDragEvent method instead.
 *  
 *  @asparam type The name of the event.
 *  @asparam bubbles Whether the event bubbles.
 *  @asparam cancelable Whether the event can be canceled.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.DragEventBase}
 * @param {string} type
 * @param {boolean=} bubbles
 * @param {boolean=} cancelable
 */
org.apache.royale.events.DragEvent = function(type, bubbles, cancelable) {
  org.apache.royale.events.DragEvent.base(this, 'constructor');
  bubbles = typeof bubbles !== 'undefined' ? bubbles : false;
  cancelable = typeof cancelable !== 'undefined' ? cancelable : false;
  
  this.type = type;
  this.bubbles = bubbles;
};
goog.inherits(org.apache.royale.events.DragEvent, org.apache.royale.events.DragEventBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.events.DragEvent', org.apache.royale.events.DragEvent);


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_START = "dragStart";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_MOVE = "dragMove";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_END = "dragEnd";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_ENTER = "dragEnter";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_OVER = "dragOver";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_EXIT = "dragExit";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_DROP = "dragDrop";


/**
 * @export
 * @type {org.apache.royale.core.IDragInitiator}
 */
org.apache.royale.events.DragEvent.dragInitiator;


/**
 * @export
 * @type {Object}
 */
org.apache.royale.events.DragEvent.dragSource;


/**
 *  Factory for DragEvents.
 *  
 *  @asparam type The name of the event.
 *  @asparam event The MouseEvent properties to copy into the DragEvent.
 *  @asreturn The new DragEvent.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.events.DragEvent
 *  @royaleignorecoercion window.Event
 *  @royaleignorecoercion Event
 * @export
 * @param {string} type
 * @param {org.apache.royale.events.MouseEvent} event
 * @return {Object}
 */
org.apache.royale.events.DragEvent.createDragEvent = function(type, event) {
  
  var /** @type {Object} */ de = new org.apache.royale.events.DragEvent(type, true, true);
  de.altKey = event.altKey;
  de.ctrlKey = event.ctrlKey;
  de.shiftKey = event.shiftKey;
  de.relatedObject = event.target;
  var /** @type {org.apache.royale.geom.Point} */ localPoint = new org.apache.royale.geom.Point(event.screenX, event.screenY);
  var /** @type {org.apache.royale.geom.Point} */ clientPoint = org.apache.royale.utils.PointUtils.localToGlobal(localPoint, event.target);
  de.clientX = clientPoint.x;
  de.clientY = clientPoint.y;
  return de;
};


/**
 *  Dispatch a DragEvent
 *  
 *  @asparam event The DragEvent to dispatch.
 *  @asparam target The target to dispatch the event from.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.IUIBase
 *  @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 *  @royaleignorecoercion window.Event
 * @export
 * @param {org.apache.royale.events.DragEvent} event
 * @param {Object} target
 */
org.apache.royale.events.DragEvent.dispatchDragEvent = function(event, target) {
  
  target.dispatchEvent(event);
};


/**
 * @private
 * @return {boolean}
 */
org.apache.royale.events.DragEvent.org_apache_royale_events_DragEvent_installDragEventMixin = function() {
  return true;
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.events.DragEvent.org_apache_royale_events_DragEvent_dragEventMixin;

org.apache.royale.events.DragEvent.dragEventMixin = org.apache.royale.events.DragEvent.org_apache_royale_events_DragEvent_installDragEventMixin();




/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.events.DragEvent.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DragEvent', qName: 'org.apache.royale.events.DragEvent', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.events.DragEvent.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        '|dragInitiator': { type: 'org.apache.royale.core.IDragInitiator'},
        '|dragSource': { type: 'Object'}
      };
    },
    accessors: function () {return {};},
    methods: function () {
      return {
        'DragEvent': { type: '', declaredBy: 'org.apache.royale.events.DragEvent', parameters: function () { return [  { index: 1, type: 'String', optional: false },{ index: 2, type: 'Boolean', optional: true },{ index: 3, type: 'Boolean', optional: true } ]; }},
        '|createDragEvent': { type: 'org.apache.royale.events.DragEvent', declaredBy: 'org.apache.royale.events.DragEvent', parameters: function () { return [  { index: 1, type: 'String', optional: false },{ index: 2, type: 'org.apache.royale.events.MouseEvent', optional: false } ]; }},
        '|dispatchDragEvent': { type: 'void', declaredBy: 'org.apache.royale.events.DragEvent', parameters: function () { return [  { index: 1, type: 'org.apache.royale.events.DragEvent', optional: false },{ index: 2, type: 'Object', optional: false } ]; }}
      };
    }
  };
};