/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/controllers/DragMouseController.as
 * org.apache.royale.html.beads.controllers.DragMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.controllers.DragMouseController');

goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.DragEvent');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.MouseEvent');
goog.require('org.apache.royale.geom.Point');
goog.require('org.apache.royale.utils.PointUtils');
goog.require('org.apache.royale.utils.UIUtils');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.html.beads.controllers.DragMouseController = function() {
  org.apache.royale.html.beads.controllers.DragMouseController.base(this, 'constructor');
  this.threshold = org.apache.royale.html.beads.controllers.DragMouseController.defaultThreshold;
};
goog.inherits(org.apache.royale.html.beads.controllers.DragMouseController, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.controllers.DragMouseController', org.apache.royale.html.beads.controllers.DragMouseController);


/**
 * @export
 * @type {boolean}
 */
org.apache.royale.html.beads.controllers.DragMouseController.dragging = false;


/**
 * @export
 * @type {org.apache.royale.core.IUIBase}
 */
org.apache.royale.html.beads.controllers.DragMouseController.dragImage;


/**
 * @export
 * @type {number}
 */
org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetX = 0;


/**
 * @export
 * @type {number}
 */
org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetY = 0;


/**
 * @export
 * @type {number}
 */
org.apache.royale.html.beads.controllers.DragMouseController.defaultThreshold = 4;


/**
 * @export
 * @type {number}
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.threshold = 4;


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype._strand;


/**
 * @export
 * @type {number}
 */
org.apache.royale.html.beads.controllers.DragMouseController.instanceNumber = 1;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.mouseDownX;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.mouseDownY;


/**
 * @private
 * @type {org.apache.royale.core.IPopUpHost}
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.host;


/**
 *  @asprivate
 * @private
 * @param {org.apache.royale.events.MouseEvent} event
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.dragMouseDownHandler = function(event) {
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase, true).topMostEventDispatcher.addEventListener(org.apache.royale.events.MouseEvent.MOUSE_MOVE, org.apache.royale.utils.Language.closure(this.dragMouseMoveHandler, this, 'dragMouseMoveHandler'));
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase, true).topMostEventDispatcher.addEventListener(org.apache.royale.events.MouseEvent.MOUSE_UP, org.apache.royale.utils.Language.closure(this.dragMouseUpHandler, this, 'dragMouseUpHandler'));
  this.mouseDownX = event.screenX;
  this.mouseDownY = event.screenY;
  event.preventDefault();
};


/**
 * @private
 * @param {org.apache.royale.events.MouseEvent} event
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.dragMouseMoveHandler = function(event) {
  var /** @type {org.apache.royale.geom.Point} */ pt;
  var /** @type {org.apache.royale.events.DragEvent} */ dragEvent;
  event.preventDefault();
  if (!org.apache.royale.html.beads.controllers.DragMouseController.dragging) {
    if (Math.abs(event.screenX - this.mouseDownX) > this.threshold || Math.abs(event.screenY - this.mouseDownY) > this.threshold) {
      dragEvent = org.apache.royale.events.DragEvent.createDragEvent("dragStart", event);
      dragEvent.clientX = this.mouseDownX;
      dragEvent.clientY = this.mouseDownY;
      org.apache.royale.events.DragEvent.dispatchDragEvent(dragEvent, event.target);
      this.dispatchEvent(dragEvent);
      if (org.apache.royale.events.DragEvent.dragSource != null) {
        org.apache.royale.html.beads.controllers.DragMouseController.dragging = true;
        this.host = org.apache.royale.utils.UIUtils.findPopUpHost(org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase));
        if (this.host == null)
          return;
        this.host.addElement(org.apache.royale.html.beads.controllers.DragMouseController.dragImage);
        pt = org.apache.royale.utils.PointUtils.globalToLocal(new org.apache.royale.geom.Point(event.clientX, event.clientY), this.host);
        org.apache.royale.html.beads.controllers.DragMouseController.dragImage.x = pt.x + org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetX;
        org.apache.royale.html.beads.controllers.DragMouseController.dragImage.y = pt.y + org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetY;
        org.apache.royale.utils.Language.as(org.apache.royale.html.beads.controllers.DragMouseController.dragImage, org.apache.royale.core.UIBase).id = "drag_image";
        
        org.apache.royale.html.beads.controllers.DragMouseController.dragImage.element.style['pointer-events'] = 'none';
        org.apache.royale.html.beads.controllers.DragMouseController.dragImage.element.style['position'] = 'absolute';
      }
    }
  } else {
    this.host = org.apache.royale.utils.UIUtils.findPopUpHost(org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase));
    if (this.host == null)
      return;
    dragEvent = org.apache.royale.events.DragEvent.createDragEvent("dragMove", event);
    pt = org.apache.royale.utils.PointUtils.globalToLocal(new org.apache.royale.geom.Point(event.clientX, event.clientY), this.host);
    org.apache.royale.html.beads.controllers.DragMouseController.dragImage.x = pt.x + org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetX;
    org.apache.royale.html.beads.controllers.DragMouseController.dragImage.y = pt.y + org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetY;
    org.apache.royale.events.DragEvent.dispatchDragEvent(dragEvent, event.target);
    this.dispatchEvent(dragEvent);
  }
};


/**
 * @private
 * @param {org.apache.royale.events.MouseEvent} event
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.dragMouseUpHandler = function(event) {
  org.apache.royale.utils.Language.trace("DRAG-MOUSE: dragMouseUp");
  var /** @type {org.apache.royale.events.DragEvent} */ dragEvent;
  this.host = org.apache.royale.utils.UIUtils.findPopUpHost(org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase));
  if (org.apache.royale.html.beads.controllers.DragMouseController.dragImage && this.host) {
    this.host.removeElement(org.apache.royale.html.beads.controllers.DragMouseController.dragImage);
  }
  if (org.apache.royale.html.beads.controllers.DragMouseController.dragging && event.target) {
    org.apache.royale.utils.Language.trace("DRAG-MOUSE: sending dragEnd via: " + event.target.toString());
    var /** @type {org.apache.royale.geom.Point} */ screenPoint = new org.apache.royale.geom.Point(event.screenX, event.screenY);
    var /** @type {org.apache.royale.geom.Point} */ newPoint = org.apache.royale.utils.PointUtils.globalToLocal(screenPoint, event.target);
    dragEvent = org.apache.royale.events.DragEvent.createDragEvent("dragEnd", event);
    dragEvent.clientX = newPoint.x;
    dragEvent.clientY = newPoint.y;
    org.apache.royale.events.DragEvent.dispatchDragEvent(dragEvent, event.target);
    this.dispatchEvent(dragEvent);
    event.preventDefault();
  }
  org.apache.royale.html.beads.controllers.DragMouseController.dragging = false;
  org.apache.royale.events.DragEvent.dragSource = null;
  org.apache.royale.events.DragEvent.dragInitiator = null;
  org.apache.royale.html.beads.controllers.DragMouseController.dragImage = null;
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase, true).topMostEventDispatcher.removeEventListener(org.apache.royale.events.MouseEvent.MOUSE_MOVE, org.apache.royale.utils.Language.closure(this.dragMouseMoveHandler, this, 'dragMouseMoveHandler'));
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase, true).topMostEventDispatcher.removeEventListener(org.apache.royale.events.MouseEvent.MOUSE_UP, org.apache.royale.utils.Language.closure(this.dragMouseUpHandler, this, 'dragMouseUpHandler'));
};


org.apache.royale.html.beads.controllers.DragMouseController.prototype.get__strand = function() {
  return this._strand;
};


org.apache.royale.html.beads.controllers.DragMouseController.prototype.set__strand = function(value) {
  this._strand = value;
  org.apache.royale.utils.Language.trace("DragMouseController instance " + org.apache.royale.html.beads.controllers.DragMouseController.instanceNumber + "; isDragging " + org.apache.royale.html.beads.controllers.DragMouseController.dragging);
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.MouseEvent.MOUSE_DOWN, org.apache.royale.utils.Language.closure(this.dragMouseDownHandler, this, 'dragMouseDownHandler'));
  org.apache.royale.html.beads.controllers.DragMouseController.instanceNumber += 100;
};


Object.defineProperties(org.apache.royale.html.beads.controllers.DragMouseController.prototype, /** @lends {org.apache.royale.html.beads.controllers.DragMouseController.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
get: org.apache.royale.html.beads.controllers.DragMouseController.prototype.get__strand,
set: org.apache.royale.html.beads.controllers.DragMouseController.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DragMouseController', qName: 'org.apache.royale.html.beads.controllers.DragMouseController', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.controllers.DragMouseController.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        '|dragging': { type: 'Boolean'},
        '|dragImage': { type: 'org.apache.royale.core.IUIBase'},
        '|dragImageOffsetX': { type: 'Number'},
        '|dragImageOffsetY': { type: 'Number'},
        '|defaultThreshold': { type: 'int'},
        'threshold': { type: 'int'},
        '|instanceNumber': { type: 'int'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.controllers.DragMouseController'}
      };
    },
    methods: function () {
      return {
        'DragMouseController': { type: '', declaredBy: 'org.apache.royale.html.beads.controllers.DragMouseController'}
      };
    },
    metadata: function () { return [  ]; }
  };
};