/**
 * Generated by Apache Royale Compiler from org/apache/royale/collections/ISort.as
 * org.apache.royale.collections.ISort
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.ISort');



/**
 * @interface
 */
org.apache.royale.collections.ISort = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.ISort', org.apache.royale.collections.ISort);
/**  * @type {Function}
 */org.apache.royale.collections.ISort.prototype.compareFunction;
/**  * @type {Array}
 */org.apache.royale.collections.ISort.prototype.fields;
/**  * @type {boolean}
 */org.apache.royale.collections.ISort.prototype.unique;
/**
 *  Finds the specified object within the specified array (or the insertion
 *  point if asked for), returning the index if found or -1 if not.
 *  The <code>ListCollectionView</code> class <code>find<i>xxx</i>()</code>
 *  methods use this method to find the requested item; as a general rule,
 *  it is easier to use these functions, and not <code>findItem()</code>
 *  to find data in <code>ListCollectionView</code>-based objects.
 *  You call the <code>findItem()</code> method directly when writing a
 *  class that supports sorting, such as a new <code>ICollectionView</code>
 *  implementation.
 *  The input items array need to be sorted before calling this function.
 *  Otherwise this function will not be able to find the specified value
 *  properly.
 *
 *  @asparam items the Array within which to search.
 *  @asparam values Object containing the properties to look for (or
 *                the object to search for, itself).
 *                The object must consist of field name/value pairs, where
 *                the field names are names of fields specified by the
 *                <code>fields</code> property, in the same order they
 *                are used in that property.
 *                You do not have to specify all of the fields from the
 *                <code>fields</code> property, but you
 *                cannot skip any in the order.
 *                Therefore, if the <code>fields</code>
 *                properity lists three fields, you can specify its first
 *                and second fields in this parameter, but you cannot
 *                specify  only the first and third fields.
 *  @asparam mode String containing the type of find to perform.
 *           Valid values are:
 *             <table>
 *               <tr>
 *                 <th>ANY_INDEX_MODE</th>
 *                 <th>Return any position that
 *                   is valid for the values.</th>
 *               </tr>
 *               <tr>
 *                 <th>FIRST_INDEX_MODE</th>
 *                 <th>Return the position
 *                   where the first occurrance of the values is found.</th>
 *               </tr>
 *               <tr>
 *                 <th>LAST_INDEX_MODE</th>
 *                 <th>Return the position where the
 *                   last ocurrance of the specified values is found.
 *                 </th>
 *               </tr>
 *               </table>
 *  @asparam returnInsertionIndex If the method does not find an item
 *                     identified by the <code>values</code> parameter,
 *                     and this parameter is <code>true</code> the
 *                     <code>findItem()</code>
 *                     method returns the insertion point for the values,
 *                     that is the point in the sorted order where you
 *                     should insert the item.
 *  @asparam compareFunction a comparator function to use to find the item.
 *                 If you do not specify this parameter or , or if you
 *                 provide a <code>null</code> value,
 *                 <code>findItem()</code> function uses the
 *                 compare function determined by the <code>ISort</code>
 *                 instance's <code>compareFunction</code> property,
 *                 passing in the array of fields determined
 *                 by the values object and the current
 *                 <code>SortFields</code>.
 *
 *                 If you provide a non-null value, <code>findItem()</code>
 *                 function uses it as the compare function.
 *
 *                 The signature of the function passed as
 *                 <code>compareFunction</code> must be as follows:
 *                 <code>function myCompareFunction(a:Object, b:Object):int</code>.
 *                 Note that there is no third argument unlike the
 *                 compare function for <code>ISort.compareFunction()</code>
 *                 property.
 *  @asreturn int The index in the array of the found item.
 *                If the <code>returnInsertionIndex</code> parameter is
 *              <code>false</code> and the item is not found, returns -1.
 *                If the <code>returnInsertionIndex</code> parameter is
 *              <code>true</code> and the item is not found, returns
 *                the index of the point in the sorted array where the
 *                values would be inserted.
 *
 *  @throws SortError If there are any parameter errors,
 *          the find critieria is not compatible with the sort
 *          or the comparator function for the sort can not be determined.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Flex 4.5
 * @export
 * @param {Array} items
 * @param {Object} values
 * @param {string} mode
 * @param {boolean=} returnInsertionIndex
 * @param {Function=} compareFunction
 * @return {number}
 */
org.apache.royale.collections.ISort.prototype.findItem = function(items, values, mode, returnInsertionIndex, compareFunction) {
};
/**
 *  Return whether the specified property is used to control the sort.
 *  The function cannot determine a definitive answer if the sort uses a
 *  custom comparator; it always returns <code>true</code> in this case.
 *
 *  @asparam property The name of the field to test.
 *  @asreturn Whether the property value might affect the sort outcome.
 *  If the sort uses the default compareFunction, returns
 *  <code>true</code> if the
 *  <code>property</code> parameter specifies a sort field.
 *  If the sort or any <code>ISortField</code> uses a custom comparator,
 *  there's no way to know, so return <code>true</code>.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Flex 4.5
 * @export
 * @param {string} property
 * @return {boolean}
 */
org.apache.royale.collections.ISort.prototype.propertyAffectsSort = function(property) {
};
org.apache.royale.collections.ISort.prototype.reverse = function() {
};
/**
 *  Apply the current sort to the specified array (not a copy).
 *  To prevent the array from being modified, create a copy
 *  use the copy in the <code>items</code> parameter.
 *
 *  <p>Flex <code>ICollectionView</code> implementations call the
 *  <code>sort</code> method automatically and ensure that the sort is
 *  performed on a copy of the underlying data.</p>
 *
 *  @asparam items Array of items to sort.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Flex 4.5
 * @export
 * @param {Array} items
 */
org.apache.royale.collections.ISort.prototype.sort = function(items) {
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.ISort.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'ISort', qName: 'org.apache.royale.collections.ISort', kind: 'interface' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.ISort.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'compareFunction': { type: 'Function', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ISort'},
        'fields': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ISort'},
        'unique': { type: 'Boolean', access: 'readonly', declaredBy: 'org.apache.royale.collections.ISort'}
      };
    },
    methods: function () {
      return {
        'findItem': { type: 'int', declaredBy: 'org.apache.royale.collections.ISort', parameters: function () { return [ 'Array', false ,'Object', false ,'String', false ,'Boolean', true ,'Function', true ]; }},
        'propertyAffectsSort': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.ISort', parameters: function () { return [ 'String', false ]; }},
        'reverse': { type: 'void', declaredBy: 'org.apache.royale.collections.ISort'},
        'sort': { type: 'void', declaredBy: 'org.apache.royale.collections.ISort', parameters: function () { return [ 'Array', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.collections.ISort.prototype.ROYALE_COMPILE_FLAGS = 10;