/**
 * Generated by Apache Royale Compiler from org/apache/royale/collections/CollectionUtils.as
 * org.apache.royale.collections.CollectionUtils
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.CollectionUtils');

goog.require('org.apache.royale.collections.ICollectionView');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 */
org.apache.royale.collections.CollectionUtils = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.CollectionUtils', org.apache.royale.collections.CollectionUtils);


/**
 * Search for an index in a collection of objects, given the key and the value
 *
 * @asparam collection The <code>ICollectionView</code> to inspect
 * @asparam key The <code>String</code> that will be use for search
 * @asparam value Any kind of object to perform the comparison
 *
 * @asreturn an <code>int</code> that represents the index of the object in the collection
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.collections.ICollectionView} collection
 * @param {string} key
 * @param {*} value
 * @return {number}
 */
org.apache.royale.collections.CollectionUtils.findIndex = function(collection, key, value) {
  var /** @type {number} */ i = 0;
  var /** @type {number} */ index = -1;
  if (collection && key && (key != "") && value !== undefined) {
    //var /** @type {number} */ i = 0;
    
/**
 * @const
 * @type {number}
 */
var n = collection.length;
    
/**
 * @const
 * @type {boolean}
 */
var nan = org.apache.royale.utils.Language.is(value, Number) && isNaN(value);
    for (i = 0; i < n; i++) {
      var /** @type {Object} */ item = collection.getItemAt(i);
      if (item) {
        
        if (item[key] == value || (nan && item[key] === undefined || (org.apache.royale.utils.Language.is(item[key], Number) && isNaN(item[key])))) {
          index = i;
          break;
        }
      }
    }
  }
  return index;
};


/**
 * Get a item in a given collection given a key and a value
 *
 * @asparam collection The <code>ICollectionView</code> to inspect
 * @asparam key The <code>String</code> that will be used for comparison field name
 * @asparam value Any kind of object to perform the comparison - a value of undefined is ignored
 *
 * @asreturn The first object with a comparison field match to the value, if exists in the collection
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.collections.ICollectionView} collection
 * @param {string} key
 * @param {*} value
 * @return {*}
 */
org.apache.royale.collections.CollectionUtils.getItemByField = function(collection, key, value) {
  var /** @type {number} */ i = 0;
  if (collection && key && (key != "") && value !== undefined) {
    //var /** @type {number} */ i = 0;
    
/**
 * @const
 * @type {number}
 */
var n = collection.length;
    
/**
 * @const
 * @type {boolean}
 */
var nan = org.apache.royale.utils.Language.is(value, Number) && isNaN(value);
    for (i = 0; i < n; i++) {
      var /** @type {Object} */ item = collection.getItemAt(i);
      if (item) {
        
        if (item[key] == value || (nan && item[key] === undefined || (org.apache.royale.utils.Language.is(item[key], Number) && isNaN(item[key])))) {
          return item;
        }
      }
    }
  }
  return null;
};


/**
 * Tries to find the object or the propertyId in a collection and returns the index if found.
 * The comparison is based on 'id'
 * Supports nulls in property object and returns -1
 * For use with List components in bindings with "selectedIndex"
 *
 * @asparam collection a <code>ICollectionView</code> dataprovider where we need to look for
 * @asparam obj an <code>Object</code> with a subproperty used for comparison
 * @asparam property the <code>String</code> name of the subproperty. This could be an Object with an id or directly a propertyId
 *
 * @asreturn the index if found, -1 if the object is null or not found
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.collections.ICollectionView} collection
 * @param {Object} obj
 * @param {string} property
 * @return {number}
 */
org.apache.royale.collections.CollectionUtils.findSelectedIndex = function(collection, obj, property) {
  var /** @type {number} */ index = -1;
  if (obj && obj[property]) {
    if (obj[property].hasOwnProperty("id")) {
      index = org.apache.royale.collections.CollectionUtils.findIndex(collection, 'id', obj[property].id);
    } else {
      index = org.apache.royale.collections.CollectionUtils.findIndex(collection, 'id', obj[property]);
    }
  }
  return index;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.CollectionUtils.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'CollectionUtils', qName: 'org.apache.royale.collections.CollectionUtils', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.CollectionUtils.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    methods: function () {
      return {
        '|findIndex': { type: 'int', declaredBy: 'org.apache.royale.collections.CollectionUtils', parameters: function () { return [ 'org.apache.royale.collections.ICollectionView', false ,'String', false ,'*', false ]; }},
        '|getItemByField': { type: '*', declaredBy: 'org.apache.royale.collections.CollectionUtils', parameters: function () { return [ 'org.apache.royale.collections.ICollectionView', false ,'String', false ,'*', false ]; }},
        '|findSelectedIndex': { type: 'Number', declaredBy: 'org.apache.royale.collections.CollectionUtils', parameters: function () { return [ 'org.apache.royale.collections.ICollectionView', false ,'Object', false ,'String', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.collections.CollectionUtils.prototype.ROYALE_COMPILE_FLAGS = 10;