/**
 * Generated by Apache Royale Compiler from org/apache/royale/collections/ArrayListView.as
 * org.apache.royale.collections.ArrayListView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.ArrayListView');

goog.require('org.apache.royale.collections.ArrayList');
goog.require('org.apache.royale.collections.IArrayList');
goog.require('org.apache.royale.collections.ISort');
goog.require('org.apache.royale.collections.Sort');
goog.require('org.apache.royale.events.CollectionEvent');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.collections.IArrayListView');
goog.require('org.apache.royale.utils.Language');



/**
 *  The ArrayListView constructor.
 *
 *  @asparam list the IArrayList this ArrayListView is meant to wrap.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.collections.IArrayListView}
 * @implements {org.apache.royale.collections.IArrayList}
 * @param {org.apache.royale.collections.ArrayList=} initialSource
 */
org.apache.royale.collections.ArrayListView = function(initialSource) {
  org.apache.royale.collections.ArrayListView.base(this, 'constructor');
  initialSource = typeof initialSource !== 'undefined' ? initialSource : null;
  this.list = initialSource || new org.apache.royale.collections.ArrayList();
  this.localIndex = null;
};
goog.inherits(org.apache.royale.collections.ArrayListView, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.ArrayListView', org.apache.royale.collections.ArrayListView);


/**
 * @private
 * @type {number}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_autoUpdateCounter = 0;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_pendingUpdates;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_dispatchResetEvent = true;


/**
 * @protected
 * @type {Array}
 */
org.apache.royale.collections.ArrayListView.prototype.localIndex;


/**
 * @private
 * @type {string}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView__id;


/**
 * @private
 * @type {org.apache.royale.collections.ArrayList}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView__list;


/**
 * @protected
 * @param {org.apache.royale.collections.ArrayList} list
 * @param {boolean} toggleOn
 */
org.apache.royale.collections.ArrayListView.prototype.toggleListListeners = function(list, toggleOn) {
  
/**
 * @const
 * @type {Function}
 */
var listenerToggle = toggleOn ? org.apache.royale.utils.Language.closure(list.addEventListener, list, 'addEventListener') : org.apache.royale.utils.Language.closure(list.removeEventListener, list, 'removeEventListener');
  listenerToggle(org.apache.royale.events.CollectionEvent.COLLECTION_CHANGED, org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_ArrayListView_listChangeHandler, this, 'org_apache_royale_collections_ArrayListView_listChangeHandler'));
  listenerToggle(org.apache.royale.events.CollectionEvent.ITEM_ADDED, org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_ArrayListView_listChangeHandler, this, 'org_apache_royale_collections_ArrayListView_listChangeHandler'));
  listenerToggle(org.apache.royale.events.CollectionEvent.ITEM_REMOVED, org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_ArrayListView_listChangeHandler, this, 'org_apache_royale_collections_ArrayListView_listChangeHandler'));
  listenerToggle(org.apache.royale.events.CollectionEvent.ITEM_UPDATED, org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_ArrayListView_listChangeHandler, this, 'org_apache_royale_collections_ArrayListView_listChangeHandler'));
  listenerToggle(org.apache.royale.events.CollectionEvent.ALL_ITEMS_REMOVED, org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_ArrayListView_listChangeHandler, this, 'org_apache_royale_collections_ArrayListView_listChangeHandler'));
};


/**
 * @private
 * @type {Function}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView__filterFunction;


/**
 * @private
 * @type {org.apache.royale.collections.ISort}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView__sort;


/**
 * verify if the item is contained within this ArrayListView
 *
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @return {boolean}
 */
org.apache.royale.collections.ArrayListView.prototype.contains = function(item) {
  return this.getItemIndex(item) != -1;
};


/**
 *  stop processing update events from the source list.
 *
 *  @see mx.collections.IArrayListView#enableAutoUpdate()
 *  @see mx.events.CollectionEvent
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 */
org.apache.royale.collections.ArrayListView.prototype.disableAutoUpdate = function() {
  this.org_apache_royale_collections_ArrayListView_autoUpdateCounter++;
};


/**
 *  restore updates from the source list
 *
 *  @see mx.collections.IArrayListView#disableAutoUpdate()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 */
org.apache.royale.collections.ArrayListView.prototype.enableAutoUpdate = function() {
  if (this.org_apache_royale_collections_ArrayListView_autoUpdateCounter > 0) {
    this.org_apache_royale_collections_ArrayListView_autoUpdateCounter--;
    if (this.org_apache_royale_collections_ArrayListView_autoUpdateCounter == 0) {
      this.org_apache_royale_collections_ArrayListView_handlePendingUpdates();
    }
  }
};


/**
 *  trigger notification events that the item has been updated.
 *
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 */
org.apache.royale.collections.ArrayListView.prototype.itemUpdated = function(item) {
  this.list.itemUpdated(item);
};


/**
 *  trigger notification events that the item has been updated.
 *
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {number} index
 */
org.apache.royale.collections.ArrayListView.prototype.itemUpdatedAt = function(index) {
  if (index >= 0 && index < this.length) {
    var /** @type {Object} */ item = this.getItemAt(index);
    this.list.itemUpdated(item);
  }
};


/**
 * Forces an update of this ArrayListView contents from the source ArrayList,
 * by applying the current filter function and Sort.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @return {boolean}
 */
org.apache.royale.collections.ArrayListView.prototype.refresh = function() {
  return this.org_apache_royale_collections_ArrayListView_internalRefresh(true);
};


/**
 *  Fetches an item from the collection at a given index
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.collections.ArrayListView.prototype.getItemAt = function(index) {
  if (index < 0 || index >= this.length) {
    throw new RangeError('ArrayListView getItemAt index out of bounds :' + index);
  }
  if (this.localIndex) {
    return this.localIndex[index];
  } else if (this.list) {
    return this.list.getItemAt(index);
  }
  return null;
};


/**
 *  Replaces the item at the given index with a new item and
 *  returns the old item, or adds an item to end of the source list if the
 *  index is the same as this ArrayListView's current length, returning null
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.collections.ArrayListView.prototype.setItemAt = function(item, index) {
  if (index < 0 || !this.list || index > this.length) {
    throw new RangeError('ArrayListView setItemAt index out of bounds :' + (!this.list ? '(list content is null)' : index));
  }
  var /** @type {number} */ listIndex = index;
  if (this.localIndex) {
    if (index > this.localIndex.length) {
      listIndex = this.list.length;
    } else {
      var /** @type {Object} */ oldItem = this.localIndex[index];
      listIndex = this.list.getItemIndex(oldItem);
    }
  }
  return this.list.setItemAt(item, listIndex);
};


/**
 * @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 */
org.apache.royale.collections.ArrayListView.prototype.addItem = function(item) {
  if (this.localIndex)
    this.addItemAt(item, (this.localIndex.length) >> 0);
  else
    this.addItemAt(item, this.length);
};


/**
 * @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @param {number} index
 */
org.apache.royale.collections.ArrayListView.prototype.addItemAt = function(item, index) {
  var /** @type {number} */ listIndex = index;
  if (this.localIndex && this.sort) {
    listIndex = this.list.length;
  } else if (this.localIndex && this.filterFunction != null) {
    if (listIndex == this.localIndex.length)
      listIndex = this.list.length;
    else
      listIndex = this.list.getItemIndex(this.localIndex[index]);
  } else if (this.localIndex) {
    listIndex = this.list.length;
  }
  this.list.addItemAt(item, listIndex);
};


/**
 *  Adds a list of items to the current list, placing them at the end of
 *  the list in the order they are passed.
 *
 *  @asparam addList IArrayList The list of items to add to the current list
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {org.apache.royale.collections.IArrayList} addList
 */
org.apache.royale.collections.ArrayListView.prototype.addAll = function(addList) {
  if (this.localIndex)
    this.addAllAt(addList, (this.localIndex.length) >> 0);
  else
    this.addAllAt(addList, this.length);
};


/**
 *  Adds a list of items to the current list, placing them at the position
 *  index passed in to the function.  The items are placed at the index location
 *  and placed in the order they are recieved.
 *
 *  @asparam addList IArrayList The list of items to add to the current list
 *  @asparam index The location of the current list to place the new items.
 *  @throws RangeError if index is less than 0 or greater than the length of the list.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {org.apache.royale.collections.IArrayList} addList
 * @param {number} index
 */
org.apache.royale.collections.ArrayListView.prototype.addAllAt = function(addList, index) {
  var /** @type {number} */ length = addList.length;
  for (var /** @type {number} */ i = 0; i < length; i++) {
    var /** @type {number} */ insertIndex = (i + index) >> 0;
    if (insertIndex > this.length)
      insertIndex = this.length;
    this.addItemAt(addList.getItemAt(i), insertIndex);
  }
};


/**
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @return {number}
 */
org.apache.royale.collections.ArrayListView.prototype.getItemIndex = function(item) {
  var /** @type {number} */ i = 0;
  //var /** @type {number} */ i = 0;
  if (this.localIndex && this.org_apache_royale_collections_ArrayListView__filterFunction != null) {
    return (this.localIndex.indexOf(item)) >> 0;
  } else if (this.localIndex && this.org_apache_royale_collections_ArrayListView__sort) {
    var /** @type {number} */ startIndex = this.findItem(item, org.apache.royale.collections.Sort.FIRST_INDEX_MODE);
    if (startIndex == -1) {
      return -1;
    }
    var /** @type {number} */ endIndex = this.findItem(item, org.apache.royale.collections.Sort.LAST_INDEX_MODE);
    for (i = startIndex; i <= endIndex; i++) {
      if (this.localIndex[i] == item) {
        return i;
      }
    }
    return -1;
  } else if (this.localIndex) {
    return (this.localIndex.indexOf(item)) >> 0;
  }
  return this.list.getItemIndex(item);
};


/**
 * @inheritDoc
 * @export
 * @param {Object} item
 * @return {number}
 */
org.apache.royale.collections.ArrayListView.prototype.getLocalItemIndex = function(item) {
  return (this.localIndex.indexOf(item)) >> 0;
};


/**
 * @asprivate
 * @private
 * @param {Object} item
 * @return {number}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_getFilteredItemIndex = function(item) {
  var /** @type {number} */ loc = this.list.getItemIndex(item);
  if (this.org_apache_royale_collections_ArrayListView__filterFunction == null)
    return loc;
  if (loc == 0)
    return 0;
  for (var /** @type {number} */ i = (loc - 1) >> 0; i >= 0; i--) {
    var /** @type {Object} */ prevItem = this.list.getItemAt(i);
    if (this.filterFunction(prevItem)) {
      var /** @type {number} */ found = (this.localIndex.indexOf(prevItem)) >> 0;
      if (found != -1)
        return (found + 1) >> 0;
    }
  }
  return 0;
};


/**
 *  Removes the specified item from this list, should it exist.
 *  Relies on ArrayList implementation
 *
 *  @asparam  item Object reference to the item that should be removed.
 *  @asreturn Boolean indicating if the item was removed.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Apache Flex 4.10
 * @export
 * @param {Object} item
 * @return {boolean}
 */
org.apache.royale.collections.ArrayListView.prototype.removeItem = function(item) {
  return this.list.removeItem(item);
};


/**
 * @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.collections.ArrayListView.prototype.removeItemAt = function(index) {
  if (index < 0 || index >= this.length) {
    throw new RangeError('ArrayListView removeItemAt index out of bounds :' + index);
  }
  var /** @type {number} */ listIndex = index;
  if (this.localIndex) {
    var /** @type {Object} */ oldItem = this.localIndex[index];
    listIndex = this.list.getItemIndex(oldItem);
  }
  return this.list.removeItemAt(listIndex);
};


/**
 * Remove all items from the list.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 */
org.apache.royale.collections.ArrayListView.prototype.removeAll = function() {
  var /** @type {number} */ len = this.length;
  if (len > 0) {
    if (this.localIndex && this.filterFunction != null) {
      len = (this.localIndex.length) >> 0;
      for (var /** @type {number} */ i = (len - 1) >> 0; i >= 0; i--) {
        this.removeItemAt(i);
      }
    } else {
      this.localIndex = null;
      this.list.removeAll();
    }
  }
};


/**
 * @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @return {Array}
 */
org.apache.royale.collections.ArrayListView.prototype.toArray = function() {
  var /** @type {Array} */ ret;
  if (this.localIndex)
    ret = this.localIndex.concat();
  else
    ret = this.list.toArray();
  return ret;
};


/**
 *  Find the item specified using the Sort find mode constants.
 *  If there is no sort assigned throw an error.
 *
 *  @asparam values the values object that can be passed into Sort.findItem
 *  @asparam mode the mode to pass to Sort.findItem (see Sort)
 *  @asparam insertIndex true if it should find the insertion point
 *  @asreturn the index where the item is located, -1 if not found or SortError
 *  caught
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} values
 * @param {string} mode
 * @param {boolean=} insertIndex
 * @return {number}
 */
org.apache.royale.collections.ArrayListView.prototype.findItem = function(values, mode, insertIndex) {
  insertIndex = typeof insertIndex !== 'undefined' ? insertIndex : false;
  if (!this.sort || !this.localIndex) {
    throw new Error('ArrayListView findItem requires a sort and subsequent refresh()');
  }
  if (this.localIndex.length == 0)
    return (insertIndex ? 0 : -1) >> 0;
  try {
    return this.sort.findItem(this.localIndex, values, mode, insertIndex);
  } catch (e) {
    org.apache.royale.utils.Language.trace('sorting error');
  }
  return -1;
};


/**
 * The view is a listener of CollectionEvents on its underlying IArrayList
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 * @param {org.apache.royale.events.CollectionEvent} event
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_listChangeHandler = function(event) {
  if (this.org_apache_royale_collections_ArrayListView_autoUpdateCounter > 0) {
    if (!this.org_apache_royale_collections_ArrayListView_pendingUpdates) {
      this.org_apache_royale_collections_ArrayListView_pendingUpdates = [];
    }
    this.org_apache_royale_collections_ArrayListView_pendingUpdates.push(event);
  } else {
    switch (event.type) {
      case org.apache.royale.events.CollectionEvent.ITEM_ADDED:
        this.org_apache_royale_collections_ArrayListView_addItemsToView(event.items || [event], true);
        break;
      case org.apache.royale.events.CollectionEvent.ITEM_REMOVED:
        this.org_apache_royale_collections_ArrayListView_removeItemsFromView(event.items || [event], true);
        break;
      case org.apache.royale.events.CollectionEvent.ALL_ITEMS_REMOVED:
        this.org_apache_royale_collections_ArrayListView_handleAllItemsRemoved(event);
        break;
      case org.apache.royale.events.CollectionEvent.ITEM_UPDATED:
        this.org_apache_royale_collections_ArrayListView_handleItemUpdatedEvents(event.items || [event]);
        break;
      default:
        this.dispatchEvent(event);
    }
  }
};


/**
 *
 * @royaleignorecoercion org.apache.royale.events.CollectionEvent
 * @private
 * @param {Object} sourceEvent
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_handleAllItemsRemoved = function(sourceEvent) {
  var /** @type {Array} */ allItems = this.localIndex ? this.localIndex : sourceEvent.items.concat();
  if (this.org_apache_royale_collections_ArrayListView_dispatchResetEvent) {
    this.org_apache_royale_collections_ArrayListView_reset();
  } else {
    this.org_apache_royale_collections_ArrayListView_internalRefresh(false, false);
    this.dispatchEvent(new org.apache.royale.events.Event('lengthChanged'));
  }
  var /** @type {Object} */ localEvent = sourceEvent.cloneEvent();
  localEvent.items = allItems;
  this.dispatchEvent(localEvent);
};


/**
 * @private
 * @param {Array} itemEvents
 * @param {boolean} withRefresh
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_addItemsToView = function(itemEvents, withRefresh) {
  var self = this;
  var /** @type {boolean} */ lengthChanged;
  var /** @type {number} */ i = 0;
  var /** @type {number} */ l = (itemEvents.length) >>> 0;
  var /** @type {Array} */ addedItems = [];
  
/**
 * @const
 * @type {boolean}
 */
var withFilter = this.filterFunction != null;
  for (; i < l; i++) {
    var /** @type {org.apache.royale.events.CollectionEvent} */ itemEvent = itemEvents[i];
    if (withFilter) {
      if (!this.filterFunction(itemEvent.item))
        continue;
    }
    addedItems.push(itemEvent);
  }
  l = (addedItems.length) >>> 0;
  if (l) {
    if (withRefresh) {
      this.org_apache_royale_collections_ArrayListView_internalRefresh(false, false);
    } else {
      throw new Error('WIP , do to');
    }
    while (l--) {
      var /** @type {org.apache.royale.events.CollectionEvent} */ localEvent = addedItems[l].cloneEvent();
      addedItems[l] = localEvent;
      localEvent.index = this.getItemIndex(localEvent.item);
    }
    addedItems.sort(function(event1, event2) {
      return !!(event1.index < event2.index ? -1 : 1);
    });
    while (addedItems.length) {
      localEvent = addedItems.shift();
      this.dispatchEvent(localEvent);
    }
    lengthChanged = true;
  }
  if (lengthChanged) {
    this.dispatchEvent(new org.apache.royale.events.Event('lengthChanged'));
  }
};


/**
 * @private
 * @param {Array} itemEvents
 * @param {boolean} withRefresh
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_removeItemsFromView = function(itemEvents, withRefresh) {
  var self = this;
  var /** @type {boolean} */ lengthChanged;
  var /** @type {number} */ i = 0;
  var /** @type {number} */ l = (itemEvents.length) >>> 0;
  var /** @type {Array} */ removedItems = [];
  
/**
 * @const
 * @type {boolean}
 */
var withFilter = this.filterFunction != null;
  for (; i < l; i++) {
    var /** @type {org.apache.royale.events.CollectionEvent} */ itemEvent = itemEvents[i];
    if (withFilter) {
      if (!this.filterFunction(itemEvent.item))
        continue;
    }
    removedItems.push(itemEvent);
  }
  l = (removedItems.length) >>> 0;
  if (l) {
    while (l--) {
      var /** @type {org.apache.royale.events.CollectionEvent} */ localEvent = removedItems[l].cloneEvent();
      removedItems[l] = localEvent;
      localEvent.index = this.getItemIndex(localEvent.item);
    }
    var /** @type {boolean} */ localUpdate;
    if (withRefresh || !this.localIndex) {
      this.org_apache_royale_collections_ArrayListView_internalRefresh(false, false);
    } else {
      localUpdate = true;
    }
    removedItems.sort(function(event1, event2) {
      return !!(event1.index < event2.index ? 1 : -1);
    });
    var /** @type {number} */ offset = 0;
    while (removedItems.length) {
      localEvent = removedItems.shift();
      localEvent.index = (-offset) >> 0;
      if (localUpdate) {
        this.localIndex.splice(localEvent.index, 1);
      }
      this.dispatchEvent(localEvent);
      offset++;
    }
    lengthChanged = true;
  }
  if (lengthChanged) {
    this.dispatchEvent(new org.apache.royale.events.Event('lengthChanged'));
  }
};


/**
 * Given a set of <code>CollectionEvent</code>s go through and update the view.
 * This is currently not optimized.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *
 *  @royaleignorecoercion org.apache.royale.events.CollectionEvent
 * @private
 * @param {Array} events
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_handleItemUpdatedEvents = function(events) {
  var /** @type {Object} */ event;
  var /** @type {Object} */ item;
  var /** @type {boolean} */ withFilter = this.org_apache_royale_collections_ArrayListView__filterFunction != null;
  var /** @type {boolean} */ dispatchLengthChanged;
  if (this.org_apache_royale_collections_ArrayListView__needsRefresh) {
    this.org_apache_royale_collections_ArrayListView_reset(true);
  } else {
    if (this.org_apache_royale_collections_ArrayListView__sort || withFilter) {
      var /** @type {Array} */ originals = this.localIndex ? this.localIndex.concat() : this.source.concat();
      var /** @type {boolean} */ present = true;
      var /** @type {boolean} */ check = true;
      var /** @type {Object} */ updateEvent;
      if (events.length == 1) {
        dispatchLengthChanged = this.org_apache_royale_collections_ArrayListView_internalRefresh(false, false);
        updateEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.COLLECTION_CHANGED);
        updateEvent.items = events;
        this.dispatchEvent(updateEvent);
      } else {
        dispatchLengthChanged = this.org_apache_royale_collections_ArrayListView_internalRefresh(false, false);
        updateEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.COLLECTION_CHANGED);
        updateEvent.items = events;
        this.dispatchEvent(updateEvent);
      }
    } else {
      var /** @type {number} */ i = 0;
      var /** @type {number} */ l = (events.length) >>> 0;
      for (; i < l; i++) {
        event = events[i].cloneEvent();
        this.dispatchEvent(event);
      }
    }
  }
  if (dispatchLengthChanged) {
    this.dispatchEvent(new org.apache.royale.events.Event('lengthChanged'));
  }
};


/**
 * When enableAutoUpdates pushes autoUpdateCounter back down to 0
 * this method will execute to consolidate the pending update
 * events or turn it into a massive refresh().
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_handlePendingUpdates = function() {
  if (this.org_apache_royale_collections_ArrayListView_pendingUpdates) {
    var /** @type {Array} */ pu = this.org_apache_royale_collections_ArrayListView_pendingUpdates;
    this.org_apache_royale_collections_ArrayListView_pendingUpdates = null;
    var /** @type {org.apache.royale.events.CollectionEvent} */ singleUpdateEvent;
    for (var /** @type {number} */ i = 0; i < pu.length; i++) {
      var /** @type {org.apache.royale.events.CollectionEvent} */ event = pu[i];
      if (!singleUpdateEvent) {
        singleUpdateEvent = event;
      } else {
        if (singleUpdateEvent.items) {
          throw new Error('still in development');
        }
        singleUpdateEvent.items = [];
        var /** @type {Array} */ currentItems = event.items || [event.item];
        for (var /** @type {number} */ j = 0; j < currentItems.length; j++) {
          singleUpdateEvent.items.push(currentItems[j]);
        }
      }
    }
    if (singleUpdateEvent) {
      this.org_apache_royale_collections_ArrayListView_listChangeHandler(singleUpdateEvent);
    }
  }
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView__needsRefresh;


/**
 * @asprivate
 * @asparam dispatch
 * @asparam autoDispatch
 * @asreturn true if the length of this ArrayListView contents changed
 * @private
 * @param {boolean} dispatch
 * @param {boolean=} autoDispatch
 * @return {boolean}
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_internalRefresh = function(dispatch, autoDispatch) {
  autoDispatch = typeof autoDispatch !== 'undefined' ? autoDispatch : true;
  var /** @type {number} */ originalLen = (this.length) >>> 0;
  if (this.sort || this.filterFunction != null) {
    this.org_apache_royale_collections_ArrayListView_populateLocalIndex();
    if (this.filterFunction != null) {
      var /** @type {Array} */ tmp = [];
      var /** @type {number} */ len = (this.localIndex.length) >> 0;
      for (var /** @type {number} */ i = 0; i < len; i++) {
        var /** @type {Object} */ item = this.localIndex[i];
        if (this.filterFunction(item)) {
          tmp.push(item);
        }
      }
      this.localIndex = tmp;
      if (autoDispatch)
        dispatch = true;
    }
    if (this.sort) {
      this.sort.sort(this.localIndex);
      if (autoDispatch)
        dispatch = true;
    }
  } else if (this.localIndex) {
    this.localIndex = null;
  }
  this.org_apache_royale_collections_ArrayListView__needsRefresh = false;
  this.org_apache_royale_collections_ArrayListView_pendingUpdates = null;
  if (dispatch) {
    var /** @type {org.apache.royale.events.CollectionEvent} */ refreshEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.COLLECTION_CHANGED);
    this.dispatchEvent(refreshEvent);
  }
  return this.length != originalLen;
};


/**
 * Copy all of the data from the source list into the local index.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_populateLocalIndex = function() {
  if (this.list) {
    this.localIndex = this.list.toArray();
  } else {
    this.localIndex = [];
  }
};


/**
 *  @asprivate
 *  When the source list is replaced, reset.
 * @private
 * @param {boolean=} forceDispatch
 */
org.apache.royale.collections.ArrayListView.prototype.org_apache_royale_collections_ArrayListView_reset = function(forceDispatch) {
  forceDispatch = typeof forceDispatch !== 'undefined' ? forceDispatch : false;
  var /** @type {boolean} */ lengthChanged = this.org_apache_royale_collections_ArrayListView_internalRefresh(false, false);
  if (forceDispatch || this.org_apache_royale_collections_ArrayListView_dispatchResetEvent) {
    var /** @type {org.apache.royale.events.CollectionEvent} */ event = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.COLLECTION_CHANGED);
    this.dispatchEvent(event);
  }
  if (lengthChanged) {
    this.dispatchEvent(new org.apache.royale.events.Event('lengthChanged'));
  }
};


org.apache.royale.collections.ArrayListView.prototype.get__id = function() {
  return this.org_apache_royale_collections_ArrayListView__id;
};


org.apache.royale.collections.ArrayListView.prototype.set__id = function(value) {
  if (this.org_apache_royale_collections_ArrayListView__id != value) {
    this.org_apache_royale_collections_ArrayListView__id = value;
    this.dispatchEvent(new org.apache.royale.events.Event("idChanged"));
  }
};


org.apache.royale.collections.ArrayListView.prototype.get__length = function() {
  if (this.localIndex) {
    return (this.localIndex.length) >> 0;
  } else if (this.list) {
    return this.list.length;
  } else {
    return 0;
  }
};


org.apache.royale.collections.ArrayListView.prototype.get__list = function() {
  return this.org_apache_royale_collections_ArrayListView__list;
};


org.apache.royale.collections.ArrayListView.prototype.set__list = function(value) {
  if (this.org_apache_royale_collections_ArrayListView__list != value) {
    var /** @type {boolean} */ oldHasItems;
    var /** @type {boolean} */ newHasItems;
    if (this.org_apache_royale_collections_ArrayListView__list) {
      this.toggleListListeners(this.org_apache_royale_collections_ArrayListView__list, false);
      oldHasItems = this.org_apache_royale_collections_ArrayListView__list.length > 0;
    }
    this.org_apache_royale_collections_ArrayListView__list = value;
    if (this.org_apache_royale_collections_ArrayListView__list) {
      this.toggleListListeners(this.org_apache_royale_collections_ArrayListView__list, true);
      newHasItems = this.org_apache_royale_collections_ArrayListView__list.length > 0;
    }
    if (oldHasItems || newHasItems)
      this.org_apache_royale_collections_ArrayListView_reset();
    this.dispatchEvent(new org.apache.royale.events.Event("listChanged"));
  }
};


org.apache.royale.collections.ArrayListView.prototype.get__source = function() {
  return this.org_apache_royale_collections_ArrayListView__list ? this.org_apache_royale_collections_ArrayListView__list.source : null;
};


org.apache.royale.collections.ArrayListView.prototype.set__source = function(value) {
  if (this.org_apache_royale_collections_ArrayListView__list) {
    this.org_apache_royale_collections_ArrayListView__list.source = value;
  } else {
    this.list = new org.apache.royale.collections.ArrayList(value);
  }
};


org.apache.royale.collections.ArrayListView.prototype.get__filterFunction = function() {
  return this.org_apache_royale_collections_ArrayListView__filterFunction;
};


org.apache.royale.collections.ArrayListView.prototype.set__filterFunction = function(f) {
  if (this.org_apache_royale_collections_ArrayListView__filterFunction != f) {
    this.org_apache_royale_collections_ArrayListView__filterFunction = f;
    this.org_apache_royale_collections_ArrayListView__needsRefresh = true;
    this.dispatchEvent(new org.apache.royale.events.Event("filterFunctionChanged"));
  }
};


org.apache.royale.collections.ArrayListView.prototype.get__sort = function() {
  return this.org_apache_royale_collections_ArrayListView__sort;
};


org.apache.royale.collections.ArrayListView.prototype.set__sort = function(value) {
  if (this.org_apache_royale_collections_ArrayListView__sort != value) {
    this.org_apache_royale_collections_ArrayListView__sort = value;
    this.org_apache_royale_collections_ArrayListView__needsRefresh = true;
    this.dispatchEvent(new org.apache.royale.events.Event("sortChanged"));
  }
};


Object.defineProperties(org.apache.royale.collections.ArrayListView.prototype, /** @lends {org.apache.royale.collections.ArrayListView.prototype} */ {
/**
  * @export
  * @type {string} */
id: {
get: org.apache.royale.collections.ArrayListView.prototype.get__id,
set: org.apache.royale.collections.ArrayListView.prototype.set__id},
/**
  * @export
  * @type {number} */
length: {
get: org.apache.royale.collections.ArrayListView.prototype.get__length},
/**
  * @export
  * @type {org.apache.royale.collections.ArrayList} */
list: {
get: org.apache.royale.collections.ArrayListView.prototype.get__list,
set: org.apache.royale.collections.ArrayListView.prototype.set__list},
/**
  * @export
  * @type {Array} */
source: {
get: org.apache.royale.collections.ArrayListView.prototype.get__source,
set: org.apache.royale.collections.ArrayListView.prototype.set__source},
/**
  * @export
  * @type {Function} */
filterFunction: {
get: org.apache.royale.collections.ArrayListView.prototype.get__filterFunction,
set: org.apache.royale.collections.ArrayListView.prototype.set__filterFunction},
/**
  * @export
  * @type {org.apache.royale.collections.ISort} */
sort: {
get: org.apache.royale.collections.ArrayListView.prototype.get__sort,
set: org.apache.royale.collections.ArrayListView.prototype.set__sort}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.ArrayListView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'ArrayListView', qName: 'org.apache.royale.collections.ArrayListView', kind: 'class' }], interfaces: [org.apache.royale.collections.IArrayListView, org.apache.royale.collections.IArrayList] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.ArrayListView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'id': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ArrayListView'},
        'length': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.collections.ArrayListView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'lengthChanged' } ] } ]; }},
        'list': { type: 'org.apache.royale.collections.ArrayList', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ArrayListView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'listChanged' } ] } ]; }},
        'source': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ArrayListView'},
        'filterFunction': { type: 'Function', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ArrayListView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'filterFunctionChanged' } ] } ]; }},
        'sort': { type: 'org.apache.royale.collections.ISort', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ArrayListView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'sortChanged' } ] } ]; }}
      };
    },
    methods: function () {
      return {
        'ArrayListView': { type: '', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'org.apache.royale.collections.ArrayList', true ]; }},
        'contains': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'Object', false ]; }},
        'disableAutoUpdate': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView'},
        'enableAutoUpdate': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView'},
        'itemUpdated': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'Object', false ]; }},
        'itemUpdatedAt': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'int', false ]; }},
        'refresh': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.ArrayListView'},
        'getItemAt': { type: 'Object', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'int', false ]; }, metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'collectionChanged' } ] } ]; }},
        'setItemAt': { type: 'Object', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'Object', false ,'int', false ]; }},
        'addItem': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'Object', false ]; }},
        'addItemAt': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'Object', false ,'int', false ]; }},
        'addAll': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'org.apache.royale.collections.IArrayList', false ]; }},
        'addAllAt': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'org.apache.royale.collections.IArrayList', false ,'int', false ]; }},
        'getItemIndex': { type: 'int', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'Object', false ]; }},
        'removeItem': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'Object', false ]; }},
        'removeItemAt': { type: 'Object', declaredBy: 'org.apache.royale.collections.ArrayListView', parameters: function () { return [ 'int', false ]; }},
        'removeAll': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayListView'},
        'toArray': { type: 'Array', declaredBy: 'org.apache.royale.collections.ArrayListView'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.collections.ArrayListView.prototype.ROYALE_COMPILE_FLAGS = 10;