/**
 * Generated by Apache Royale Compiler from org/apache/royale/svg/Path.as
 * org.apache.royale.svg.Path
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.svg.Path');

goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.graphics.PathBuilder');
goog.require('org.apache.royale.html.util.createSVG');
goog.require('org.apache.royale.svg.GraphicShape');
goog.require('org.apache.royale.graphics.IDrawable');
goog.require('org.apache.royale.graphics.IPath');



/**
 * @constructor
 * @extends {org.apache.royale.svg.GraphicShape}
 * @implements {org.apache.royale.graphics.IPath}
 * @implements {org.apache.royale.graphics.IDrawable}
 */
org.apache.royale.svg.Path = function() {
  org.apache.royale.svg.Path.base(this, 'constructor');
};
goog.inherits(org.apache.royale.svg.Path, org.apache.royale.svg.GraphicShape);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.svg.Path', org.apache.royale.svg.Path);


/**
 * @private
 * @type {string}
 */
org.apache.royale.svg.Path.prototype.org_apache_royale_svg_Path__data;


/**
 * @private
 * @type {org.apache.royale.graphics.PathBuilder}
 */
org.apache.royale.svg.Path.prototype.org_apache_royale_svg_Path__pathCommands;


/**
 * @private
 * @type {org.apache.royale.core.WrappedHTMLElement}
 */
org.apache.royale.svg.Path.prototype.org_apache_royale_svg_Path__path;


/**
 *  Draw the path.
 *  @asparam data A PathBuilder object containing a vector of drawing commands.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {number} xp
 * @param {number} yp
 * @param {org.apache.royale.graphics.PathBuilder} data
 */
org.apache.royale.svg.Path.prototype.drawPathCommands = function(xp, yp, data) {
  this.drawStringPath(xp, yp, data.getPathString());
};


/**
 *  Draw the path.
 *  @asparam data A string containing a compact represention of the path segments.
 *  The value is a space-delimited string describing each path segment. Each
 *  segment entry has a single character which denotes the segment type and
 *  two or more segment parameters.
 *
 *  If the segment command is upper-case, the parameters are absolute values.
 *  If the segment command is lower-case, the parameters are relative values.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {number} xp
 * @param {number} yp
 * @param {string} data
 */
org.apache.royale.svg.Path.prototype.drawStringPath = function(xp, yp, data) {
  
  if (data == null || data.length === 0)
    return;
  var /** @type {string} */ style = this.getStyleStr();
  if (this.org_apache_royale_svg_Path__path == null) {
    this.org_apache_royale_svg_Path__path = org.apache.royale.html.util.createSVG('path');
    this.org_apache_royale_svg_Path__path.royale_wrapper = this;
    this.element.appendChild(this.org_apache_royale_svg_Path__path);
  }
  this.org_apache_royale_svg_Path__path.setAttribute('style', style);
  this.org_apache_royale_svg_Path__path.setAttribute('d', data);
  this.resize(this.x, this.y);
};


/**
 * @protected
 * @override
 */
org.apache.royale.svg.Path.prototype.drawImpl = function() {
  this.drawStringPath(0, 0, this.data);
};


/**
 * @export
 */
org.apache.royale.svg.Path.prototype.draw = function() {
  this.drawImpl();
};


org.apache.royale.svg.Path.prototype.get__data = function() {
  return this.org_apache_royale_svg_Path__data;
};


org.apache.royale.svg.Path.prototype.set__data = function(value) {
  this.org_apache_royale_svg_Path__data = value;
  this.org_apache_royale_svg_Path__pathCommands = null;
  this.updateView();
};


org.apache.royale.svg.Path.prototype.get__pathCommands = function() {
  return this.org_apache_royale_svg_Path__pathCommands;
};


org.apache.royale.svg.Path.prototype.set__pathCommands = function(value) {
  this.org_apache_royale_svg_Path__pathCommands = value;
  this.org_apache_royale_svg_Path__data = this.org_apache_royale_svg_Path__pathCommands.getPathString();
  this.updateView();
};


Object.defineProperties(org.apache.royale.svg.Path.prototype, /** @lends {org.apache.royale.svg.Path.prototype} */ {
/**
  * @export
  * @type {string} */
data: {
get: org.apache.royale.svg.Path.prototype.get__data,
set: org.apache.royale.svg.Path.prototype.set__data},
/**
  * @export
  * @type {org.apache.royale.graphics.PathBuilder} */
pathCommands: {
get: org.apache.royale.svg.Path.prototype.get__pathCommands,
set: org.apache.royale.svg.Path.prototype.set__pathCommands}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.svg.Path.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Path', qName: 'org.apache.royale.svg.Path', kind: 'class' }], interfaces: [org.apache.royale.graphics.IPath, org.apache.royale.graphics.IDrawable] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.svg.Path.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'data': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Path'},
        'pathCommands': { type: 'org.apache.royale.graphics.PathBuilder', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Path'}
      };
    },
    methods: function () {
      return {
        'drawPathCommands': { type: 'void', declaredBy: 'org.apache.royale.svg.Path', parameters: function () { return [ 'Number', false ,'Number', false ,'org.apache.royale.graphics.PathBuilder', false ]; }},
        'drawStringPath': { type: 'void', declaredBy: 'org.apache.royale.svg.Path', parameters: function () { return [ 'Number', false ,'Number', false ,'String', false ]; }},
        'draw': { type: 'void', declaredBy: 'org.apache.royale.svg.Path'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.svg.Path.prototype.ROYALE_COMPILE_FLAGS = 10;