/**
 * Generated by Apache Royale Compiler from org/apache/royale/svg/Image.as
 * org.apache.royale.svg.Image
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.svg.Image');

goog.require('org.apache.royale.core.ImageBase');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.util.addSvgElementToWrapper');
goog.require('org.apache.royale.html.util.createSVG');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.7
 * @constructor
 * @extends {org.apache.royale.core.ImageBase}
 */
org.apache.royale.svg.Image = function() {
  org.apache.royale.svg.Image.base(this, 'constructor');
};
goog.inherits(org.apache.royale.svg.Image, org.apache.royale.core.ImageBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.svg.Image', org.apache.royale.svg.Image);


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.royale.svg.Image.prototype.createElement = function() {
  org.apache.royale.html.util.addSvgElementToWrapper(this, 'svg');
  this.element.setAttribute('x', 0);
  this.element.setAttribute('y', 0);
  this.addImageElement();
  return this.element;
};


/**
 * @protected
 * @type {Object}
 */
org.apache.royale.svg.Image.prototype._image;


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @protected
 */
org.apache.royale.svg.Image.prototype.addImageElement = function() {
  if (this._image == null) {
    this._image = org.apache.royale.html.util.createSVG('image');
    this._image.setAttribute("width", "100%");
    this._image.setAttribute("height", "100%");
    this._image.royale_wrapper = this;
    this.element.appendChild(this._image);
  }
};


/**
 * @export
 * @override
 */
org.apache.royale.svg.Image.prototype.applyImageData = function(binaryDataAsString) {
  org.apache.royale.utils.Language.as(this._image, SVGImageElement).setAttributeNS('http://www.w3.org/1999/xlink', 'href', binaryDataAsString);
};


/**
 * @export
 * @override
 */
org.apache.royale.svg.Image.prototype.setWidth = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  org.apache.royale.svg.Image.superClass_.setWidth.apply(this, [ value, noEvent] );
  this.positioner.setAttribute("width", value);
};


/**
 * @export
 * @override
 */
org.apache.royale.svg.Image.prototype.setHeight = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  org.apache.royale.svg.Image.superClass_.setHeight.apply(this, [ value, noEvent] );
  this.positioner.setAttribute("height", value);
};


/**
 * @export
 * @override
 */
org.apache.royale.svg.Image.prototype.setX = function(value) {
  org.apache.royale.svg.Image.superClass_.setX.apply(this, [ value] );
  this.positioner.setAttribute("x", value);
};


/**
 * @export
 * @override
 */
org.apache.royale.svg.Image.prototype.setY = function(value) {
  org.apache.royale.svg.Image.superClass_.setY.apply(this, [ value] );
  this.positioner.setAttribute("y", value);
};


org.apache.royale.svg.Image.prototype.get__imageElement = function() {
  return this._image;
};


org.apache.royale.svg.Image.prototype.get__transformElement = function() {
  return this._image;
};


org.apache.royale.svg.Image.prototype.set__x = function(value) {
  org.apache.royale.svg.Image.superClass_.set__x.apply(this, [ value] );
  this.positioner.setAttribute("x", value);
};


org.apache.royale.svg.Image.prototype.set__y = function(value) {
  org.apache.royale.svg.Image.superClass_.set__y.apply(this, [ value] );
  this.positioner.setAttribute("y", value);
};


Object.defineProperties(org.apache.royale.svg.Image.prototype, /** @lends {org.apache.royale.svg.Image.prototype} */ {
/**
  * @export
  * @type {Element} */
imageElement: {
get: org.apache.royale.svg.Image.prototype.get__imageElement},
/**
  * @export
  * @type {org.apache.royale.core.WrappedHTMLElement} */
transformElement: {
get: org.apache.royale.svg.Image.prototype.get__transformElement},
/**
  * @export
  * @type {number} */
x: {
get: org.apache.royale.core.UIBase.prototype.get__x,
set: org.apache.royale.svg.Image.prototype.set__x},
/**
  * @export
  * @type {number} */
y: {
get: org.apache.royale.core.UIBase.prototype.get__y,
set: org.apache.royale.svg.Image.prototype.set__y}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.svg.Image.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Image', qName: 'org.apache.royale.svg.Image', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.svg.Image.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'imageElement': { type: 'Element', access: 'readonly', declaredBy: 'org.apache.royale.svg.Image'},
        'transformElement': { type: 'org.apache.royale.core.WrappedHTMLElement', access: 'readonly', declaredBy: 'org.apache.royale.svg.Image'},
        'x': { type: 'Number', access: 'writeonly', declaredBy: 'org.apache.royale.svg.Image'},
        'y': { type: 'Number', access: 'writeonly', declaredBy: 'org.apache.royale.svg.Image'}
      };
    },
    methods: function () {
      return {
        'Image': { type: '', declaredBy: 'org.apache.royale.svg.Image'},
        'applyImageData': { type: 'void', declaredBy: 'org.apache.royale.svg.Image', parameters: function () { return [ 'String', false ]; }},
        'setWidth': { type: 'void', declaredBy: 'org.apache.royale.svg.Image', parameters: function () { return [ 'Number', false ,'Boolean', true ]; }},
        'setHeight': { type: 'void', declaredBy: 'org.apache.royale.svg.Image', parameters: function () { return [ 'Number', false ,'Boolean', true ]; }},
        'setX': { type: 'void', declaredBy: 'org.apache.royale.svg.Image', parameters: function () { return [ 'Number', false ]; }},
        'setY': { type: 'void', declaredBy: 'org.apache.royale.svg.Image', parameters: function () { return [ 'Number', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.svg.Image.prototype.ROYALE_COMPILE_FLAGS = 10;