/**
 * Generated by Apache Royale Compiler from org/apache/royale/svg/CompoundGraphic.as
 * org.apache.royale.svg.CompoundGraphic
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.svg.CompoundGraphic');

goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.graphics.IFill');
goog.require('org.apache.royale.graphics.IStroke');
goog.require('org.apache.royale.graphics.PathBuilder');
goog.require('org.apache.royale.html.util.createSVG');
goog.require('org.apache.royale.svg.GraphicShape');
goog.require('org.apache.royale.svg.Text');
goog.require('org.apache.royale.graphics.ICompoundGraphic');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.svg.GraphicShape}
 * @implements {org.apache.royale.graphics.ICompoundGraphic}
 */
org.apache.royale.svg.CompoundGraphic = function() {
  org.apache.royale.svg.CompoundGraphic.base(this, 'constructor');
};
goog.inherits(org.apache.royale.svg.CompoundGraphic, org.apache.royale.svg.GraphicShape);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.svg.CompoundGraphic', org.apache.royale.svg.CompoundGraphic);


/**
 * @private
 * @type {org.apache.royale.graphics.IFill}
 */
org.apache.royale.svg.CompoundGraphic.prototype.org_apache_royale_svg_CompoundGraphic__textFill;


/**
 * @private
 * @type {org.apache.royale.graphics.IStroke}
 */
org.apache.royale.svg.CompoundGraphic.prototype.org_apache_royale_svg_CompoundGraphic__textStroke;


/**
 *  Removes all of the drawn elements of the container.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0.3
 * @export
 */
org.apache.royale.svg.CompoundGraphic.prototype.removeAllElements = function() {
  this.clear();
};


/**
 *  Clears all of the drawn path data.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.7.0
 * @export
 */
org.apache.royale.svg.CompoundGraphic.prototype.clear = function() {
  
  var /** @type {HTMLElement} */ svg = this.element;
  while (svg.lastChild) {
    svg.removeChild(svg.lastChild);
  }
};


/**
 *  Draw the rectangle.
 *  @asparam x The x position of the top-left corner of the rectangle.
 *  @asparam y The y position of the top-left corner.
 *  @asparam width The width of the rectangle.
 *  @asparam height The height of the rectangle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0.3
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawRect = function(x, y, width, height) {
  
  this.drawRoundRect(x, y, width, height, NaN);
};


/**
 *  Draws a rounded rectangle.
 *  Note: The radius values are different than the Flash API of the same name. Flash uses diameter instead of radius.
 *  @asparam x The x position of the top-left corner of the rectangle.
 *  @asparam y The y position of the top-left corner.
 *  @asparam width The width of the rectangle.
 *  @asparam height The height of the rectangle.
 *  @asparam radiusX The horizontal radius of the rounded corners (in pixels).
 *  @asparam radiusY The vertical radius of the rounded corners (in pixels). Optional; if no value is specified, the default value matches that provided for the <code>radiusX</code> parameter.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0.3
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} radiusX
 * @param {number=} radiusY
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawRoundRect = function(x, y, width, height, radiusX, radiusY) {
  radiusY = typeof radiusY !== 'undefined' ? radiusY : NaN;
  
  if (isNaN(radiusY))
    radiusY = radiusX;
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ rect = org.apache.royale.html.util.createSVG('rect');
  rect.royale_wrapper = this;
  rect.style.left = x + "px";
  rect.style.top = y + "px";
  rect.setAttribute('style', style);
  rect.setAttribute('x', x);
  rect.setAttribute('y', y);
  rect.setAttribute('width', width);
  rect.setAttribute('height', height);
  if (!isNaN(radiusX)) {
    rect.setAttribute('rx', radiusX);
    rect.setAttribute('ry', radiusY);
  }
  this.addElementToSurface(rect);
};


/**
 *  Draw the ellipse.
 *  @asparam x The x position of the top-left corner of the bounding box of the ellipse.
 *  @asparam y The y position of the top-left corner of the bounding box of the ellipse.
 *  @asparam width The width of the ellipse.
 *  @asparam height The height of the ellipse.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0.3
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawEllipse = function(x, y, width, height) {
  
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ ellipse = org.apache.royale.html.util.createSVG('ellipse');
  ellipse.royale_wrapper = this;
  ellipse.style.left = x + "px";
  ellipse.style.top = y + "px";
  ellipse.setAttribute('style', style);
  ellipse.setAttribute('cx', x + width / 2);
  ellipse.setAttribute('cy', y + height / 2);
  ellipse.setAttribute('rx', width / 2);
  ellipse.setAttribute('ry', height / 2);
  this.addElementToSurface(ellipse);
};


/**
 *  Draw the circle.
 *  @asparam x The x location of the center of the circle
 *  @asparam y The y location of the center of the circle.
 *  @asparam radius The radius of the circle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} radius
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawCircle = function(x, y, radius) {
  
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ circle = org.apache.royale.html.util.createSVG('ellipse');
  circle.royale_wrapper = this;
  circle.style.left = x + "px";
  circle.style.top = y + "px";
  circle.setAttribute('style', style);
  circle.setAttribute('cx', x);
  circle.setAttribute('cy', y);
  circle.setAttribute('rx', radius);
  circle.setAttribute('ry', radius);
  this.addElementToSurface(circle);
};


/**
 *  Draw the path.
 *  @asparam data A PathBuilder object containing a vector of drawing commands.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {org.apache.royale.graphics.PathBuilder} data
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawPathCommands = function(data) {
  this.drawStringPath(data.getPathString());
};


/**
 *  Draw the path.
 *  @asparam data A string containing a compact represention of the path segments.
 *  The value is a space-delimited string describing each path segment. Each
 *  segment entry has a single character which denotes the segment type and
 *  two or more segment parameters.
 *
 *  If the segment command is upper-case, the parameters are absolute values.
 *  If the segment command is lower-case, the parameters are relative values.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {string} data
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawStringPath = function(data) {
  
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ path = org.apache.royale.html.util.createSVG('path');
  path.royale_wrapper = this;
  path.style.left = "0px";
  path.style.top = "0px";
  path.setAttribute('style', style);
  path.setAttribute('d', data);
  this.addElementToSurface(path);
};


/**
 * @export
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawLine = function() {
};


/**
 * @export
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawPolygon = function() {
};


/**
 * Draws a rounded rectangle using the size of a radius to draw the rounded corners. 
 * You must set the line style, fill, or both 
 * on the Graphics object before 
 * you call the <code>drawRoundRectComplex()</code> method 
 * by calling the <code>linestyle()</code>, 
 * <code>lineGradientStyle()</code>, <code>beginFill()</code>, 
 * <code>beginGradientFill()</code>, or 
 * <code>beginBitmapFill()</code> method.
 * 
 * @asparam graphics The Graphics object that draws the rounded rectangle.
 *
 * @asparam x The horizontal position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam y The vertical position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam width The width of the round rectangle, in pixels.
 * 
 * @asparam height The height of the round rectangle, in pixels.
 * 
 * @asparam topLeftRadius The radius of the upper-left corner, in pixels.
 * 
 * @asparam topRightRadius The radius of the upper-right corner, in pixels.
 * 
 * @asparam bottomLeftRadius The radius of the bottom-left corner, in pixels.
 * 
 * @asparam bottomRightRadius The radius of the bottom-right corner, in pixels.
 *
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 1.0.0
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} topLeftRadius
 * @param {number} topRightRadius
 * @param {number} bottomLeftRadius
 * @param {number} bottomRightRadius
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawRoundRectComplex = function(x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius) {
  
  var /** @type {org.apache.royale.graphics.PathBuilder} */ builder = new org.apache.royale.graphics.PathBuilder();
  builder.drawRoundRectComplex(x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius);
  this.drawStringPath(builder.getPathString());
};


/**
 * Draws a rounded rectangle using the size of individual x and y radii to 
 * draw the rounded corners. 
 * You must set the line style, fill, or both 
 * on the Graphics object before 
 * you call the <code>drawRoundRectComplex2()</code> method 
 * by calling the <code>linestyle()</code>, 
 * <code>lineGradientStyle()</code>, <code>beginFill()</code>, 
 * <code>beginGradientFill()</code>, or 
 * <code>beginBitmapFill()</code> method.
 * 
 * @asparam graphics The Graphics object that draws the rounded rectangle.
 *
 * @asparam x The horizontal position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam y The vertical position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam width The width of the round rectangle, in pixels.
 * 
 * @asparam height The height of the round rectangle, in pixels.
 * 
 * @asparam radiusX The default radiusX to use, if corner-specific values are not specified.
 * This value must be specified.
 * 
 * @asparam radiusY The default radiusY to use, if corner-specific values are not specified. 
 * If 0, the value of radiusX is used.
 * 
 * @asparam topLeftRadiusX The x radius of the upper-left corner, in pixels. If NaN, 
 * the value of radiusX is used.
 * 
 * @asparam topLeftRadiusY The y radius of the upper-left corner, in pixels. If NaN,
 * the value of topLeftRadiusX is used.
 * 
 * @asparam topRightRadiusX The x radius of the upper-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam topRightRadiusY The y radius of the upper-right corner, in pixels. If NaN,
 * the value of topRightRadiusX is used.
 * 
 * @asparam bottomLeftRadiusX The x radius of the bottom-left corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomLeftRadiusY The y radius of the bottom-left corner, in pixels. If NaN,
 * the value of bottomLeftRadiusX is used.
 * 
 * @asparam bottomRightRadiusX The x radius of the bottom-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomRightRadiusY The y radius of the bottom-right corner, in pixels. If NaN,
 * the value of bottomRightRadiusX is used.
 * 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Royale 1.0.0
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} radiusX
 * @param {number} radiusY
 * @param {number} topLeftRadiusX
 * @param {number} topLeftRadiusY
 * @param {number} topRightRadiusX
 * @param {number} topRightRadiusY
 * @param {number} bottomLeftRadiusX
 * @param {number} bottomLeftRadiusY
 * @param {number} bottomRightRadiusX
 * @param {number} bottomRightRadiusY
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawRoundRectComplex2 = function(x, y, width, height, radiusX, radiusY, topLeftRadiusX, topLeftRadiusY, topRightRadiusX, topRightRadiusY, bottomLeftRadiusX, bottomLeftRadiusY, bottomRightRadiusX, bottomRightRadiusY) {
  var /** @type {org.apache.royale.graphics.PathBuilder} */ builder = new org.apache.royale.graphics.PathBuilder();
  builder.drawRoundRectComplex2(x, y, width, height, radiusX, radiusY, topLeftRadiusX, topLeftRadiusY, topRightRadiusX, topRightRadiusY, bottomLeftRadiusX, bottomLeftRadiusY, bottomRightRadiusX, bottomRightRadiusY);
  
  this.drawStringPath(builder.getPathString());
};


/**
 *  Draw a string of characters.
 *  @asparam value The string to draw.
 *  @asparam x The x location of the center of the circle
 *  @asparam y The y location of the center of the circle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 *  @royaleignorecoercion Text
 *  @royaleignorecoercion Node
 * @export
 * @param {string} value
 * @param {number} x
 * @param {number} y
 * @return {Object}
 */
org.apache.royale.svg.CompoundGraphic.prototype.drawText = function(value, x, y) {
  
  var /** @type {string} */ style = this.getTxtStyleStr();
  var /** @type {Object} */ text = org.apache.royale.html.util.createSVG('text');
  text.royale_wrapper = this;
  text.style.left = x + "px";
  text.style.top = y + "px";
  text.setAttribute('style', style);
  text.setAttribute('x', x);
  text.setAttribute('y', y + 15);
  var /** @type {org.apache.royale.svg.Text} */ textNode = org.apache.royale.utils.Language.as(document.createTextNode(value), org.apache.royale.svg.Text);
  text.appendChild(textNode);
  this.addElementToSurface(text);
  return text;
};


/**
 * @asreturn {string} The style attribute.
 * @export
 * @return {string}
 */
org.apache.royale.svg.CompoundGraphic.prototype.getTxtStyleStr = function() {
  var /** @type {string} */ fillStr;
  if (this.textFill) {
    fillStr = this.textFill.addFillAttrib(this);
  } else {
    fillStr = 'fill:none';
  }
  var /** @type {string} */ strokeStr;
  if (this.textStroke) {
    strokeStr = this.textStroke.addStrokeAttrib(this);
  } else {
    strokeStr = 'stroke:none';
  }
  return fillStr + ';' + strokeStr;
};


/**
 * @protected
 * @param {org.apache.royale.core.WrappedHTMLElement} e
 */
org.apache.royale.svg.CompoundGraphic.prototype.addElementToSurface = function(e) {
  this.element.appendChild(e);
};


org.apache.royale.svg.CompoundGraphic.prototype.get__textFill = function() {
  return this.org_apache_royale_svg_CompoundGraphic__textFill;
};


org.apache.royale.svg.CompoundGraphic.prototype.set__textFill = function(value) {
  this.org_apache_royale_svg_CompoundGraphic__textFill = value;
};


org.apache.royale.svg.CompoundGraphic.prototype.get__textStroke = function() {
  return this.org_apache_royale_svg_CompoundGraphic__textStroke;
};


org.apache.royale.svg.CompoundGraphic.prototype.set__textStroke = function(value) {
  this.org_apache_royale_svg_CompoundGraphic__textStroke = value;
};


Object.defineProperties(org.apache.royale.svg.CompoundGraphic.prototype, /** @lends {org.apache.royale.svg.CompoundGraphic.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.graphics.IFill} */
textFill: {
get: org.apache.royale.svg.CompoundGraphic.prototype.get__textFill,
set: org.apache.royale.svg.CompoundGraphic.prototype.set__textFill},
/**
  * @export
  * @type {org.apache.royale.graphics.IStroke} */
textStroke: {
get: org.apache.royale.svg.CompoundGraphic.prototype.get__textStroke,
set: org.apache.royale.svg.CompoundGraphic.prototype.set__textStroke}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.svg.CompoundGraphic.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'CompoundGraphic', qName: 'org.apache.royale.svg.CompoundGraphic', kind: 'class' }], interfaces: [org.apache.royale.graphics.ICompoundGraphic] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.svg.CompoundGraphic.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'textFill': { type: 'org.apache.royale.graphics.IFill', access: 'readwrite', declaredBy: 'org.apache.royale.svg.CompoundGraphic'},
        'textStroke': { type: 'org.apache.royale.graphics.IStroke', access: 'readwrite', declaredBy: 'org.apache.royale.svg.CompoundGraphic'}
      };
    },
    methods: function () {
      return {
        'removeAllElements': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic'},
        'clear': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic'},
        'drawRect': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ,'Number', false ]; }},
        'drawRoundRect': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', true ]; }},
        'drawEllipse': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ,'Number', false ]; }},
        'drawCircle': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ]; }},
        'drawPathCommands': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'org.apache.royale.graphics.PathBuilder', false ]; }},
        'drawStringPath': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'String', false ]; }},
        'drawLine': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic'},
        'drawPolygon': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic'},
        'drawRoundRectComplex': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ]; }},
        'drawRoundRectComplex2': { type: 'void', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ,'Number', false ]; }},
        'drawText': { type: 'Object', declaredBy: 'org.apache.royale.svg.CompoundGraphic', parameters: function () { return [ 'String', false ,'Number', false ,'Number', false ]; }},
        'getTxtStyleStr': { type: 'String', declaredBy: 'org.apache.royale.svg.CompoundGraphic'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.svg.CompoundGraphic.prototype.ROYALE_COMPILE_FLAGS = 10;