/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/layouts/DataGridLayout.as
 * org.apache.royale.html.beads.layouts.DataGridLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.layouts.DataGridLayout');

goog.require('org.apache.royale.core.IBorderPaddingMarginValuesImpl');
goog.require('org.apache.royale.core.IDataGridModel');
goog.require('org.apache.royale.core.ILayoutHost');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.ValuesManager');
goog.require('org.apache.royale.core.layout.EdgeData');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.html.beads.IDataGridView');
goog.require('org.apache.royale.html.beads.models.ButtonBarModel');
goog.require('org.apache.royale.html.supportClasses.IDataGridColumn');
goog.require('org.apache.royale.core.IBeadLayout');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @implements {org.apache.royale.core.IBeadLayout}
 */
org.apache.royale.html.beads.layouts.DataGridLayout = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.layouts.DataGridLayout', org.apache.royale.html.beads.layouts.DataGridLayout);


/**
 * @protected
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype._strand;


/**
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.org_apache_royale_html_beads_layouts_DataGridLayout_handleSizeChanges = function(event) {
  var /** @type {org.apache.royale.core.ILayoutHost} */ viewBead = org.apache.royale.utils.Language.as(this.uiHost.view, org.apache.royale.core.ILayoutHost);
  if (viewBead.beforeLayout())
    this.layout();
};


/**
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.org_apache_royale_html_beads_layouts_DataGridLayout_handleLayoutNeeded = function(event) {
  var /** @type {org.apache.royale.core.ILayoutHost} */ viewBead = org.apache.royale.utils.Language.as(this.uiHost.view, org.apache.royale.core.ILayoutHost);
  if (viewBead.beforeLayout())
    this.layout();
};


/**
 * @protected
 * @return {Array}
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.getColumnsForLayout = function() {
  var /** @type {org.apache.royale.core.IUIBase} */ header = org.apache.royale.utils.Language.as(this.uiHost.view, org.apache.royale.html.beads.IDataGridView).header;
  var /** @type {org.apache.royale.html.beads.models.ButtonBarModel} */ bbmodel = org.apache.royale.utils.Language.as(header.getBeadByType(org.apache.royale.html.beads.models.ButtonBarModel), org.apache.royale.html.beads.models.ButtonBarModel);
  return org.apache.royale.utils.Language.as(bbmodel.dataProvider, Array);
};


/**
 * @protected
 * @param {Array} columnWidths
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.setHeaderWidths = function(columnWidths) {
  var /** @type {org.apache.royale.core.IUIBase} */ header = org.apache.royale.utils.Language.as(this.uiHost.view, org.apache.royale.html.beads.IDataGridView).header;
  var /** @type {org.apache.royale.html.beads.models.ButtonBarModel} */ bbmodel = org.apache.royale.utils.Language.as(header.getBeadByType(org.apache.royale.html.beads.models.ButtonBarModel), org.apache.royale.html.beads.models.ButtonBarModel);
  bbmodel.buttonWidths = columnWidths;
};


/**
 * @copy org.apache.royale.core.IBeadLayout#layout
 * @royaleignorecoercion org.apache.royale.core.IBorderPaddingMarginValuesImpl
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @royaleignorecoercion org.apache.royale.core.ILayoutHost
 * @royaleignorecoercion org.apache.royale.core.IUIBase
 * @royaleignorecoercion org.apache.royale.core.UIBase
 * @royaleignorecoercion org.apache.royale.html.beads.IDataGridView
 * @royaleignorecoercion org.apache.royale.html.beads.models.ButtonBarModel
 * @royaleignorecoercion org.apache.royale.html.supportClasses.IDataGridColumn
 * @export
 * @return {boolean}
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.layout = function() {
  var /** @type {Object} */ header = this.uiHost.view.header;
  var /** @type {Array} */ arrayOfColumns = this.getColumnsForLayout();
  var /** @type {Object} */ listArea = this.uiHost.view.listArea;
  var /** @type {Array} */ displayedColumns = this.uiHost.view.columnLists;
  var /** @type {Object} */ model = this.uiHost.model;
  var /** @type {org.apache.royale.core.layout.EdgeData} */ borderMetrics = org.apache.royale.core.ValuesManager["valuesImpl"].getBorderMetrics(this._strand);
  var /** @type {number} */ useWidth = this.uiHost.width - (borderMetrics.left + borderMetrics.right);
  var /** @type {number} */ useHeight = this.uiHost.height - (borderMetrics.top + borderMetrics.bottom);
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ defaultColumnWidth = useWidth / arrayOfColumns.length;
  var /** @type {Array} */ columnWidths = [];
  for (var /** @type {number} */ i = 0; i < arrayOfColumns.length; i++) {
    var /** @type {Object} */ columnDef = arrayOfColumns[i];
    var /** @type {Object} */ columnList = displayedColumns[i];
    columnList.x = xpos;
    columnList.y = 0;
    var /** @type {number} */ columnWidth = defaultColumnWidth;
    if (!isNaN(columnDef.columnWidth)) {
      columnWidth = columnDef.columnWidth;
    }
    columnList.width = columnWidth;
    columnWidths.push(columnWidth);
    xpos += columnList.width;
  }
  this.setHeaderWidths(columnWidths);
  
  header.percentWidth = 100;
  listArea.element.style.position = "absolute";
  if (!(this.uiHost.element.style.position == 'absolute' || this.uiHost.element.style.position == 'relative' || this.uiHost.element.style.position == 'fixed'))
    this.uiHost.element.style.position = 'relative';
  listArea.y = header.height + header.y;
  
  listArea.percentWidth = 100;
  listArea.height = useHeight - header.height;
  header.dispatchEvent(new org.apache.royale.events.Event("layoutNeeded"));
  listArea.dispatchEvent(new org.apache.royale.events.Event("layoutNeeded"));
  return true;
};


org.apache.royale.html.beads.layouts.DataGridLayout.prototype.set__strand = function(value) {
  this._strand = value;
  this._strand.addEventListener("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_DataGridLayout_handleSizeChanges, this, 'org_apache_royale_html_beads_layouts_DataGridLayout_handleSizeChanges'));
  this._strand.addEventListener("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_DataGridLayout_handleSizeChanges, this, 'org_apache_royale_html_beads_layouts_DataGridLayout_handleSizeChanges'));
  this._strand.addEventListener("sizeChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_DataGridLayout_handleSizeChanges, this, 'org_apache_royale_html_beads_layouts_DataGridLayout_handleSizeChanges'));
  this._strand.addEventListener("layoutNeeded", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_DataGridLayout_handleLayoutNeeded, this, 'org_apache_royale_html_beads_layouts_DataGridLayout_handleLayoutNeeded'));
};


org.apache.royale.html.beads.layouts.DataGridLayout.prototype.get__uiHost = function() {
  return this._strand;
};


Object.defineProperties(org.apache.royale.html.beads.layouts.DataGridLayout.prototype, /** @lends {org.apache.royale.html.beads.layouts.DataGridLayout.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.layouts.DataGridLayout.prototype.set__strand},
/**
  * @type {org.apache.royale.core.UIBase} */
uiHost: {
get: org.apache.royale.html.beads.layouts.DataGridLayout.prototype.get__uiHost}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DataGridLayout', qName: 'org.apache.royale.html.beads.layouts.DataGridLayout', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadLayout] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.layouts.DataGridLayout'}
      };
    },
    methods: function () {
      return {
        'DataGridLayout': { type: '', declaredBy: 'org.apache.royale.html.beads.layouts.DataGridLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.royale.html.beads.layouts.DataGridLayout'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.layouts.DataGridLayout.prototype.ROYALE_COMPILE_FLAGS = 10;