/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/controllers/MenuSelectionMouseController.as
 * org.apache.royale.html.beads.controllers.MenuSelectionMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.controllers.MenuSelectionMouseController');

goog.require('org.apache.royale.core.IMenu');
goog.require('org.apache.royale.core.IPopUpHost');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.BrowserEvent');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.ItemAddedEvent');
goog.require('org.apache.royale.events.ItemClickedEvent');
goog.require('org.apache.royale.events.ItemRemovedEvent');
goog.require('org.apache.royale.html.beads.controllers.ListSingleSelectionMouseController');
goog.require('org.apache.royale.html.beads.models.MenuModel');
goog.require('org.apache.royale.utils.UIUtils');
goog.require('org.apache.royale.utils.sendEvent');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.html.beads.controllers.ListSingleSelectionMouseController}
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController = function() {
  org.apache.royale.html.beads.controllers.MenuSelectionMouseController.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.controllers.MenuSelectionMouseController, org.apache.royale.html.beads.controllers.ListSingleSelectionMouseController);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.controllers.MenuSelectionMouseController', org.apache.royale.html.beads.controllers.MenuSelectionMouseController);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.org_apache_royale_html_beads_controllers_MenuSelectionMouseController__strand;


/**
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @override
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.handleItemAdded = function(event) {
  event.item.addEventListener("itemClicked", org.apache.royale.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  event.item.addEventListener("itemRollOver", org.apache.royale.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  event.item.addEventListener("itemRollOut", org.apache.royale.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @override
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.handleItemRemoved = function(event) {
  event.item.removeEventListener("itemClicked", org.apache.royale.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  event.item.removeEventListener("itemRollOver", org.apache.royale.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  event.item.removeEventListener("itemRollOut", org.apache.royale.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * Listen for selections made on the component and translate them into change events.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @protected
 * @override
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.selectedHandler = function(event) {
  var /** @type {org.apache.royale.events.IEventDispatcher} */ menuDispatcher = this.findMenuDispatcher();
  var /** @type {org.apache.royale.core.UIBase} */ list = org.apache.royale.utils.Language.as(menuDispatcher, org.apache.royale.core.UIBase);
  var /** @type {Object} */ node = event.data;
  list.model.selectedItem = node;
  org.apache.royale.utils.sendEvent(menuDispatcher, "change");
  this.hideOpenMenus();
};


/**
 * Finds and returns the object from which events should be dispatched. This
 * may be the Menu itself of the menu's parent menu bar.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @protected
 * @return {org.apache.royale.events.IEventDispatcher}
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.findMenuDispatcher = function() {
  var /** @type {org.apache.royale.core.IMenu} */ menu = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_controllers_MenuSelectionMouseController__strand, org.apache.royale.core.IMenu);
  if (menu.parentMenuBar)
    return menu.parentMenuBar;
  else
    return org.apache.royale.utils.Language.as(menu, org.apache.royale.events.IEventDispatcher);
};


/**
 * Hides any menus that are open. This means only one pop-up menu (or set of cascading menus)
 * may be open at one time.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 *  @royaleignorecoercion org.apache.royale.core.UIBase
 *  @royaleignorecoercion org.apache.royale.core.IUIBase
 * @protected
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.hideOpenMenus = function() {
  var /** @type {Array} */ copy = org.apache.royale.html.beads.models.MenuModel["menuList"].concat();
  for (var /** @type {number} */ i = 0; i < copy.length; i++) {
    var /** @type {Object} */ menu = copy[i];
    this.removeMenu(menu);
  }
  org.apache.royale.html.beads.models.MenuModel.clearMenuList();
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.org_apache_royale_html_beads_controllers_MenuSelectionMouseController_handleHideMenus = function(event) {
  this.hideOpenMenus();
};


/**
 * @protected
 * @param {org.apache.royale.core.UIBase} menu
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.removeMenu = function(menu) {
  if (menu.parent != null) {
    var /** @type {org.apache.royale.html.beads.controllers.MenuSelectionMouseController} */ controller = org.apache.royale.utils.Language.as(menu.getBeadByType(org.apache.royale.html.beads.controllers.MenuSelectionMouseController), org.apache.royale.html.beads.controllers.MenuSelectionMouseController);
    controller.removeClickOutHandler(menu);
    var /** @type {org.apache.royale.core.IPopUpHost} */ host = org.apache.royale.utils.UIUtils.findPopUpHost(org.apache.royale.utils.Language.as(menu, org.apache.royale.core.IUIBase));
    if (host)
      host.popUpParent.removeElement(menu);
  }
};


/**
 * @asprivate
 * 
 * Removes the event handler that detects clicks outside of the menu.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 *  @royaleignorecoercion org.apache.royale.core.IUIBase
 *  @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @export
 * @param {Object} menu
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.removeClickOutHandler = function(menu) {
  org.apache.royale.html.beads.models.MenuModel.removeMenu(menu);
  var /** @type {Object} */ host = org.apache.royale.utils.UIUtils.findPopUpHost(menu);
  host.removeEventListener("hideMenus", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_controllers_MenuSelectionMouseController_handleHideMenus, this, 'org_apache_royale_html_beads_controllers_MenuSelectionMouseController_handleHideMenus'));
  
  window.removeEventListener('mouseup', org.apache.royale.utils.Language.closure(this.hideMenu_internal, this, 'hideMenu_internal'), false);
};


/**
 * @royaleignorecoercion HTMLElement
 * @royaleignorecoercion org.apache.royale.core.IUIBase
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.BrowserEvent} event
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.hideMenu_internal = function(event) {
  var /** @type {org.apache.royale.core.IMenu} */ menu = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_controllers_MenuSelectionMouseController__strand, org.apache.royale.core.IMenu);
  var /** @type {HTMLElement} */ menuElem = this.org_apache_royale_html_beads_controllers_MenuSelectionMouseController__strand.element;
  var /** @type {HTMLElement} */ menuBarElement;
  if (menu.parentMenuBar) {
    menuBarElement = menu.parentMenuBar.element;
  }
  var /** @type {HTMLElement} */ target = event.target;
  while (target != null) {
    var /** @type {Object} */ comp = target["royale_wrapper"];
    if (comp && (org.apache.royale.utils.Language.is(comp, org.apache.royale.core.IMenu) || comp == menu.parentMenuBar))
      return;
    target = target.parentNode;
  }
  this.hideOpenMenus();
};


org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_controllers_MenuSelectionMouseController__strand = value;
  org.apache.royale.html.beads.controllers.MenuSelectionMouseController.superClass_.set__strand.apply(this, [ value] );
  var /** @type {org.apache.royale.events.IEventDispatcher} */ host = org.apache.royale.utils.Language.as(org.apache.royale.utils.UIUtils.findPopUpHost(org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_controllers_MenuSelectionMouseController__strand, org.apache.royale.core.IUIBase)), org.apache.royale.events.IEventDispatcher);
  host.addEventListener("hideMenus", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_controllers_MenuSelectionMouseController_handleHideMenus, this, 'org_apache_royale_html_beads_controllers_MenuSelectionMouseController_handleHideMenus'));
  
  window.addEventListener('mouseup', org.apache.royale.utils.Language.closure(this.hideMenu_internal, this, 'hideMenu_internal'), false);
};


Object.defineProperties(org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype, /** @lends {org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'MenuSelectionMouseController', qName: 'org.apache.royale.html.beads.controllers.MenuSelectionMouseController', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.controllers.MenuSelectionMouseController'}
      };
    },
    methods: function () {
      return {
        'MenuSelectionMouseController': { type: '', declaredBy: 'org.apache.royale.html.beads.controllers.MenuSelectionMouseController'},
        'removeClickOutHandler': { type: 'void', declaredBy: 'org.apache.royale.html.beads.controllers.MenuSelectionMouseController', parameters: function () { return [ 'Object', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.controllers.MenuSelectionMouseController.prototype.ROYALE_COMPILE_FLAGS = 10;