/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/controllers/CascadingMenuSelectionMouseController.as
 * org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController');

goog.require('org.apache.royale.core.IBeadModel');
goog.require('org.apache.royale.core.IMenu');
goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.ValuesManager');
goog.require('org.apache.royale.events.ItemClickedEvent');
goog.require('org.apache.royale.html.CascadingMenu');
goog.require('org.apache.royale.html.beads.controllers.MenuSelectionMouseController');
goog.require('org.apache.royale.html.beads.models.CascadingMenuModel');
goog.require('org.apache.royale.html.beads.models.MenuModel');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.html.beads.controllers.MenuSelectionMouseController}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController = function() {
  org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController, org.apache.royale.html.beads.controllers.MenuSelectionMouseController);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController', org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController__strand;


/**
 * @asprivate
 * 
 * Replaces the selectedHandler from the super class to handle the presentation of
 * submenus. If an element has the submenu indicator, a new CascadingMenu is presented.
 * If the element is a regular element, then the super class's handler is called.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.6
 * @protected
 * @override
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.selectedHandler = function(event) {
  var /** @type {Object} */ node = event.data;
  var /** @type {org.apache.royale.html.beads.models.CascadingMenuModel} */ model = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController__strand.getBeadByType(org.apache.royale.core.IBeadModel), org.apache.royale.html.beads.models.CascadingMenuModel);
  if (this.getHasMenu(node, model)) {
    var /** @type {Object} */ c = org.apache.royale.core.ValuesManager["valuesImpl"].getValue(this.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController__strand, "iMenu");
    var /** @type {org.apache.royale.core.IUIBase} */ component = org.apache.royale.utils.Language.as(event.target, org.apache.royale.core.IUIBase);
    var /** @type {org.apache.royale.core.IMenu} */ menu = org.apache.royale.utils.Language.as(new c(), org.apache.royale.core.IMenu);
    menu.dataProvider = this.getSubMenuDataProvider(node, model);
    menu.labelField = model.labelField;
    menu.parentMenuBar = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController__strand, org.apache.royale.core.IMenu).parentMenuBar;
    if (model.selectedItem) {
      var /** @type {Object} */ dp = this.getSubMenuDataProvider(model.selectedItem, model);
      if (dp) {
        var /** @type {org.apache.royale.html.CascadingMenu} */ nextMenu = this.getMenuWithDataProvider(org.apache.royale.html.beads.models.MenuModel["menuList"], dp);
        if (nextMenu) {
          this.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController_clearSubmenusOnSameLevel(nextMenu, org.apache.royale.utils.Language.as(nextMenu.model, org.apache.royale.core.ISelectionModel));
        }
      }
    }
    model.selectedItem = event.data;
    menu.show(component, component.width, 0);
  } else {
    org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.superClass_.selectedHandler.apply(this, [ event] );
    this.hideOpenMenus();
  }
};


/**
 * @private
 * @param {org.apache.royale.core.UIBase} menuToBeRemoved
 * @param {org.apache.royale.core.ISelectionModel} model
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController_clearSubmenusOnSameLevel = function(menuToBeRemoved, model) {
  var /** @type {Object} */ selectedItem = model.selectedItem;
  if (!selectedItem) {
    return this.removeMenu(menuToBeRemoved);
  }
  var /** @type {Array} */ menuList = org.apache.royale.html.beads.models.MenuModel["menuList"];
  for (var /** @type {number} */ i = 0; i < menuList.length; i++) {
    var /** @type {org.apache.royale.core.UIBase} */ menu = org.apache.royale.utils.Language.as(menuList[i], org.apache.royale.core.UIBase);
    var /** @type {org.apache.royale.core.ISelectionModel} */ menuModel = org.apache.royale.utils.Language.as(menu.model, org.apache.royale.core.ISelectionModel);
    if (menuModel && menuModel.selectedItem == selectedItem) {
      var /** @type {Object} */ dp = this.getSubMenuDataProvider(selectedItem, org.apache.royale.utils.Language.as(menuModel, org.apache.royale.html.beads.models.CascadingMenuModel));
      if (dp) {
        var /** @type {org.apache.royale.html.CascadingMenu} */ nextMenu = this.getMenuWithDataProvider(menuList, dp);
        if (nextMenu) {
          this.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController_clearSubmenusOnSameLevel(nextMenu, org.apache.royale.utils.Language.as(nextMenu.model, org.apache.royale.core.ISelectionModel));
          break;
        }
      }
    }
  }
  this.removeMenu(menuToBeRemoved);
};


/**
 * @asprivate
 * 
 *  Search for an open menu strand according to the given data provider.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.6
 * @protected
 * @param {Array} menuList
 * @param {Object} dp
 * @return {org.apache.royale.html.CascadingMenu}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.getMenuWithDataProvider = function(menuList, dp) {
  for (var /** @type {number} */ i = 0; i < menuList.length; i++) {
    var /** @type {org.apache.royale.html.CascadingMenu} */ cascadingMenu = org.apache.royale.utils.Language.as(menuList[i], org.apache.royale.html.CascadingMenu);
    if (cascadingMenu && cascadingMenu.dataProvider == dp) {
      return cascadingMenu;
    }
  }
  return null;
};


/**
 * @protected
 * @param {Object} node
 * @param {org.apache.royale.html.beads.models.CascadingMenuModel} model
 * @return {Object}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.getSubMenuDataProvider = function(node, model) {
  return node[model.submenuField];
};


/**
 * @protected
 * @param {Object} node
 * @param {org.apache.royale.html.beads.models.CascadingMenuModel} model
 * @return {boolean}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.getHasMenu = function(node, model) {
  return node.hasOwnProperty(model.submenuField);
};


org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_controllers_CascadingMenuSelectionMouseController__strand = value;
  org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.superClass_.set__strand.apply(this, [ value] );
};


Object.defineProperties(org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype, /** @lends {org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'CascadingMenuSelectionMouseController', qName: 'org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController'}
      };
    },
    methods: function () {
      return {
        'CascadingMenuSelectionMouseController': { type: '', declaredBy: 'org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.controllers.CascadingMenuSelectionMouseController.prototype.ROYALE_COMPILE_FLAGS = 10;