/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/VirtualListView.as
 * org.apache.royale.html.beads.VirtualListView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.VirtualListView');

goog.require('org.apache.royale.core.IDataProviderItemRendererMapper');
goog.require('org.apache.royale.core.IIndexedItemRenderer');
goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.IRollOverModel');
goog.require('org.apache.royale.core.ISelectableItemRenderer');
goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.ItemRendererEvent');
goog.require('org.apache.royale.html.beads.VirtualDataContainerView');
goog.require('org.apache.royale.utils.getSelectionRenderBead');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.html.beads.VirtualDataContainerView}
 */
org.apache.royale.html.beads.VirtualListView = function() {
  org.apache.royale.html.beads.VirtualListView.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.VirtualListView, org.apache.royale.html.beads.VirtualDataContainerView);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.VirtualListView', org.apache.royale.html.beads.VirtualListView);


/**
 * @protected
 * @type {org.apache.royale.core.ISelectionModel}
 */
org.apache.royale.html.beads.VirtualListView.prototype.listModel;


/**
 * @protected
 * @type {number}
 */
org.apache.royale.html.beads.VirtualListView.prototype.lastSelectedIndex = -1;


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.royale.html.beads.VirtualListView.prototype.handleInitComplete = function(event) {
  this.listModel = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.core.ISelectionModel), org.apache.royale.core.ISelectionModel);
  this.listModel.addEventListener("selectedIndexChanged", org.apache.royale.utils.Language.closure(this.selectionChangeHandler, this, 'selectionChangeHandler'));
  this.listModel.addEventListener("rollOverIndexChanged", org.apache.royale.utils.Language.closure(this.rollOverIndexChangeHandler, this, 'rollOverIndexChangeHandler'));
  var /** @type {org.apache.royale.events.IEventDispatcher} */ mapper = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.core.IDataProviderItemRendererMapper), org.apache.royale.events.IEventDispatcher);
  mapper.addEventListener(org.apache.royale.events.ItemRendererEvent.CREATED, org.apache.royale.utils.Language.closure(this.itemCreatedHandler, this, 'itemCreatedHandler'));
  org.apache.royale.html.beads.VirtualListView.superClass_.handleInitComplete.apply(this, [ event] );
};


/**
 * @protected
 * @param {org.apache.royale.events.ItemRendererEvent} event
 */
org.apache.royale.html.beads.VirtualListView.prototype.itemCreatedHandler = function(event) {
  var /** @type {org.apache.royale.core.ISelectableItemRenderer} */ selectionBead;
  var /** @type {org.apache.royale.core.IIndexedItemRenderer} */ ir = org.apache.royale.utils.Language.as(event.itemRenderer, org.apache.royale.core.IIndexedItemRenderer);
  if (ir.index == this.lastSelectedIndex) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.selected = true;
  }
};


/**
 * @protected
 * @type {number}
 */
org.apache.royale.html.beads.VirtualListView.prototype.firstElementIndex = 1;


/**
 * @export
 * @override
 */
org.apache.royale.html.beads.VirtualListView.prototype.getItemRendererForIndex = function(index) {
  if (this.contentView.numElements == 0)
    return null;
  var /** @type {number} */ firstIndex = org.apache.royale.utils.Language.as(this.contentView.getElementAt(this.firstElementIndex), org.apache.royale.core.IIndexedItemRenderer).index;
  if (index < firstIndex)
    return null;
  if (index >= (firstIndex + this.contentView.numElements))
    return null;
  return org.apache.royale.utils.Language.as(this.contentView.getElementAt((index - firstIndex + this.firstElementIndex) >> 0), org.apache.royale.core.IItemRenderer);
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IIndexedItemRenderer
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.VirtualListView.prototype.selectionChangeHandler = function(event) {
  var /** @type {org.apache.royale.core.ISelectableItemRenderer} */ selectionBead;
  var /** @type {Object} */ ir = this.dataGroup.getItemRendererForIndex(this.lastSelectedIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.selected = false;
  }
  ir = this.dataGroup.getItemRendererForIndex(this.listModel.selectedIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.selected = true;
  }
  this.lastSelectedIndex = this.listModel.selectedIndex;
};


/**
 * @protected
 * @type {number}
 */
org.apache.royale.html.beads.VirtualListView.prototype.lastRollOverIndex = -1;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IIndexedItemRenderer
 * * @royaleignorecoercion org.apache.royale.core.IRollOverModel
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.VirtualListView.prototype.rollOverIndexChangeHandler = function(event) {
  var /** @type {org.apache.royale.core.ISelectableItemRenderer} */ selectionBead;
  var /** @type {Object} */ ir = this.dataGroup.getItemRendererForIndex(this.lastRollOverIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.hovered = false;
  }
  ir = this.dataGroup.getItemRendererForIndex(this.listModel.rollOverIndex);
  if (ir) {
    selectionBead = org.apache.royale.utils.getSelectionRenderBead(ir);
    if (selectionBead)
      selectionBead.hovered = true;
  }
  this.lastRollOverIndex = this.listModel.rollOverIndex;
};


/**
 * @protected
 * @override
 */
org.apache.royale.html.beads.VirtualListView.prototype.dataProviderChangeHandler = function(event) {
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.VirtualListView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'VirtualListView', qName: 'org.apache.royale.html.beads.VirtualListView', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.VirtualListView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    methods: function () {
      return {
        'VirtualListView': { type: '', declaredBy: 'org.apache.royale.html.beads.VirtualListView'},
        'getItemRendererForIndex': { type: 'org.apache.royale.core.IItemRenderer', declaredBy: 'org.apache.royale.html.beads.VirtualListView', parameters: function () { return [ 'int', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.VirtualListView.prototype.ROYALE_COMPILE_FLAGS = 10;