/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/DataGridView.as
 * org.apache.royale.html.beads.DataGridView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.DataGridView');

goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.core.IBeadModel');
goog.require('org.apache.royale.core.IChild');
goog.require('org.apache.royale.core.IDataGrid');
goog.require('org.apache.royale.core.IDataGridModel');
goog.require('org.apache.royale.core.IDataGridPresentationModel');
goog.require('org.apache.royale.core.ILayoutChild');
goog.require('org.apache.royale.core.IParent');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.ValuesManager');
goog.require('org.apache.royale.debugging.assert');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.html.DataGridButtonBar');
goog.require('org.apache.royale.html.beads.GroupView');
goog.require('org.apache.royale.html.supportClasses.IDataGridColumn');
goog.require('org.apache.royale.html.supportClasses.IDataGridColumnList');
goog.require('org.apache.royale.html.supportClasses.Viewport');
goog.require('org.apache.royale.utils.sendEvent');
goog.require('org.apache.royale.utils.sendStrandEvent');
goog.require('org.apache.royale.core.IBeadView');
goog.require('org.apache.royale.html.beads.IDataGridView');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.html.beads.GroupView}
 * @implements {org.apache.royale.core.IBeadView}
 * @implements {org.apache.royale.html.beads.IDataGridView}
 */
org.apache.royale.html.beads.DataGridView = function() {
  org.apache.royale.html.beads.DataGridView.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.DataGridView, org.apache.royale.html.beads.GroupView);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.DataGridView', org.apache.royale.html.beads.DataGridView);


/**
 * @private
 * @type {org.apache.royale.html.DataGridButtonBar}
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView__header;


/**
 * @private
 * @type {org.apache.royale.core.IUIBase}
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView__listArea;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView__lists;


/**
 * @export
 */
org.apache.royale.html.beads.DataGridView.prototype.refreshContent = function() {
  this.handleInitComplete(null);
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView_sawInitComplete;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @royaleignorecoercion org.apache.royale.core.IBead
 * @royaleignorecoercion org.apache.royale.core.IBeadModel
 * @royaleignorecoercion org.apache.royale.core.IChild
 * @royaleignorecoercion org.apache.royale.core.ILayoutChild
 * @royaleignorecoercion org.apache.royale.core.IUIBase
 * @royaleignorecoercion org.apache.royale.html.DataGrid
 * @protected
 * @override
 */
org.apache.royale.html.beads.DataGridView.prototype.handleInitComplete = function(event) {
  this.org_apache_royale_html_beads_DataGridView_sawInitComplete = event != null;
  var /** @type {org.apache.royale.core.IDataGrid} */ host = org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IDataGrid);
  var /** @type {Object} */ sharedModel = host.model;
  sharedModel.addEventListener("dataProviderChanged", org.apache.royale.utils.Language.closure(this.handleDataProviderChanged, this, 'handleDataProviderChanged'));
  sharedModel.addEventListener("selectedIndexChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridView_handleSelectedIndexChanged, this, 'org_apache_royale_html_beads_DataGridView_handleSelectedIndexChanged'));
  var /** @type {Object} */ columnContainerClass = org.apache.royale.utils.Language.as(org.apache.royale.core.ValuesManager["valuesImpl"].getValue(host, "columnContainerClass"), org.apache.royale.utils.Language.synthType('Class'));
  org.apache.royale.debugging.assert(columnContainerClass != null, "columnContainerClass for DataGrid must be set!");
  this.org_apache_royale_html_beads_DataGridView__header = org.apache.royale.utils.Language.as(new columnContainerClass(), org.apache.royale.html.DataGridButtonBar);
  this.org_apache_royale_html_beads_DataGridView__header.percentWidth = 100;
  this.org_apache_royale_html_beads_DataGridView__header.dataProvider = sharedModel.columns;
  this.org_apache_royale_html_beads_DataGridView__header.labelField = "label";
  sharedModel.headerModel = this.org_apache_royale_html_beads_DataGridView__header.model;
  var /** @type {Object} */ listAreaClass = org.apache.royale.utils.Language.as(org.apache.royale.core.ValuesManager["valuesImpl"].getValue(host, "listAreaClass"), org.apache.royale.utils.Language.synthType('Class'));
  org.apache.royale.debugging.assert(listAreaClass != null, "listAreaClass for DataGrid must be set!");
  this.org_apache_royale_html_beads_DataGridView__listArea = new listAreaClass();
  this.org_apache_royale_html_beads_DataGridView__listArea.percentWidth = 100;
  if (sharedModel.columns)
    this.createLists();
  var /** @type {Object} */ columnLayoutClass = org.apache.royale.utils.Language.as(org.apache.royale.core.ValuesManager["valuesImpl"].getValue(host, "columnLayoutClass"), org.apache.royale.utils.Language.synthType('Class'));
  org.apache.royale.debugging.assert(columnLayoutClass != null, "columnLayoutClass for DataGrid must be set!");
  var /** @type {Object} */ bblayout = new columnLayoutClass();
  this.org_apache_royale_html_beads_DataGridView__header.addBead(bblayout);
  this.org_apache_royale_html_beads_DataGridView__header.addBead(new org.apache.royale.html.supportClasses.Viewport());
  host.strandChildren.addElement(this.org_apache_royale_html_beads_DataGridView__header);
  host.strandChildren.addElement(this.org_apache_royale_html_beads_DataGridView__listArea);
  this.handleDataProviderChanged(event);
  org.apache.royale.utils.sendStrandEvent(this._strand, "dataGridViewCreated");
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView_sawSizeChanged;


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView_handleSizeChanges = function(event) {
  this.org_apache_royale_html_beads_DataGridView_sawSizeChanged = true;
  if (this.org_apache_royale_html_beads_DataGridView__header)
    org.apache.royale.utils.sendEvent(this.org_apache_royale_html_beads_DataGridView__header, "layoutChanged");
  if (this.org_apache_royale_html_beads_DataGridView__listArea)
    org.apache.royale.utils.sendEvent(this.org_apache_royale_html_beads_DataGridView__listArea, "layoutChanged");
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataGridView.prototype.handleDataProviderChanged = function(event) {
  var /** @type {org.apache.royale.core.IDataGridModel} */ sharedModel = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.core.IBeadModel), org.apache.royale.core.IDataGridModel);
  for (var /** @type {number} */ i = 0; i < this.org_apache_royale_html_beads_DataGridView__lists.length; i++) {
    var /** @type {org.apache.royale.html.supportClasses.IDataGridColumnList} */ list = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridView__lists[i], org.apache.royale.html.supportClasses.IDataGridColumnList);
    list.dataProvider = sharedModel.dataProvider;
  }
  org.apache.royale.utils.sendStrandEvent(this._strand, "layoutNeeded");
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @royaleignorecoercion org.apache.royale.html.supportClasses.IDataGridColumnList
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView_handleSelectedIndexChanged = function(event) {
  var /** @type {Object} */ sharedModel = this._strand.getBeadByType(org.apache.royale.core.IBeadModel);
  var /** @type {number} */ newIndex = sharedModel.selectedIndex;
  for (var /** @type {number} */ i = 0; i < this.org_apache_royale_html_beads_DataGridView__lists.length; i++) {
    var /** @type {Object} */ list = this.org_apache_royale_html_beads_DataGridView__lists[i];
    list.selectedIndex = newIndex;
  }
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @royaleignorecoercion org.apache.royale.html.supportClasses.IDataGridColumnList
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataGridView.prototype.org_apache_royale_html_beads_DataGridView_handleColumnListChange = function(event) {
  var /** @type {Object} */ sharedModel = this._strand.getBeadByType(org.apache.royale.core.IBeadModel);
  var /** @type {Object} */ list = event.target;
  sharedModel.selectedIndex = list.selectedIndex;
  for (var /** @type {number} */ i = 0; i < this.org_apache_royale_html_beads_DataGridView__lists.length; i++) {
    if (list != this.org_apache_royale_html_beads_DataGridView__lists[i]) {
      var /** @type {Object} */ otherList = this.org_apache_royale_html_beads_DataGridView__lists[i];
      otherList.selectedIndex = list.selectedIndex;
    }
  }
  org.apache.royale.utils.sendStrandEvent(this._strand, 'change');
};


/**
 * @asprivate
 * @royaleignorecoercion String
 * @royaleignorecoercion Class
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @royaleignorecoercion org.apache.royale.core.IBead
 * @royaleignorecoercion org.apache.royale.core.IChild
 * @royaleignorecoercion org.apache.royale.core.IParent
 * @royaleignorecoercion org.apache.royale.core.IDataGrid
 * @royaleignorecoercion org.apache.royale.core.IDataGridPresentationModel
 * @royaleignorecoercion org.apache.royale.html.supportClasses.IDataGridColumn
 * @protected
 */
org.apache.royale.html.beads.DataGridView.prototype.createLists = function() {
  var /** @type {Object} */ host = this._strand;
  var /** @type {Object} */ columnClass =  /** @type {Object|null} */ (org.apache.royale.core.ValuesManager["valuesImpl"].getValue(host, "columnClass"));
  org.apache.royale.debugging.assert(columnClass != null, "ColumnClass for DataGrid must be set!");
  var /** @type {Object} */ sharedModel = host.model;
  var /** @type {Object} */ presentationModel = host.presentationModel;
  this.org_apache_royale_html_beads_DataGridView__lists = [];
  for (var /** @type {number} */ i = 0; i < sharedModel.columns.length; i++) {
    var /** @type {Object} */ dataGridColumn = sharedModel.columns[i];
    var /** @type {org.apache.royale.html.supportClasses.IDataGridColumnList} */ list = new columnClass();
    if (i == 0) {
      list.className = "first";
    } else if (i == sharedModel.columns.length - 1) {
      list.className = "last";
    } else {
      list.className = "middle";
    }
    list.id = "dataGridColumn" + i;
    list.dataProvider = sharedModel.dataProvider;
    list.itemRenderer = dataGridColumn.itemRenderer;
    list.labelField = dataGridColumn.dataField;
    list.addEventListener('change', org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridView_handleColumnListChange, this, 'org_apache_royale_html_beads_DataGridView_handleColumnListChange'));
    list.addBead(presentationModel);
    this.org_apache_royale_html_beads_DataGridView__listArea.addElement(list);
    this.org_apache_royale_html_beads_DataGridView__lists.push(list);
  }
  org.apache.royale.utils.sendStrandEvent(this._strand, "layoutNeeded");
};


/**
 * Provides a place for pre-layout actions.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @export
 * @override
 */
org.apache.royale.html.beads.DataGridView.prototype.beforeLayout = function() {
  var /** @type {org.apache.royale.core.ILayoutChild} */ host = org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.ILayoutChild);
  if (host.isWidthSizedToContent() && host.isHeightSizedToContent())
    return this.org_apache_royale_html_beads_DataGridView_sawInitComplete;
  return this.org_apache_royale_html_beads_DataGridView_sawSizeChanged;
};


org.apache.royale.html.beads.DataGridView.prototype.set__strand = function(value) {
  org.apache.royale.html.beads.DataGridView.superClass_.set__strand.apply(this, [ value] );
  this.host.addEventListener("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridView_handleSizeChanges, this, 'org_apache_royale_html_beads_DataGridView_handleSizeChanges'));
  this.host.addEventListener("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridView_handleSizeChanges, this, 'org_apache_royale_html_beads_DataGridView_handleSizeChanges'));
  this.host.addEventListener("sizeChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridView_handleSizeChanges, this, 'org_apache_royale_html_beads_DataGridView_handleSizeChanges'));
};


org.apache.royale.html.beads.DataGridView.prototype.get__columnLists = function() {
  return this.org_apache_royale_html_beads_DataGridView__lists;
};


org.apache.royale.html.beads.DataGridView.prototype.get__listArea = function() {
  return this.org_apache_royale_html_beads_DataGridView__listArea;
};


org.apache.royale.html.beads.DataGridView.prototype.get__header = function() {
  return this.org_apache_royale_html_beads_DataGridView__header;
};


Object.defineProperties(org.apache.royale.html.beads.DataGridView.prototype, /** @lends {org.apache.royale.html.beads.DataGridView.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.DataGridView.prototype.set__strand},
/**
  * @export
  * @type {Array} */
columnLists: {
get: org.apache.royale.html.beads.DataGridView.prototype.get__columnLists},
/**
  * @export
  * @type {org.apache.royale.core.IUIBase} */
listArea: {
get: org.apache.royale.html.beads.DataGridView.prototype.get__listArea},
/**
  * @export
  * @type {org.apache.royale.core.IUIBase} */
header: {
get: org.apache.royale.html.beads.DataGridView.prototype.get__header}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.DataGridView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DataGridView', qName: 'org.apache.royale.html.beads.DataGridView', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadView, org.apache.royale.html.beads.IDataGridView] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.DataGridView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.DataGridView'},
        'columnLists': { type: 'Array', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.DataGridView'},
        'listArea': { type: 'org.apache.royale.core.IUIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.DataGridView'},
        'header': { type: 'org.apache.royale.core.IUIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.DataGridView'}
      };
    },
    methods: function () {
      return {
        'DataGridView': { type: '', declaredBy: 'org.apache.royale.html.beads.DataGridView'},
        'refreshContent': { type: 'void', declaredBy: 'org.apache.royale.html.beads.DataGridView'},
        'beforeLayout': { type: 'Boolean', declaredBy: 'org.apache.royale.html.beads.DataGridView'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.DataGridView.prototype.ROYALE_COMPILE_FLAGS = 10;