/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/accessories/AdaptiveToolTipBead.as
 * org.apache.royale.html.accessories.AdaptiveToolTipBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.accessories.AdaptiveToolTipBead');

goog.require('org.apache.royale.core.IParentIUIBase');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.MouseEvent');
goog.require('org.apache.royale.geom.Point');
goog.require('org.apache.royale.html.ToolTip');
goog.require('org.apache.royale.html.accessories.ToolTipBead');
goog.require('org.apache.royale.utils.PointUtils');
goog.require('org.apache.royale.utils.UIUtils');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.html.accessories.ToolTipBead}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead = function() {
  org.apache.royale.html.accessories.AdaptiveToolTipBead.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.accessories.AdaptiveToolTipBead, org.apache.royale.html.accessories.ToolTipBead);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.accessories.AdaptiveToolTipBead', org.apache.royale.html.accessories.AdaptiveToolTipBead);


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.TOP = 10000;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.BOTTOM = 10001;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.LEFT = 10002;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.RIGHT = 10003;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.MIDDLE = 10004;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IUIBase
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @override
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.prototype.rollOverHandler = function(event) {
  if (!this.toolTip || this.tt)
    return;
  this._strand.addEventListener(org.apache.royale.events.MouseEvent.MOUSE_OUT, org.apache.royale.utils.Language.closure(this.rollOutHandler, this, 'rollOutHandler'), false);
  var /** @type {Object} */ comp = this._strand;
  this.host = org.apache.royale.utils.UIUtils.findPopUpHost(comp);
  if (this.tt)
    this.host.popUpParent.removeElement(this.tt);
  this.tt = new org.apache.royale.html.ToolTip();
  this.tt.text = this.toolTip;
  this.host.popUpParent.addElement(this.tt, false);
  var /** @type {org.apache.royale.geom.Point} */ pt = this.determinePosition(event, event.target);
  this.tt.x = pt.x;
  this.tt.y = pt.y;
};


/**
 * @asprivate
 * Determines the position of the toolTip.
 * @royaleignorecoercion org.apache.royale.core.IUIBase
 * @protected
 * @override
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.prototype.determinePosition = function(event, base) {
  var /** @type {number} */ ttWidth = this.tt.width;
  var /** @type {number} */ ttHeight = this.tt.height;
  var /** @type {Object} */ comp = this._strand;
  var /** @type {number} */ x;
  var /** @type {number} */ y;
  switch (this.xPos) {
    case org.apache.royale.html.accessories.AdaptiveToolTipBead.LEFT:
      x = -ttWidth;
      break;
    case org.apache.royale.html.accessories.AdaptiveToolTipBead.MIDDLE:
      x = (comp.width - ttWidth) / 2;
      break;
    case org.apache.royale.html.accessories.AdaptiveToolTipBead.RIGHT:
      x = comp.width;
      break;
  }
  switch (this.yPos) {
    case org.apache.royale.html.accessories.AdaptiveToolTipBead.TOP:
      y = -ttHeight;
      break;
    case org.apache.royale.html.accessories.AdaptiveToolTipBead.MIDDLE:
      y = (comp.height - ttHeight) / 2;
      break;
    case org.apache.royale.html.accessories.AdaptiveToolTipBead.BOTTOM:
      y = comp.height;
      break;
  }
  var /** @type {org.apache.royale.geom.Point} */ pt = new org.apache.royale.geom.Point(x, y);
  pt = org.apache.royale.utils.PointUtils.localToGlobal(pt, comp);
  pt.x = Math.max(pt.x, 0);
  pt.y = Math.max(pt.y, 0);
  var /** @type {number} */ screenHeight = org.apache.royale.utils.Language.as(this.host.popUpParent, org.apache.royale.core.IParentIUIBase).height;
  var /** @type {number} */ extraHeight = 1 + pt.y + ttHeight - screenHeight;
  if (extraHeight > 0) {
    pt.y -= extraHeight;
  }
  var /** @type {number} */ screenWidth = org.apache.royale.utils.Language.as(this.host.popUpParent, org.apache.royale.core.IParentIUIBase).width;
  var /** @type {number} */ extraWidth = 1 + pt.x + ttWidth - screenWidth;
  if (extraWidth > 0) {
    pt.x -= extraWidth;
  }
  return pt;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'AdaptiveToolTipBead', qName: 'org.apache.royale.html.accessories.AdaptiveToolTipBead', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    methods: function () {
      return {
        'AdaptiveToolTipBead': { type: '', declaredBy: 'org.apache.royale.html.accessories.AdaptiveToolTipBead'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.accessories.AdaptiveToolTipBead.prototype.ROYALE_COMPILE_FLAGS = 10;