/**
 * Generated by Apache Royale Compiler from org\apache\royale\html\beads\layouts\HorizontalSliderLayout.as
 * org.apache.royale.html.beads.layouts.HorizontalSliderLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.layouts.HorizontalSliderLayout');

goog.require('org.apache.royale.core.IRangeModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.html.beads.ISliderView');
goog.require('org.apache.royale.core.IBeadLayout');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @implements {org.apache.royale.core.IBeadLayout}
 */
org.apache.royale.html.beads.layouts.HorizontalSliderLayout = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.layouts.HorizontalSliderLayout', org.apache.royale.html.beads.layouts.HorizontalSliderLayout);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.org_apache_royale_html_beads_layouts_HorizontalSliderLayout__strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.org_apache_royale_html_beads_layouts_HorizontalSliderLayout_performLayout = function(event) {
  this.layout();
};


/**
 * Performs the layout (size and positioning) of the elements of the slider.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @export
 * @return {boolean}
 */
org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.layout = function() {
  var /** @type {org.apache.royale.html.beads.ISliderView} */ viewBead = org.apache.royale.utils.Language.as(this.host.view, org.apache.royale.html.beads.ISliderView);
  if (viewBead == null) {
    return false;
  }
  var /** @type {number} */ useWidth = this.host.width;
  if (isNaN(useWidth)) {
    useWidth = 100;
  }
  var /** @type {number} */ useHeight = this.host.height;
  if (isNaN(useHeight)) {
    useHeight = 25;
  }
  var /** @type {number} */ square = Math.min(useWidth, useHeight);
  var /** @type {number} */ trackHeight = useHeight / 3;
  var /** @type {org.apache.royale.core.IUIBase} */ thumb = org.apache.royale.utils.Language.as(viewBead.thumb, org.apache.royale.core.IUIBase);
  thumb.width = square;
  thumb.height = square;
  var /** @type {org.apache.royale.core.IUIBase} */ track = org.apache.royale.utils.Language.as(viewBead.track, org.apache.royale.core.IUIBase);
  track.x = square / 2;
  track.y = trackHeight;
  track.width = useWidth - square;
  track.height = trackHeight;
  var /** @type {org.apache.royale.core.IRangeModel} */ model = org.apache.royale.utils.Language.as(this.host.model, org.apache.royale.core.IRangeModel);
  var /** @type {number} */ value = model.value;
  if (value < model.minimum)
    value = model.minimum;
  if (value > model.maximum)
    value = model.maximum;
  var /** @type {number} */ p = (value - model.minimum) / (model.maximum - model.minimum);
  var /** @type {number} */ xloc = p * (useWidth - square);
  thumb.x = xloc;
  thumb.y = 0;
  return true;
};


org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_layouts_HorizontalSliderLayout__strand = value;
  this.host.addEventListener("layoutNeeded", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_HorizontalSliderLayout_performLayout, this, 'performLayout'));
  this.host.addEventListener("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_HorizontalSliderLayout_performLayout, this, 'performLayout'));
  this.host.addEventListener("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_HorizontalSliderLayout_performLayout, this, 'performLayout'));
};


org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.get__host = function() {
  return org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_HorizontalSliderLayout__strand, org.apache.royale.core.UIBase);
};


Object.defineProperties(org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype, /** @lends {org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.set__strand},
/**
  * @export
  * @type {org.apache.royale.core.UIBase} */
host: {
get: org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.get__host}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'HorizontalSliderLayout', qName: 'org.apache.royale.html.beads.layouts.HorizontalSliderLayout', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadLayout] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.layouts.HorizontalSliderLayout.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.layouts.HorizontalSliderLayout'},
        'host': { type: 'org.apache.royale.core.UIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.layouts.HorizontalSliderLayout'}
      };
    },
    methods: function () {
      return {
        'HorizontalSliderLayout': { type: '', declaredBy: 'org.apache.royale.html.beads.layouts.HorizontalSliderLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.royale.html.beads.layouts.HorizontalSliderLayout'}
      };
    }
  };
};