/**
 * Generated by Apache Royale Compiler from org\apache\royale\html\beads\DataGridLinesBead.as
 * org.apache.royale.html.beads.DataGridLinesBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.DataGridLinesBead');

goog.require('org.apache.royale.collections.ArrayList');
goog.require('org.apache.royale.core.IBeadModel');
goog.require('org.apache.royale.core.IDataGridModel');
goog.require('org.apache.royale.core.ILayoutHost');
goog.require('org.apache.royale.core.IParentIUIBase');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.graphics.IStroke');
goog.require('org.apache.royale.graphics.SolidColor');
goog.require('org.apache.royale.graphics.SolidColorStroke');
goog.require('org.apache.royale.html.beads.models.DataGridPresentationModel');
goog.require('org.apache.royale.html.supportClasses.DataGridColumn');
goog.require('org.apache.royale.svg.CompoundGraphic');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.html.beads.DataGridLinesBead = function() {
  var /** @type {org.apache.royale.graphics.SolidColorStroke} */ lineStroke = new org.apache.royale.graphics.SolidColorStroke();
  lineStroke.color = 0x333333;
  lineStroke.alpha = 1.0;
  lineStroke.weight = 1;
  this.stroke = lineStroke;
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.DataGridLinesBead', org.apache.royale.html.beads.DataGridLinesBead);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.org_apache_royale_html_beads_DataGridLinesBead__strand;


/**
 * @private
 * @type {org.apache.royale.graphics.IStroke}
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.org_apache_royale_html_beads_DataGridLinesBead__stroke;


/**
 * @private
 * @type {org.apache.royale.svg.CompoundGraphic}
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.org_apache_royale_html_beads_DataGridLinesBead__overlay;


/**
 * @private
 * @type {org.apache.royale.core.UIBase}
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.org_apache_royale_html_beads_DataGridLinesBead__area;


/**
 * Invoked when all of the beads have been added to the DataGrid. This
 * function seeks the Container that parents the lists that are the DataGrid's
 * columns. An overlay GraphicContainer is added to this Container so that the
 * grid lines will scroll with the rows.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.org_apache_royale_html_beads_DataGridLinesBead_handleBeadsAdded = function(event) {
  var /** @type {org.apache.royale.core.UIBase} */ host = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand, org.apache.royale.core.UIBase);
  var /** @type {number} */ n = host.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.royale.core.UIBase} */ child = org.apache.royale.utils.Language.as(host.getElementAt(i), org.apache.royale.core.UIBase);
    if (child.id == "dataGridListArea") {
      this.org_apache_royale_html_beads_DataGridLinesBead__area = child;
      this.org_apache_royale_html_beads_DataGridLinesBead__area.addElement(this.org_apache_royale_html_beads_DataGridLinesBead__overlay);
      break;
    }
  }
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand, org.apache.royale.events.IEventDispatcher, true).addEventListener("sizeChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridLinesBead_drawLines, this, 'drawLines'));
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand, org.apache.royale.events.IEventDispatcher, true).addEventListener("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridLinesBead_drawLines, this, 'drawLines'));
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand, org.apache.royale.events.IEventDispatcher, true).addEventListener("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridLinesBead_drawLines, this, 'drawLines'));
  var /** @type {org.apache.royale.core.IBeadModel} */ model = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand.getBeadByType(org.apache.royale.core.IBeadModel), org.apache.royale.core.IBeadModel);
  org.apache.royale.utils.Language.as(model, org.apache.royale.events.IEventDispatcher, true).addEventListener("dataProviderChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridLinesBead_drawLines, this, 'drawLines'));
};


/**
 * This event handler is invoked whenever something happens to the DataGrid. This
 * function draws the lines either using a default stroke or the one specified by
 * the stroke property.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.org_apache_royale_html_beads_DataGridLinesBead_drawLines = function(event) {
  var /** @type {org.apache.royale.core.IDataGridModel} */ sharedModel = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand.getBeadByType(org.apache.royale.core.IBeadModel), org.apache.royale.core.IDataGridModel);
  var /** @type {org.apache.royale.html.beads.models.DataGridPresentationModel} */ presentationModel = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand.getBeadByType(org.apache.royale.html.beads.models.DataGridPresentationModel), org.apache.royale.html.beads.models.DataGridPresentationModel);
  var /** @type {org.apache.royale.core.ILayoutHost} */ layoutParent = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__area.getBeadByType(org.apache.royale.core.ILayoutHost), org.apache.royale.core.ILayoutHost);
  var /** @type {org.apache.royale.core.IParentIUIBase} */ contentView = org.apache.royale.utils.Language.as(layoutParent.contentView, org.apache.royale.core.IParentIUIBase);
  var /** @type {Array} */ columns = sharedModel.columns;
  var /** @type {org.apache.royale.collections.ArrayList} */ arrayList = org.apache.royale.utils.Language.as(sharedModel.dataProvider, org.apache.royale.collections.ArrayList);
  var /** @type {number} */ rowHeight = presentationModel.rowHeight;
  var /** @type {number} */ totalHeight = arrayList.length * rowHeight;
  var /** @type {number} */ columnWidth = this.org_apache_royale_html_beads_DataGridLinesBead__area.width / columns.length;
  var /** @type {org.apache.royale.graphics.SolidColor} */ lineFill = new org.apache.royale.graphics.SolidColor();
  var /** @type {number} */ weight = 1;
  lineFill.color = org.apache.royale.utils.Language.as(this.stroke, org.apache.royale.graphics.SolidColorStroke).color;
  lineFill.alpha = org.apache.royale.utils.Language.as(this.stroke, org.apache.royale.graphics.SolidColorStroke).alpha;
  weight = org.apache.royale.utils.Language.as(this.stroke, org.apache.royale.graphics.SolidColorStroke).weight;
  this.org_apache_royale_html_beads_DataGridLinesBead__overlay.fill = lineFill;
  columnWidth = org.apache.royale.utils.Language.as(columns[0], org.apache.royale.html.supportClasses.DataGridColumn).columnWidth;
  var /** @type {number} */ xpos = isNaN(columnWidth) ? this.org_apache_royale_html_beads_DataGridLinesBead__area.width / columns.length : columnWidth;
  this.org_apache_royale_html_beads_DataGridLinesBead__overlay.clear();
  for (var /** @type {number} */ i = 1; i < columns.length; i++) {
    this.org_apache_royale_html_beads_DataGridLinesBead__overlay.drawRect(xpos, 0, weight, totalHeight);
    columnWidth = org.apache.royale.utils.Language.as(columns[i], org.apache.royale.html.supportClasses.DataGridColumn).columnWidth;
    xpos += isNaN(columnWidth) ? this.org_apache_royale_html_beads_DataGridLinesBead__area.width / columns.length : columnWidth;
  }
  var /** @type {number} */ n = arrayList.length;
  for (i = 1; i < n + 1; i++) {
    this.org_apache_royale_html_beads_DataGridLinesBead__overlay.drawRect(0, i * rowHeight, this.org_apache_royale_html_beads_DataGridLinesBead__area.width, weight);
  }
};


org.apache.royale.html.beads.DataGridLinesBead.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_DataGridLinesBead__strand = value;
  this.org_apache_royale_html_beads_DataGridLinesBead__overlay = new org.apache.royale.svg.CompoundGraphic();
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_DataGridLinesBead__strand, org.apache.royale.events.IEventDispatcher, true).addEventListener("beadsAdded", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_DataGridLinesBead_handleBeadsAdded, this, 'handleBeadsAdded'));
};


org.apache.royale.html.beads.DataGridLinesBead.prototype.get__stroke = function() {
  return this.org_apache_royale_html_beads_DataGridLinesBead__stroke;
};


org.apache.royale.html.beads.DataGridLinesBead.prototype.set__stroke = function(value) {
  this.org_apache_royale_html_beads_DataGridLinesBead__stroke = value;
};


Object.defineProperties(org.apache.royale.html.beads.DataGridLinesBead.prototype, /** @lends {org.apache.royale.html.beads.DataGridLinesBead.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.DataGridLinesBead.prototype.set__strand},
/**
  * @export
  * @type {org.apache.royale.graphics.IStroke} */
stroke: {
get: org.apache.royale.html.beads.DataGridLinesBead.prototype.get__stroke,
set: org.apache.royale.html.beads.DataGridLinesBead.prototype.set__stroke}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DataGridLinesBead', qName: 'org.apache.royale.html.beads.DataGridLinesBead', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.DataGridLinesBead.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.DataGridLinesBead'},
        'stroke': { type: 'org.apache.royale.graphics.IStroke', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.DataGridLinesBead'}
      };
    },
    methods: function () {
      return {
        'DataGridLinesBead': { type: '', declaredBy: 'org.apache.royale.html.beads.DataGridLinesBead'}
      };
    }
  };
};