/**
 * Generated by Apache Royale Compiler from org\apache\royale\html\Alert.as
 * org.apache.royale.html.Alert
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.Alert');

goog.require('org.apache.royale.core.IAlertModel');
goog.require('org.apache.royale.html.Group');
goog.require('org.apache.royale.core.IPopUp');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.html.Group}
 * @implements {org.apache.royale.core.IPopUp}
 */
org.apache.royale.html.Alert = function() {
  org.apache.royale.html.Alert.base(this, 'constructor');
  this.typeNames = "Alert";
};
goog.inherits(org.apache.royale.html.Alert, org.apache.royale.html.Group);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.Alert', org.apache.royale.html.Alert);


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.royale.html.Alert.YES = 0x000001;


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.royale.html.Alert.NO = 0x000002;


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.royale.html.Alert.OK = 0x000004;


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.royale.html.Alert.CANCEL = 0x000008;


/**
 *  This static method is a convenience function to quickly create and display an Alert. The
 *  text and parent paramters are required, the others will default.
 *
 *  @asparam String message The message content of the Alert.
 *  @asparam Object parent The object that hosts the pop-up.
 *  @asparam String title An optional title for the Alert.
 *  @asparam uint flags Identifies which buttons to display in the alert.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {string} message
 * @param {Object} parent
 * @param {string=} title
 * @param {number=} flags
 * @return {org.apache.royale.html.Alert}
 */
org.apache.royale.html.Alert.show = function(message, parent, title, flags) {
  title = typeof title !== 'undefined' ? title : "";
  flags = typeof flags !== 'undefined' ? flags : org.apache.royale.html.Alert.OK;
  var /** @type {org.apache.royale.html.Alert} */ alert = new org.apache.royale.html.Alert();
  alert.message = message;
  alert.title = title;
  alert.flags = flags;
  alert.show(parent);
  alert.positioner.style.margin = 'auto';
  alert.positioner.style.left = "50%";
  alert.positioner.style.top = "50%";
  alert.positioner.style.width = "200px";
  return alert;
};


/**
 *  Shows the Alert anchored to the given parent object which is usally a root component such
 *  as a UIView..
 * 
 *  @asparam Object parent The object that hosts the pop-up.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} parent
 */
org.apache.royale.html.Alert.prototype.show = function(parent) {
  parent.addElement(this);
};


org.apache.royale.html.Alert.prototype.get__title = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).title;
};


org.apache.royale.html.Alert.prototype.set__title = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).title = value;
};


org.apache.royale.html.Alert.prototype.get__message = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).message;
};


org.apache.royale.html.Alert.prototype.set__message = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).message = value;
};


org.apache.royale.html.Alert.prototype.get__flags = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).flags;
};


org.apache.royale.html.Alert.prototype.set__flags = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).flags = value;
};


Object.defineProperties(org.apache.royale.html.Alert.prototype, /** @lends {org.apache.royale.html.Alert.prototype} */ {
/**
  * @export
  * @type {string} */
title: {
get: org.apache.royale.html.Alert.prototype.get__title,
set: org.apache.royale.html.Alert.prototype.set__title},
/**
  * @export
  * @type {string} */
message: {
get: org.apache.royale.html.Alert.prototype.get__message,
set: org.apache.royale.html.Alert.prototype.set__message},
/**
  * @export
  * @type {number} */
flags: {
get: org.apache.royale.html.Alert.prototype.get__flags,
set: org.apache.royale.html.Alert.prototype.set__flags}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.Alert.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Alert', qName: 'org.apache.royale.html.Alert', kind: 'class' }], interfaces: [org.apache.royale.core.IPopUp] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.Alert.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'title': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.html.Alert'},
        'message': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.html.Alert'},
        'flags': { type: 'uint', access: 'readwrite', declaredBy: 'org.apache.royale.html.Alert'}
      };
    },
    methods: function () {
      return {
        'Alert': { type: '', declaredBy: 'org.apache.royale.html.Alert'},
        '|show': { type: 'org.apache.royale.html.Alert', declaredBy: 'org.apache.royale.html.Alert', parameters: function () { return [  { index: 1, type: 'String', optional: false },{ index: 2, type: 'Object', optional: false },{ index: 3, type: 'String', optional: true },{ index: 4, type: 'uint', optional: true } ]; }},
        'show': { type: 'void', declaredBy: 'org.apache.royale.html.Alert', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }}
      };
    },
    metadata: function () { return [  ]; }
  };
};