/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven.trust;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.royale.maven.trust.TrustHandler;

@Named
@Singleton
public class DefaultTrustHandler
implements TrustHandler {
    @Override
    public void trustDirectory(File directory) {
        File securityTrustFile;
        block8: {
            securityTrustFile = new File(this.getSecuritySettingsDirectory(), "apache-royale-maven-plugin.cfg");
            if (!securityTrustFile.exists()) {
                System.out.println(" - Creating new FlashPlayer security trust file at: " + securityTrustFile.getPath());
                try {
                    if (!securityTrustFile.createNewFile()) {
                        throw new RuntimeException("Could not create FlashPlayer security trust file at: " + securityTrustFile.getPath());
                    }
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not create FlashPlayer security trust file at: " + securityTrustFile.getPath(), e);
                }
            }
            System.out.println(" - Updating FlashPlayer security trust file at: " + securityTrustFile.getPath());
        }
        try {
            List trustedDirectories = FileUtils.readLines((File)securityTrustFile, (String)"UTF-8");
            if (!trustedDirectories.contains(directory.getAbsolutePath())) {
                FileUtils.writeStringToFile((File)securityTrustFile, (String)(directory.getAbsolutePath() + "\n"), (String)"UTF-8", (boolean)true);
                System.out.println(" - Added directory '" + directory.getAbsolutePath() + "' to FlashPlayer security trust file at: " + securityTrustFile.getPath());
            } else {
                System.out.println(" - Directory '" + directory.getAbsolutePath() + "' already listed in FlashPlayer security trust file at: " + securityTrustFile.getPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not add directory '" + directory.getPath() + "' to FlashPlayer security trust file", e);
        }
    }

    private File getSecuritySettingsDirectory() {
        File securitySettingsDirectory;
        File userHome = new File(System.getProperty("user.home"));
        if (SystemUtils.IS_OS_WINDOWS) {
            File appDataDirectory = System.getenv("APPDATA") != null ? new File(System.getenv("APPDATA")) : (SystemUtils.IS_OS_WINDOWS_VISTA ? new File(userHome, "AppData/Roaming") : new File(userHome, "Application Data"));
            securitySettingsDirectory = new File(appDataDirectory, "Macromedia/Flash Player/#Security/FlashPlayerTrust");
        } else if (SystemUtils.IS_OS_MAC) {
            securitySettingsDirectory = new File(userHome, "Library/Preferences/Macromedia/Flash Player/#Security/FlashPlayerTrust");
        } else if (SystemUtils.IS_OS_LINUX) {
            securitySettingsDirectory = new File(userHome, ".macromedia/Flash_Player/#Security/FlashPlayerTrust");
        } else {
            throw new UnsupportedOperationException("FlashplayerSecurityHandler not prepared for handling OS type of: " + SystemUtils.OS_NAME);
        }
        if (!securitySettingsDirectory.exists() && !securitySettingsDirectory.mkdirs()) {
            throw new RuntimeException("Could not create FlashPlayer security settings directory at: " + securitySettingsDirectory.getPath());
        }
        return securitySettingsDirectory;
    }
}

