/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.royale.maven.utils.DependencyHelper;
import org.eclipse.aether.RepositorySystemSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="generate-manifests", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateManifestsMojo
extends AbstractMojo {
    @Parameter(defaultValue="namespaces")
    protected String namespaceDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySystemSession;
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Artifact> allLibraries = DependencyHelper.getAllLibraries(this.project, this.repositorySystemSession, this.projectDependenciesResolver);
        HashMap namespaces = new HashMap();
        for (Artifact artifact : allLibraries) {
            File libraryFile = artifact.getFile();
            if (!libraryFile.exists() || !libraryFile.getName().endsWith(".swc")) continue;
            Map<String, Map<String, String>> curLibNamespaces = this.getNamespacesFromLibrary(libraryFile);
            for (Map.Entry<String, Map<String, String>> namespace : curLibNamespaces.entrySet()) {
                String namespaceUri = namespace.getKey();
                if (!namespaces.containsKey(namespaceUri)) {
                    namespaces.put(namespaceUri, new HashMap());
                }
                for (Map.Entry<String, String> component : namespace.getValue().entrySet()) {
                    ((Map)namespaces.get(namespaceUri)).put(component.getKey(), component.getValue());
                }
            }
        }
        for (Map.Entry entry : namespaces.entrySet()) {
            this.createNamespace((String)entry.getKey(), (Map)entry.getValue());
        }
    }

    private Map<String, Map<String, String>> getNamespacesFromLibrary(File library) {
        HashMap<String, Map<String, String>> namespaces;
        block11: {
            namespaces = new HashMap<String, Map<String, String>>();
            try {
                ZipEntry ze;
                byte[] catalogBytes = null;
                FileInputStream fin = new FileInputStream(library);
                BufferedInputStream bin = new BufferedInputStream(fin);
                ZipInputStream zin = new ZipInputStream(bin);
                while ((ze = zin.getNextEntry()) != null) {
                    int len;
                    if (!ze.getName().equals("catalog.xml")) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    while ((len = zin.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                    catalogBytes = out.toByteArray();
                    break;
                }
                zin.close();
                if (catalogBytes == null) break block11;
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document catalog = builder.parse(new ByteArrayInputStream(catalogBytes));
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    xpath.setNamespaceContext(new NamespaceContext(){

                        @Override
                        public String getNamespaceURI(String prefix) {
                            return prefix.equals("cat") ? "http://www.adobe.com/flash/swccatalog/9" : null;
                        }

                        public Iterator getPrefixes(String val) {
                            return null;
                        }

                        @Override
                        public String getPrefix(String uri) {
                            return null;
                        }
                    });
                    XPathExpression expr = xpath.compile("/cat:swc/cat:components/cat:component");
                    Object result = expr.evaluate(catalog, XPathConstants.NODESET);
                    NodeList nodes = (NodeList)result;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element componentElement = (Element)nodes.item(i);
                        String className = componentElement.getAttribute("className");
                        String name = componentElement.getAttribute("name");
                        String uri = componentElement.getAttribute("uri");
                        if (!namespaces.containsKey(uri)) {
                            namespaces.put(uri, new HashMap());
                        }
                        ((Map)namespaces.get(uri)).put(name, className);
                    }
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return namespaces;
    }

    private void createNamespace(String namespaceUri, Map<String, String> components) throws MojoExecutionException {
        File namespaceDir = new File(this.outputDirectory, this.namespaceDirectory);
        if (!namespaceDir.exists() && !namespaceDir.mkdirs()) {
            throw new MojoExecutionException("Could not create namespace output directory at " + namespaceDir.getPath());
        }
        String namespaceFilename = namespaceUri.replaceAll(":", "-").replaceAll("/", "-") + ".xml";
        File namespaceOutputFile = new File(namespaceDir, namespaceFilename);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document namespaceDoc = factory.newDocumentBuilder().newDocument();
            Element componentPackageElement = namespaceDoc.createElement("componentPackage");
            componentPackageElement.setAttribute("namespace-uri", namespaceUri);
            namespaceDoc.appendChild(componentPackageElement);
            for (Map.Entry<String, String> component : components.entrySet()) {
                Element componentElement = namespaceDoc.createElement("component");
                componentElement.setAttribute("id", component.getKey());
                componentElement.setAttribute("class", component.getValue().replace(":", "."));
                componentPackageElement.appendChild(componentElement);
            }
            try {
                DOMSource source = new DOMSource(namespaceDoc);
                StreamResult result = new StreamResult(namespaceOutputFile);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, result);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

