/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util.data.collect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.test.util.data.collect.DataCollector;

public class MapDataCollectorImpl
implements DataCollector {
    private Map<Object, AtomicInteger> datas = new ConcurrentHashMap<Object, AtomicInteger>();
    private boolean lock = false;

    public MapDataCollectorImpl() {
    }

    public MapDataCollectorImpl(Collection<Object> datas) {
        for (Object data : datas) {
            this.addData(data);
        }
    }

    @Override
    public synchronized void addData(Object data) {
        if (this.lock) {
            return;
        }
        if (this.datas.containsKey(data)) {
            this.datas.get(data).addAndGet(1);
        } else {
            this.datas.put(data, new AtomicInteger(1));
        }
    }

    @Override
    public Collection<Object> getAllData() {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Map.Entry<Object, AtomicInteger> entry : this.datas.entrySet()) {
            for (int i = 0; i < entry.getValue().get(); ++i) {
                lst.add(entry.getKey());
            }
        }
        return lst;
    }

    @Override
    public long getDataSizeWithoutDuplicate() {
        return this.datas.keySet().size();
    }

    @Override
    public void resetData() {
        this.datas.clear();
        this.unlockIncrement();
    }

    @Override
    public long getDataSize() {
        long sum = 0L;
        for (AtomicInteger count : this.datas.values()) {
            sum += (long)count.get();
        }
        return sum;
    }

    @Override
    public boolean isRepeatedData(Object data) {
        if (this.datas.containsKey(data)) {
            return this.datas.get(data).get() == 1;
        }
        return false;
    }

    @Override
    public Collection<Object> getAllDataWithoutDuplicate() {
        return this.datas.keySet();
    }

    @Override
    public int getRepeatedTimeForData(Object data) {
        if (this.datas.containsKey(data)) {
            return this.datas.get(data).intValue();
        }
        return 0;
    }

    @Override
    public void removeData(Object data) {
        this.datas.remove(data);
    }

    @Override
    public void lockIncrement() {
        this.lock = true;
    }

    @Override
    public void unlockIncrement() {
        this.lock = false;
    }
}

