/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.listener.rmq.concurrent;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.test.listener.AbstractListener;

public class RMQNormalListener
extends AbstractListener
implements MessageListenerConcurrently {
    private ConsumeConcurrentlyStatus consumeStatus = ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    private AtomicInteger msgIndex = new AtomicInteger(0);

    public RMQNormalListener() {
    }

    public RMQNormalListener(String listenerName) {
        super(listenerName);
    }

    public RMQNormalListener(ConsumeConcurrentlyStatus consumeStatus) {
        this.consumeStatus = consumeStatus;
    }

    public RMQNormalListener(String originMsgCollector, String msgBodyCollector) {
        super(originMsgCollector, msgBodyCollector);
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        for (MessageExt msg : msgs) {
            this.msgIndex.getAndIncrement();
            if (this.isDebug) {
                if (this.listenerName != null && !this.listenerName.isEmpty()) {
                    logger.info((Object)(this.listenerName + ":" + this.msgIndex.get() + ":" + String.format("msgid:%s broker:%s queueId:%s offset:%s", msg.getMsgId(), msg.getStoreHost(), msg.getQueueId(), msg.getQueueOffset())));
                } else {
                    logger.info((Object)msg);
                }
            }
            this.msgBodys.addData(new String(msg.getBody()));
            this.originMsgs.addData(msg);
            if (this.originMsgIndex == null) continue;
            this.originMsgIndex.put(new String(msg.getBody()), msg);
        }
        return this.consumeStatus;
    }
}

