/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header;

import com.google.common.base.MoreObjects;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.rpc.TopicQueueRequestHeader;

public class PopMessageRequestHeader
extends TopicQueueRequestHeader {
    @CFNotNull
    private String consumerGroup;
    @CFNotNull
    private String topic;
    @CFNotNull
    private int queueId;
    @CFNotNull
    private int maxMsgNums;
    @CFNotNull
    private long invisibleTime;
    @CFNotNull
    private long pollTime;
    @CFNotNull
    private long bornTime;
    @CFNotNull
    private int initMode;
    private String expType;
    private String exp;
    private Boolean order = Boolean.FALSE;
    private String attemptId;

    @Override
    public void checkFields() throws RemotingCommandException {
    }

    public void setInitMode(int initMode) {
        this.initMode = initMode;
    }

    public int getInitMode() {
        return this.initMode;
    }

    public long getInvisibleTime() {
        return this.invisibleTime;
    }

    public void setInvisibleTime(long invisibleTime) {
        this.invisibleTime = invisibleTime;
    }

    public long getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(long pollTime) {
        this.pollTime = pollTime;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public long getBornTime() {
        return this.bornTime;
    }

    public void setBornTime(long bornTime) {
        this.bornTime = bornTime;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public Integer getQueueId() {
        if (this.queueId < 0) {
            return -1;
        }
        return this.queueId;
    }

    @Override
    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    public int getMaxMsgNums() {
        return this.maxMsgNums;
    }

    public void setMaxMsgNums(int maxMsgNums) {
        this.maxMsgNums = maxMsgNums;
    }

    public boolean isTimeoutTooMuch() {
        return System.currentTimeMillis() - this.bornTime - this.pollTime > 500L;
    }

    public String getExpType() {
        return this.expType;
    }

    public void setExpType(String expType) {
        this.expType = expType;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public Boolean getOrder() {
        return this.order;
    }

    public void setOrder(Boolean order) {
        this.order = order;
    }

    public boolean isOrder() {
        return this.order != null && this.order != false;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public void setAttemptId(String attemptId) {
        this.attemptId = attemptId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("consumerGroup", (Object)this.consumerGroup).add("topic", (Object)this.topic).add("queueId", this.queueId).add("maxMsgNums", this.maxMsgNums).add("invisibleTime", this.invisibleTime).add("pollTime", this.pollTime).add("bornTime", this.bornTime).add("initMode", this.initMode).add("expType", (Object)this.expType).add("exp", (Object)this.exp).add("order", (Object)this.order).add("attemptId", (Object)this.attemptId).toString();
    }
}

