/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logappender.logback;

import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.logappender.common.ProducerInstance;

public class RocketmqLogbackAppender
extends AppenderBase<ILoggingEvent> {
    private String tag;
    private String topic;
    private String nameServerAddress;
    private String producerGroup;
    private MQProducer producer;
    private Layout layout;
    private PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    protected void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        String logStr = this.layout.doLayout((Object)event);
        try {
            Message msg = new Message(this.topic, this.tag, logStr.getBytes());
            msg.getProperties().put("APPENDER_TYPE", "LOGBACK_APPENDER");
            this.producer.sendOneway(msg);
        }
        catch (Exception e) {
            this.addError("Could not send message in RocketmqLogbackAppender [" + this.name + "]. Message is : " + logStr, e);
        }
    }

    public void start() {
        int errors = 0;
        if (this.layout == null) {
            this.addStatus((Status)new ErrorStatus("No layout set for the RocketmqLogbackAppender named \"" + this.name + "\".", (Object)this));
            ++errors;
        }
        if (errors > 0 || !this.checkEntryConditions()) {
            return;
        }
        try {
            this.producer = ProducerInstance.getProducerInstance().getInstance(this.nameServerAddress, this.producerGroup);
        }
        catch (Exception e) {
            this.addError("Starting RocketmqLogbackAppender [" + this.getName() + "] nameServerAddress:" + this.nameServerAddress + " group:" + this.producerGroup + " " + e.getMessage());
        }
        if (this.producer != null) {
            super.start();
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            ProducerInstance.getProducerInstance().removeAndClose(this.nameServerAddress, this.producerGroup);
        }
        catch (Exception e) {
            this.addError("Closeing RocketmqLogbackAppender [" + this.getName() + "] nameServerAddress:" + this.nameServerAddress + " group:" + this.producerGroup + " " + e.getMessage());
        }
        this.producer = null;
    }

    protected boolean checkEntryConditions() {
        String fail = null;
        if (this.topic == null) {
            fail = "No topic";
        }
        if (fail != null) {
            this.addError(fail + " for RocketmqLogbackAppender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setNameServerAddress(String nameServerAddress) {
        this.nameServerAddress = nameServerAddress;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }
}

