/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logappender.log4j2;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.logappender.common.ProducerInstance;

@Plugin(name="RocketMQ", category="Core", elementType="appender", printObject=true)
public class RocketmqLog4j2Appender
extends AbstractAppender {
    private String nameServerAddress;
    private String producerGroup;
    private MQProducer producer;
    private String tag;
    private String topic;

    protected RocketmqLog4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String nameServerAddress, String producerGroup, String topic, String tag) {
        block2: {
            super(name, filter, layout, ignoreExceptions);
            this.producer = this.producer;
            this.topic = topic;
            this.tag = tag;
            this.nameServerAddress = nameServerAddress;
            this.producerGroup = producerGroup;
            try {
                this.producer = ProducerInstance.getProducerInstance().getInstance(this.nameServerAddress, this.producerGroup);
            }
            catch (Exception e) {
                ErrorHandler handler = this.getHandler();
                if (handler == null) break block2;
                handler.error("Starting RocketmqLog4j2Appender [" + this.getName() + "] nameServerAddress:" + nameServerAddress + " group:" + producerGroup + " " + e.getMessage());
            }
        }
    }

    public void append(LogEvent event) {
        block3: {
            if (null == this.producer) {
                return;
            }
            byte[] data = this.getLayout().toByteArray(event);
            try {
                Message msg = new Message(this.topic, this.tag, data);
                msg.getProperties().put("APPENDER_TYPE", "LOG4J2_APPENDER");
                this.producer.sendOneway(msg);
            }
            catch (Exception e) {
                ErrorHandler handler = this.getHandler();
                if (handler == null) break block3;
                String msg = new String(data);
                handler.error("Could not send message in RocketmqLog4j2Appender [" + this.getName() + "].Message is : " + msg, (Throwable)e);
            }
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        block2: {
            this.setStopping();
            try {
                ProducerInstance.getProducerInstance().removeAndClose(this.nameServerAddress, this.producerGroup);
            }
            catch (Exception e) {
                ErrorHandler handler = this.getHandler();
                if (handler == null) break block2;
                handler.error("Closeing RocketmqLog4j2Appender [" + this.getName() + "] nameServerAddress:" + this.nameServerAddress + " group:" + this.producerGroup + " " + e.getMessage());
            }
        }
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<RocketmqLog4j2Appender> {
        @PluginBuilderAttribute
        @Required(message="A name for the RocketmqLog4j2Appender must be specified")
        private String name;
        @PluginElement(value="Layout")
        private Layout<? extends Serializable> layout = SerializedLayout.createLayout();
        @PluginElement(value="Filter")
        private Filter filter;
        @PluginBuilderAttribute
        private boolean ignoreExceptions = true;
        @PluginBuilderAttribute
        private String tag;
        @PluginBuilderAttribute
        private String nameServerAddress;
        @PluginBuilderAttribute
        private String producerGroup;
        @PluginBuilderAttribute
        @Required(message="A topic name must be specified")
        private String topic;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLayout(Layout<? extends Serializable> layout) {
            this.layout = layout;
            return this;
        }

        public Builder setFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setNameServerAddress(String nameServerAddress) {
            this.nameServerAddress = nameServerAddress;
            return this;
        }

        public Builder setProducerGroup(String producerGroup) {
            this.producerGroup = producerGroup;
            return this;
        }

        public RocketmqLog4j2Appender build() {
            return new RocketmqLog4j2Appender(this.name, this.filter, this.layout, this.ignoreExceptions, this.nameServerAddress, this.producerGroup, this.topic, this.tag);
        }
    }
}

