/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.topic;

import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class TopicValidator {
    public static final String AUTO_CREATE_TOPIC_KEY_TOPIC = "TBW102";
    public static final String RMQ_SYS_SCHEDULE_TOPIC = "SCHEDULE_TOPIC_XXXX";
    public static final String RMQ_SYS_BENCHMARK_TOPIC = "BenchmarkTest";
    public static final String RMQ_SYS_TRANS_HALF_TOPIC = "RMQ_SYS_TRANS_HALF_TOPIC";
    public static final String RMQ_SYS_TRACE_TOPIC = "RMQ_SYS_TRACE_TOPIC";
    public static final String RMQ_SYS_TRANS_OP_HALF_TOPIC = "RMQ_SYS_TRANS_OP_HALF_TOPIC";
    public static final String RMQ_SYS_TRANS_CHECK_MAX_TIME_TOPIC = "TRANS_CHECK_MAX_TIME_TOPIC";
    public static final String RMQ_SYS_SELF_TEST_TOPIC = "SELF_TEST_TOPIC";
    public static final String RMQ_SYS_OFFSET_MOVED_EVENT = "OFFSET_MOVED_EVENT";
    public static final String SYSTEM_TOPIC_PREFIX = "rmq_sys_";
    public static final boolean[] VALID_CHAR_BIT_MAP = new boolean[128];
    private static final int TOPIC_MAX_LENGTH = 127;
    private static final Set<String> SYSTEM_TOPIC_SET = new HashSet<String>();
    private static final Set<String> NOT_ALLOWED_SEND_TOPIC_SET = new HashSet<String>();

    public static boolean isTopicOrGroupIllegal(String str) {
        int strLen = str.length();
        int len = VALID_CHAR_BIT_MAP.length;
        boolean[] bitMap = VALID_CHAR_BIT_MAP;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (ch < len && bitMap[ch]) continue;
            return true;
        }
        return false;
    }

    public static boolean validateTopic(String topic, RemotingCommand response) {
        if (UtilAll.isBlank(topic)) {
            response.setCode(1);
            response.setRemark("The specified topic is blank.");
            return false;
        }
        if (TopicValidator.isTopicOrGroupIllegal(topic)) {
            response.setCode(1);
            response.setRemark("The specified topic contains illegal characters, allowing only ^[%|a-zA-Z0-9_-]+$");
            return false;
        }
        if (topic.length() > 127) {
            response.setCode(1);
            response.setRemark("The specified topic is longer than topic max length.");
            return false;
        }
        return true;
    }

    public static boolean isSystemTopic(String topic, RemotingCommand response) {
        if (TopicValidator.isSystemTopic(topic)) {
            response.setCode(1);
            response.setRemark("The topic[" + topic + "] is conflict with system topic.");
            return true;
        }
        return false;
    }

    public static boolean isSystemTopic(String topic) {
        return SYSTEM_TOPIC_SET.contains(topic) || topic.startsWith(SYSTEM_TOPIC_PREFIX);
    }

    public static boolean isNotAllowedSendTopic(String topic) {
        return NOT_ALLOWED_SEND_TOPIC_SET.contains(topic);
    }

    public static boolean isNotAllowedSendTopic(String topic, RemotingCommand response) {
        if (TopicValidator.isNotAllowedSendTopic(topic)) {
            response.setCode(16);
            response.setRemark("Sending message to topic[" + topic + "] is forbidden.");
            return true;
        }
        return false;
    }

    public static void addSystemTopic(String systemTopic) {
        SYSTEM_TOPIC_SET.add(systemTopic);
    }

    public static Set<String> getSystemTopicSet() {
        return SYSTEM_TOPIC_SET;
    }

    public static Set<String> getNotAllowedSendTopicSet() {
        return NOT_ALLOWED_SEND_TOPIC_SET;
    }

    static {
        SYSTEM_TOPIC_SET.add(AUTO_CREATE_TOPIC_KEY_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_SCHEDULE_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_BENCHMARK_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRANS_HALF_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRACE_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRANS_OP_HALF_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRANS_CHECK_MAX_TIME_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_SELF_TEST_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_OFFSET_MOVED_EVENT);
        NOT_ALLOWED_SEND_TOPIC_SET.add(RMQ_SYS_SCHEDULE_TOPIC);
        TopicValidator.VALID_CHAR_BIT_MAP[37] = true;
        TopicValidator.VALID_CHAR_BIT_MAP[45] = true;
        TopicValidator.VALID_CHAR_BIT_MAP[95] = true;
        TopicValidator.VALID_CHAR_BIT_MAP[124] = true;
        for (int i = 0; i < VALID_CHAR_BIT_MAP.length; ++i) {
            if (i >= 48 && i <= 57) {
                TopicValidator.VALID_CHAR_BIT_MAP[i] = true;
                continue;
            }
            if (i >= 65 && i <= 90) {
                TopicValidator.VALID_CHAR_BIT_MAP[i] = true;
                continue;
            }
            if (i < 97 || i > 122) continue;
            TopicValidator.VALID_CHAR_BIT_MAP[i] = true;
        }
    }
}

