/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.filter;

import java.net.URL;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;

public class FilterAPI {
    public static URL classFile(String className) {
        String javaSource = FilterAPI.simpleClassName(className) + ".java";
        URL url = FilterAPI.class.getClassLoader().getResource(javaSource);
        return url;
    }

    public static String simpleClassName(String className) {
        String simple = className;
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            simple = className.substring(index + 1);
        }
        return simple;
    }

    public static SubscriptionData buildSubscriptionData(String consumerGroup, String topic, String subString) throws Exception {
        SubscriptionData subscriptionData = new SubscriptionData();
        subscriptionData.setTopic(topic);
        subscriptionData.setSubString(subString);
        if (null == subString || subString.equals("*") || subString.length() == 0) {
            subscriptionData.setSubString("*");
        } else {
            String[] tags = subString.split("\\|\\|");
            if (tags.length > 0) {
                for (String tag : tags) {
                    String trimString;
                    if (tag.length() <= 0 || (trimString = tag.trim()).length() <= 0) continue;
                    subscriptionData.getTagsSet().add(trimString);
                    subscriptionData.getCodeSet().add(trimString.hashCode());
                }
            } else {
                throw new Exception("subString split error");
            }
        }
        return subscriptionData;
    }

    public static SubscriptionData build(String topic, String subString, String type) throws Exception {
        if ("TAG".equals(type) || type == null) {
            return FilterAPI.buildSubscriptionData(null, topic, subString);
        }
        if (subString == null || subString.length() < 1) {
            throw new IllegalArgumentException("Expression can't be null! " + type);
        }
        SubscriptionData subscriptionData = new SubscriptionData();
        subscriptionData.setTopic(topic);
        subscriptionData.setSubString(subString);
        subscriptionData.setExpressionType(type);
        return subscriptionData;
    }
}

