/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.stats.MomentStatsItem;
import org.apache.rocketmq.logging.InternalLogger;

public class MomentStatsItemSet {
    private final ConcurrentMap<String, MomentStatsItem> statsItemTable = new ConcurrentHashMap<String, MomentStatsItem>(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogger log;

    public MomentStatsItemSet(String statsName, ScheduledExecutorService scheduledExecutorService, InternalLogger log) {
        this.statsName = statsName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
        this.init();
    }

    public ConcurrentMap<String, MomentStatsItem> getStatsItemTable() {
        return this.statsItemTable;
    }

    public String getStatsName() {
        return this.statsName;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MomentStatsItemSet.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 300000L, TimeUnit.MILLISECONDS);
    }

    private void printAtMinutes() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((MomentStatsItem)next.getValue()).printAtMinutes();
        }
    }

    public void setValue(String statsKey, int value) {
        MomentStatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().set(value);
    }

    public MomentStatsItem getAndCreateStatsItem(String statsKey) {
        MomentStatsItem prev;
        MomentStatsItem statsItem = (MomentStatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem || null == (prev = this.statsItemTable.put(statsKey, statsItem = new MomentStatsItem(this.statsName, statsKey, this.scheduledExecutorService, this.log)))) {
            // empty if block
        }
        return statsItem;
    }
}

