/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.protocol.route;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BrokerData
implements Comparable<BrokerData> {
    private String cluster;
    private String brokerName;
    private HashMap<Long, String> brokerAddrs;

    public BrokerData() {
    }

    public BrokerData(String cluster, String brokerName, HashMap<Long, String> brokerAddrs) {
        this.cluster = cluster;
        this.brokerName = brokerName;
        this.brokerAddrs = brokerAddrs;
    }

    public String selectBrokerAddr() {
        Iterator<Map.Entry<Long, String>> iterator;
        String value = this.brokerAddrs.get(0L);
        if (null == value && (iterator = this.brokerAddrs.entrySet().iterator()).hasNext()) {
            Map.Entry<Long, String> entry = iterator.next();
            return entry.getValue();
        }
        return value;
    }

    public HashMap<Long, String> getBrokerAddrs() {
        return this.brokerAddrs;
    }

    public void setBrokerAddrs(HashMap<Long, String> brokerAddrs) {
        this.brokerAddrs = brokerAddrs;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.brokerAddrs == null ? 0 : this.brokerAddrs.hashCode());
        result = 31 * result + (this.brokerName == null ? 0 : this.brokerName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrokerData other = (BrokerData)obj;
        if (this.brokerAddrs == null ? other.brokerAddrs != null : !this.brokerAddrs.equals(other.brokerAddrs)) {
            return false;
        }
        return !(this.brokerName == null ? other.brokerName != null : !this.brokerName.equals(other.brokerName));
    }

    public String toString() {
        return "BrokerData [brokerName=" + this.brokerName + ", brokerAddrs=" + this.brokerAddrs + "]";
    }

    @Override
    public int compareTo(BrokerData o) {
        return this.brokerName.compareTo(o.getBrokerName());
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }
}

