/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.io.IOException;
import org.apache.rocketmq.common.MixAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigManager {
    private static final Logger PLOG = LoggerFactory.getLogger((String)"RocketmqCommon");

    public abstract String encode();

    public boolean load() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName);
            if (null == jsonString || jsonString.length() == 0) {
                return this.loadBak();
            }
            this.decode(jsonString);
            PLOG.info("load {} OK", (Object)fileName);
            return true;
        }
        catch (Exception e) {
            PLOG.error("load " + fileName + " Failed, and try to load backup file", (Throwable)e);
            return this.loadBak();
        }
    }

    public abstract String configFilePath();

    private boolean loadBak() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName + ".bak");
            if (jsonString != null && jsonString.length() > 0) {
                this.decode(jsonString);
                PLOG.info("load " + fileName + " OK");
                return true;
            }
        }
        catch (Exception e) {
            PLOG.error("load " + fileName + " Failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public abstract void decode(String var1);

    public synchronized void persist() {
        String jsonString = this.encode(true);
        if (jsonString != null) {
            String fileName = this.configFilePath();
            try {
                MixAll.string2File(jsonString, fileName);
            }
            catch (IOException e) {
                PLOG.error("persist file Exception, " + fileName, (Throwable)e);
            }
        }
    }

    public abstract String encode(boolean var1);
}

