/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.producer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.exception.RequestTimeoutException;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.client.producer.RequestResponseFuture;
import org.apache.rocketmq.logging.InternalLogger;

public class RequestFutureTable {
    private static InternalLogger log = ClientLogger.getLog();
    private static ConcurrentHashMap<String, RequestResponseFuture> requestFutureTable = new ConcurrentHashMap();
    private static final AtomicInteger PRODUCER_NUM = new AtomicInteger(0);

    public static ConcurrentHashMap<String, RequestResponseFuture> getRequestFutureTable() {
        return requestFutureTable;
    }

    public static void scanExpiredRequest() {
        LinkedList<RequestResponseFuture> rfList = new LinkedList<RequestResponseFuture>();
        Iterator<Map.Entry<String, RequestResponseFuture>> it = requestFutureTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RequestResponseFuture> next = it.next();
            RequestResponseFuture rep = next.getValue();
            if (!rep.isTimeout()) continue;
            it.remove();
            rfList.add(rep);
            log.warn("remove timeout request, CorrelationId={}" + rep.getCorrelationId());
        }
        for (RequestResponseFuture rf : rfList) {
            try {
                RequestTimeoutException cause = new RequestTimeoutException(10006, "request timeout, no reply message.");
                rf.setCause(cause);
                rf.executeRequestCallback();
            }
            catch (Throwable e) {
                log.warn("scanResponseTable, operationComplete Exception", e);
            }
        }
    }

    public static AtomicInteger getProducerNum() {
        return PRODUCER_NUM;
    }
}

