/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.impl.consumer.RebalanceImpl;
import org.apache.rocketmq.common.message.MessageQueue;

public class AssignedMessageQueue {
    private final ConcurrentHashMap<MessageQueue, MessageQueueState> assignedMessageQueueState = new ConcurrentHashMap();
    private RebalanceImpl rebalanceImpl;

    public void setRebalanceImpl(RebalanceImpl rebalanceImpl) {
        this.rebalanceImpl = rebalanceImpl;
    }

    public Set<MessageQueue> messageQueues() {
        return this.assignedMessageQueueState.keySet();
    }

    public boolean isPaused(MessageQueue messageQueue) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            return messageQueueState.isPaused();
        }
        return true;
    }

    public void pause(Collection<MessageQueue> messageQueues) {
        for (MessageQueue messageQueue : messageQueues) {
            MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
            if (this.assignedMessageQueueState.get(messageQueue) == null) continue;
            messageQueueState.setPaused(true);
        }
    }

    public void resume(Collection<MessageQueue> messageQueueCollection) {
        for (MessageQueue messageQueue : messageQueueCollection) {
            MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
            if (this.assignedMessageQueueState.get(messageQueue) == null) continue;
            messageQueueState.setPaused(false);
        }
    }

    public ProcessQueue getProcessQueue(MessageQueue messageQueue) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            return messageQueueState.getProcessQueue();
        }
        return null;
    }

    public long getPullOffset(MessageQueue messageQueue) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            return messageQueueState.getPullOffset();
        }
        return -1L;
    }

    public void updatePullOffset(MessageQueue messageQueue, long offset) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            messageQueueState.setPullOffset(offset);
        }
    }

    public long getConusmerOffset(MessageQueue messageQueue) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            return messageQueueState.getConsumeOffset();
        }
        return -1L;
    }

    public void updateConsumeOffset(MessageQueue messageQueue, long offset) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            messageQueueState.setConsumeOffset(offset);
        }
    }

    public void setSeekOffset(MessageQueue messageQueue, long offset) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            messageQueueState.setSeekOffset(offset);
        }
    }

    public long getSeekOffset(MessageQueue messageQueue) {
        MessageQueueState messageQueueState = this.assignedMessageQueueState.get(messageQueue);
        if (messageQueueState != null) {
            return messageQueueState.getSeekOffset();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAssignedMessageQueue(String topic, Collection<MessageQueue> assigned) {
        ConcurrentHashMap<MessageQueue, MessageQueueState> concurrentHashMap = this.assignedMessageQueueState;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<MessageQueue, MessageQueueState>> it = this.assignedMessageQueueState.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MessageQueue, MessageQueueState> next = it.next();
                if (!next.getKey().getTopic().equals(topic) || assigned.contains(next.getKey())) continue;
                next.getValue().getProcessQueue().setDropped(true);
                it.remove();
            }
            this.addAssignedMessageQueue(assigned);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAssignedMessageQueue(Collection<MessageQueue> assigned) {
        ConcurrentHashMap<MessageQueue, MessageQueueState> concurrentHashMap = this.assignedMessageQueueState;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<MessageQueue, MessageQueueState>> it = this.assignedMessageQueueState.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MessageQueue, MessageQueueState> next = it.next();
                if (assigned.contains(next.getKey())) continue;
                next.getValue().getProcessQueue().setDropped(true);
                it.remove();
            }
            this.addAssignedMessageQueue(assigned);
        }
    }

    private void addAssignedMessageQueue(Collection<MessageQueue> assigned) {
        for (MessageQueue messageQueue : assigned) {
            MessageQueueState messageQueueState;
            if (this.assignedMessageQueueState.containsKey(messageQueue)) continue;
            if (this.rebalanceImpl != null && this.rebalanceImpl.getProcessQueueTable().get(messageQueue) != null) {
                messageQueueState = new MessageQueueState(messageQueue, (ProcessQueue)this.rebalanceImpl.getProcessQueueTable().get(messageQueue));
            } else {
                ProcessQueue processQueue = new ProcessQueue();
                messageQueueState = new MessageQueueState(messageQueue, processQueue);
            }
            this.assignedMessageQueueState.put(messageQueue, messageQueueState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssignedMessageQueue(String topic) {
        ConcurrentHashMap<MessageQueue, MessageQueueState> concurrentHashMap = this.assignedMessageQueueState;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<MessageQueue, MessageQueueState>> it = this.assignedMessageQueueState.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MessageQueue, MessageQueueState> next = it.next();
                if (!next.getKey().getTopic().equals(topic)) continue;
                it.remove();
            }
        }
    }

    private class MessageQueueState {
        private MessageQueue messageQueue;
        private ProcessQueue processQueue;
        private volatile boolean paused = false;
        private volatile long pullOffset = -1L;
        private volatile long consumeOffset = -1L;
        private volatile long seekOffset = -1L;

        private MessageQueueState(MessageQueue messageQueue, ProcessQueue processQueue) {
            this.messageQueue = messageQueue;
            this.processQueue = processQueue;
        }

        public MessageQueue getMessageQueue() {
            return this.messageQueue;
        }

        public void setMessageQueue(MessageQueue messageQueue) {
            this.messageQueue = messageQueue;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void setPaused(boolean paused) {
            this.paused = paused;
        }

        public long getPullOffset() {
            return this.pullOffset;
        }

        public void setPullOffset(long pullOffset) {
            this.pullOffset = pullOffset;
        }

        public ProcessQueue getProcessQueue() {
            return this.processQueue;
        }

        public void setProcessQueue(ProcessQueue processQueue) {
            this.processQueue = processQueue;
        }

        public long getConsumeOffset() {
            return this.consumeOffset;
        }

        public void setConsumeOffset(long consumeOffset) {
            this.consumeOffset = consumeOffset;
        }

        public long getSeekOffset() {
            return this.seekOffset;
        }

        public void setSeekOffset(long seekOffset) {
            this.seekOffset = seekOffset;
        }
    }
}

