/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.longpolling;

import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class NotificationRequest {
    private RemotingCommand remotingCommand;
    private Channel channel;
    private long expired;
    private AtomicBoolean complete = new AtomicBoolean(false);

    public NotificationRequest(RemotingCommand remotingCommand, Channel channel, long expired) {
        this.channel = channel;
        this.remotingCommand = remotingCommand;
        this.expired = expired;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public RemotingCommand getRemotingCommand() {
        return this.remotingCommand;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.expired - 3000L;
    }

    public boolean complete() {
        return this.complete.compareAndSet(false, true);
    }

    public String toString() {
        return this.remotingCommand.toString();
    }
}

