/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.mqtrace.SendMessageContext;
import org.apache.rocketmq.broker.mqtrace.SendMessageHook;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.protocol.NamespaceUtil;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeaderV2;
import org.apache.rocketmq.common.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.common.utils.ChannelUtil;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.MessageExtBrokerInner;

public abstract class AbstractSendMessageProcessor
implements NettyRequestProcessor {
    protected static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    protected static final int DLQ_NUMS_PER_GROUP = 1;
    protected final BrokerController brokerController;
    protected final Random random = new Random(System.currentTimeMillis());
    protected final SocketAddress storeHost;
    private List<SendMessageHook> sendMessageHookList;

    public AbstractSendMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.storeHost = new InetSocketAddress(brokerController.getBrokerConfig().getBrokerIP1(), brokerController.getNettyServerConfig().getListenPort());
    }

    protected SendMessageContext buildMsgContext(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader) {
        if (!this.hasSendMessageHook()) {
            return null;
        }
        String namespace = NamespaceUtil.getNamespaceFromResource((String)requestHeader.getTopic());
        SendMessageContext mqtraceContext = new SendMessageContext();
        mqtraceContext.setProducerGroup(requestHeader.getProducerGroup());
        mqtraceContext.setNamespace(namespace);
        mqtraceContext.setTopic(requestHeader.getTopic());
        mqtraceContext.setMsgProps(requestHeader.getProperties());
        mqtraceContext.setBornHost(RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        mqtraceContext.setBrokerAddr(this.brokerController.getBrokerAddr());
        mqtraceContext.setBrokerRegionId(this.brokerController.getBrokerConfig().getRegionId());
        mqtraceContext.setBornTimeStamp(requestHeader.getBornTimestamp());
        Map properties = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        String uniqueKey = (String)properties.get("UNIQ_KEY");
        properties.put("MSG_REGION", this.brokerController.getBrokerConfig().getRegionId());
        properties.put("TRACE_ON", String.valueOf(this.brokerController.getBrokerConfig().isTraceOn()));
        requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)properties));
        if (uniqueKey == null) {
            uniqueKey = "";
        }
        mqtraceContext.setMsgUniqueKey(uniqueKey);
        return mqtraceContext;
    }

    public boolean hasSendMessageHook() {
        return this.sendMessageHookList != null && !this.sendMessageHookList.isEmpty();
    }

    protected MessageExtBrokerInner buildInnerMsg(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, byte[] body, TopicConfig topicConfig) {
        int queueIdInt = requestHeader.getQueueId();
        if (queueIdInt < 0) {
            queueIdInt = Math.abs(this.random.nextInt() % 99999999) % topicConfig.getWriteQueueNums();
        }
        int sysFlag = requestHeader.getSysFlag();
        if (TopicFilterType.MULTI_TAG == topicConfig.getTopicFilterType()) {
            sysFlag |= 2;
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(requestHeader.getTopic());
        msgInner.setBody(body);
        msgInner.setFlag(requestHeader.getFlag().intValue());
        MessageAccessor.setProperties((Message)msgInner, (Map)MessageDecoder.string2messageProperties((String)requestHeader.getProperties()));
        msgInner.setPropertiesString(requestHeader.getProperties());
        msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicConfig.getTopicFilterType(), (String)msgInner.getTags()));
        msgInner.setQueueId(queueIdInt);
        msgInner.setSysFlag(sysFlag);
        msgInner.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        msgInner.setBornHost(ctx.channel().remoteAddress());
        msgInner.setStoreHost(this.getStoreHost());
        msgInner.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        return msgInner;
    }

    public SocketAddress getStoreHost() {
        return this.storeHost;
    }

    protected RemotingCommand msgContentCheck(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, RemotingCommand request, RemotingCommand response) {
        if (requestHeader.getTopic().length() > 127) {
            log.warn("putMessage message topic length too long {}", (Object)requestHeader.getTopic().length());
            response.setCode(13);
            return response;
        }
        if (requestHeader.getProperties() != null && requestHeader.getProperties().length() > Short.MAX_VALUE) {
            log.warn("putMessage message properties length too long {}", (Object)requestHeader.getProperties().length());
            response.setCode(13);
            return response;
        }
        if (request.getBody().length > 0x4000000) {
            log.warn(" topic {}  msg body size {}  from {}", new Object[]{requestHeader.getTopic(), request.getBody().length, ChannelUtil.getRemoteIp((Channel)ctx.channel())});
            response.setRemark("msg body must be less 64KB");
            response.setCode(13);
            return response;
        }
        return response;
    }

    protected RemotingCommand msgCheck(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, RemotingCommand response) {
        int idValid;
        int queueIdInt;
        if (!PermName.isWriteable((int)this.brokerController.getBrokerConfig().getBrokerPermission()) && this.brokerController.getTopicConfigManager().isOrderTopic(requestHeader.getTopic())) {
            response.setCode(16);
            response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] sending message is forbidden");
            return response;
        }
        if (!this.brokerController.getTopicConfigManager().isTopicCanSendMessage(requestHeader.getTopic())) {
            String errorMsg = "the topic[" + requestHeader.getTopic() + "] is conflict with system reserved words.";
            log.warn(errorMsg);
            response.setCode(1);
            response.setRemark(errorMsg);
            return response;
        }
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            int topicSysFlag = 0;
            if (requestHeader.isUnitMode()) {
                topicSysFlag = requestHeader.getTopic().startsWith("%RETRY%") ? TopicSysFlag.buildSysFlag((boolean)false, (boolean)true) : TopicSysFlag.buildSysFlag((boolean)true, (boolean)false);
            }
            log.warn("the topic {} not exist, producer: {}", (Object)requestHeader.getTopic(), (Object)ctx.channel().remoteAddress());
            topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageMethod(requestHeader.getTopic(), requestHeader.getDefaultTopic(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.getDefaultTopicQueueNums(), topicSysFlag);
            if (null == topicConfig && requestHeader.getTopic().startsWith("%RETRY%")) {
                topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(requestHeader.getTopic(), 1, 6, topicSysFlag);
            }
            if (null == topicConfig) {
                response.setCode(17);
                response.setRemark("topic[" + requestHeader.getTopic() + "] not exist, apply first please!" + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                return response;
            }
        }
        if ((queueIdInt = requestHeader.getQueueId().intValue()) >= (idValid = Math.max(topicConfig.getWriteQueueNums(), topicConfig.getReadQueueNums()))) {
            String errorInfo = String.format("request queueId[%d] is illegal, %s Producer: %s", queueIdInt, topicConfig.toString(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
            log.warn(errorInfo);
            response.setCode(1);
            response.setRemark(errorInfo);
            return response;
        }
        return response;
    }

    public void registerSendMessageHook(List<SendMessageHook> sendMessageHookList) {
        this.sendMessageHookList = sendMessageHookList;
    }

    protected void doResponse(ChannelHandlerContext ctx, RemotingCommand request, RemotingCommand response) {
        if (!request.isOnewayRPC()) {
            try {
                ctx.writeAndFlush((Object)response);
            }
            catch (Throwable e) {
                log.error("SendMessageProcessor process request over, but response failed", e);
                log.error(request.toString());
                log.error(response.toString());
            }
        }
    }

    public void executeSendMessageHookBefore(ChannelHandlerContext ctx, RemotingCommand request, SendMessageContext context) {
        if (this.hasSendMessageHook()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    SendMessageRequestHeader requestHeader = this.parseRequestHeader(request);
                    String namespace = NamespaceUtil.getNamespaceFromResource((String)requestHeader.getTopic());
                    if (null != requestHeader) {
                        context.setNamespace(namespace);
                        context.setProducerGroup(requestHeader.getProducerGroup());
                        context.setTopic(requestHeader.getTopic());
                        context.setBodyLength(request.getBody().length);
                        context.setMsgProps(requestHeader.getProperties());
                        context.setBornHost(RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
                        context.setBrokerAddr(this.brokerController.getBrokerAddr());
                        context.setQueueId(requestHeader.getQueueId());
                    }
                    hook.sendMessageBefore(context);
                    if (requestHeader == null) continue;
                    requestHeader.setProperties(context.getMsgProps());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected SendMessageRequestHeader parseRequestHeader(RemotingCommand request) throws RemotingCommandException {
        SendMessageRequestHeaderV2 requestHeaderV2 = null;
        SendMessageRequestHeader requestHeader = null;
        switch (request.getCode()) {
            case 310: 
            case 320: {
                requestHeaderV2 = (SendMessageRequestHeaderV2)request.decodeCommandCustomHeader(SendMessageRequestHeaderV2.class);
            }
            case 10: {
                requestHeader = null == requestHeaderV2 ? (SendMessageRequestHeader)request.decodeCommandCustomHeader(SendMessageRequestHeader.class) : SendMessageRequestHeaderV2.createSendMessageRequestHeaderV1((SendMessageRequestHeaderV2)requestHeaderV2);
            }
        }
        return requestHeader;
    }

    public void executeSendMessageHookAfter(RemotingCommand response, SendMessageContext context) {
        if (this.hasSendMessageHook()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    if (response != null) {
                        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
                        context.setMsgId(responseHeader.getMsgId());
                        context.setQueueId(responseHeader.getQueueId());
                        context.setQueueOffset(responseHeader.getQueueOffset());
                        context.setCode(response.getCode());
                        context.setErrorMsg(response.getRemark());
                    }
                    hook.sendMessageAfter(context);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public boolean rejectRequest() {
        return false;
    }
}

