/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.Permission;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategyFactory;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.srvutil.FileWatchService;

public class PlainPermissionManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");
    private static final String DEFAULT_PLAIN_ACL_FILE = "/conf/plain_acl.yml";
    private String fileHome = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));
    private String fileName = System.getProperty("rocketmq.acl.plain.file", "/conf/plain_acl.yml");
    private Map<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
    private List<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
    private RemoteAddressStrategyFactory remoteAddressStrategyFactory = new RemoteAddressStrategyFactory();
    private boolean isWatchStart;
    private final DataVersion dataVersion = new DataVersion();

    public PlainPermissionManager() {
        this.load();
        this.watch();
    }

    public void load() {
        JSONArray tempDataVersion;
        JSONArray accounts;
        HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        JSONObject plainAclConfData = AclUtils.getYamlDataObject(this.fileHome + File.separator + this.fileName, JSONObject.class);
        if (plainAclConfData == null || plainAclConfData.isEmpty()) {
            throw new AclException(String.format("%s file is not data", this.fileHome + File.separator + this.fileName));
        }
        log.info("Broker plain acl conf data is : ", (Object)plainAclConfData.toString());
        JSONArray globalWhiteRemoteAddressesList = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
        if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
            for (int i = 0; i < globalWhiteRemoteAddressesList.size(); ++i) {
                globalWhiteRemoteAddressStrategy.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(globalWhiteRemoteAddressesList.getString(i)));
            }
        }
        if ((accounts = plainAclConfData.getJSONArray("accounts")) != null && !accounts.isEmpty()) {
            List plainAccessConfigList = accounts.toJavaList(PlainAccessConfig.class);
            for (PlainAccessConfig plainAccessConfig : plainAccessConfigList) {
                PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
            }
        }
        if ((tempDataVersion = plainAclConfData.getJSONArray("dataVersion")) != null && !tempDataVersion.isEmpty()) {
            List dataVersion = tempDataVersion.toJavaList(DataVersion.class);
            DataVersion firstElement = (DataVersion)dataVersion.get(0);
            this.dataVersion.assignNewOne(firstElement);
        }
        this.globalWhiteRemoteAddressStrategy = globalWhiteRemoteAddressStrategy;
        this.plainAccessResourceMap = plainAccessResourceMap;
    }

    public String getAclConfigDataVersion() {
        return this.dataVersion.toJson();
    }

    private Map<String, Object> updateAclConfigFileVersion(Map<String, Object> updateAclConfigMap) {
        this.dataVersion.nextVersion();
        ArrayList<1> versionElement = new ArrayList<1>();
        LinkedHashMap<String, Object> accountsMap = new LinkedHashMap<String, Object>(){
            {
                this.put("counter", PlainPermissionManager.this.dataVersion.getCounter().longValue());
                this.put("timestamp", PlainPermissionManager.this.dataVersion.getTimestamp());
            }
        };
        versionElement.add(accountsMap);
        updateAclConfigMap.put("dataVersion", versionElement);
        return updateAclConfigMap;
    }

    public boolean updateAccessConfig(PlainAccessConfig plainAccessConfig) {
        if (plainAccessConfig == null) {
            log.error("Parameter value plainAccessConfig is null,Please check your parameter");
            throw new AclException("Parameter value plainAccessConfig is null, Please check your parameter");
        }
        this.checkPlainAccessConfig(plainAccessConfig);
        Permission.checkResourcePerms(plainAccessConfig.getTopicPerms());
        Permission.checkResourcePerms(plainAccessConfig.getGroupPerms());
        Map aclAccessConfigMap = AclUtils.getYamlDataObject(this.fileHome + File.separator + this.fileName, Map.class);
        if (aclAccessConfigMap == null || aclAccessConfigMap.isEmpty()) {
            throw new AclException(String.format("the %s file is not found or empty", this.fileHome + File.separator + this.fileName));
        }
        List accounts = (List)aclAccessConfigMap.get("accounts");
        Map<String, Object> updateAccountMap = null;
        if (accounts != null) {
            for (Map account : accounts) {
                if (!account.get("accessKey").equals(plainAccessConfig.getAccessKey())) continue;
                accounts.remove(account);
                updateAccountMap = this.createAclAccessConfigMap(account, plainAccessConfig);
                accounts.add(updateAccountMap);
                aclAccessConfigMap.put("accounts", accounts);
                return AclUtils.writeDataObject(this.fileHome + File.separator + this.fileName, this.updateAclConfigFileVersion(aclAccessConfigMap));
            }
            accounts.add(this.createAclAccessConfigMap(null, plainAccessConfig));
            aclAccessConfigMap.put("accounts", accounts);
            return AclUtils.writeDataObject(this.fileHome + File.separator + this.fileName, this.updateAclConfigFileVersion(aclAccessConfigMap));
        }
        log.error("Users must ensure that the acl yaml config file has accounts node element");
        return false;
    }

    private Map<String, Object> createAclAccessConfigMap(Map<String, Object> existedAccountMap, PlainAccessConfig plainAccessConfig) {
        Map<String, Object> newAccountsMap = null;
        newAccountsMap = existedAccountMap == null ? new LinkedHashMap<String, Object>() : existedAccountMap;
        if (StringUtils.isEmpty((CharSequence)plainAccessConfig.getAccessKey()) || plainAccessConfig.getAccessKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey()));
        }
        newAccountsMap.put("accessKey", plainAccessConfig.getAccessKey());
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getSecretKey())) {
            if (plainAccessConfig.getSecretKey().length() <= 6) {
                throw new AclException(String.format("The secretKey=%s value length should longer than 6", plainAccessConfig.getSecretKey()));
            }
            newAccountsMap.put("secretKey", plainAccessConfig.getSecretKey());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getWhiteRemoteAddress())) {
            newAccountsMap.put("whiteRemoteAddress", plainAccessConfig.getWhiteRemoteAddress());
        }
        if (!StringUtils.isEmpty((CharSequence)String.valueOf(plainAccessConfig.isAdmin()))) {
            newAccountsMap.put("admin", plainAccessConfig.isAdmin());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultTopicPerm())) {
            newAccountsMap.put("defaultTopicPerm", plainAccessConfig.getDefaultTopicPerm());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultGroupPerm())) {
            newAccountsMap.put("defaultGroupPerm", plainAccessConfig.getDefaultGroupPerm());
        }
        if (plainAccessConfig.getTopicPerms() != null && !plainAccessConfig.getTopicPerms().isEmpty()) {
            newAccountsMap.put("topicPerms", plainAccessConfig.getTopicPerms());
        }
        if (plainAccessConfig.getGroupPerms() != null && !plainAccessConfig.getGroupPerms().isEmpty()) {
            newAccountsMap.put("groupPerms", plainAccessConfig.getGroupPerms());
        }
        return newAccountsMap;
    }

    public boolean deleteAccessConfig(String accesskey) {
        if (StringUtils.isEmpty((CharSequence)accesskey)) {
            log.error("Parameter value accesskey is null or empty String,Please check your parameter");
            return false;
        }
        Map aclAccessConfigMap = AclUtils.getYamlDataObject(this.fileHome + File.separator + this.fileName, Map.class);
        if (aclAccessConfigMap == null || aclAccessConfigMap.isEmpty()) {
            throw new AclException(String.format("the %s file is not found or empty", this.fileHome + File.separator + this.fileName));
        }
        List accounts = (List)aclAccessConfigMap.get("accounts");
        if (accounts != null) {
            Iterator itemIterator = accounts.iterator();
            while (itemIterator.hasNext()) {
                if (!((Map)itemIterator.next()).get("accessKey").equals(accesskey)) continue;
                itemIterator.remove();
                aclAccessConfigMap.put("accounts", accounts);
                return AclUtils.writeDataObject(this.fileHome + File.separator + this.fileName, this.updateAclConfigFileVersion(aclAccessConfigMap));
            }
        }
        log.error("Users must ensure that the acl yaml config file has related acl config elements");
        return false;
    }

    public boolean updateGlobalWhiteAddrsConfig(List<String> globalWhiteAddrsList) {
        Map aclAccessConfigMap = AclUtils.getYamlDataObject(this.fileHome + File.separator + this.fileName, Map.class);
        if (aclAccessConfigMap == null || aclAccessConfigMap.isEmpty()) {
            throw new AclException(String.format("the %s file is not found or empty", this.fileHome + File.separator + this.fileName));
        }
        List globalWhiteRemoteAddrList = (List)aclAccessConfigMap.get("globalWhiteRemoteAddresses");
        if (globalWhiteRemoteAddrList != null) {
            globalWhiteRemoteAddrList.clear();
            if (globalWhiteAddrsList != null) {
                globalWhiteRemoteAddrList.addAll(globalWhiteAddrsList);
            }
            aclAccessConfigMap.put("globalWhiteRemoteAddresses", globalWhiteRemoteAddrList);
            return AclUtils.writeDataObject(this.fileHome + File.separator + this.fileName, this.updateAclConfigFileVersion(aclAccessConfigMap));
        }
        log.error("Users must ensure that the acl yaml config file has globalWhiteRemoteAddresses flag firstly");
        return false;
    }

    public AclConfig getAllAclConfig() {
        JSONArray accounts;
        AclConfig aclConfig = new AclConfig();
        List configs = new ArrayList();
        List whiteAddrs = new ArrayList();
        JSONObject plainAclConfData = AclUtils.getYamlDataObject(this.fileHome + File.separator + this.fileName, JSONObject.class);
        if (plainAclConfData == null || plainAclConfData.isEmpty()) {
            throw new AclException(String.format("%s file is not data", this.fileHome + File.separator + this.fileName));
        }
        JSONArray globalWhiteAddrs = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
        if (globalWhiteAddrs != null && !globalWhiteAddrs.isEmpty()) {
            whiteAddrs = globalWhiteAddrs.toJavaList(String.class);
        }
        if ((accounts = plainAclConfData.getJSONArray("accounts")) != null && !accounts.isEmpty()) {
            configs = accounts.toJavaList(PlainAccessConfig.class);
        }
        aclConfig.setGlobalWhiteAddrs(whiteAddrs);
        aclConfig.setPlainAccessConfigs(configs);
        return aclConfig;
    }

    private void watch() {
        try {
            String watchFilePath = this.fileHome + this.fileName;
            FileWatchService fileWatchService = new FileWatchService(new String[]{watchFilePath}, new FileWatchService.Listener(){

                public void onChanged(String path) {
                    log.info("The plain acl yml changed, reload the context");
                    PlainPermissionManager.this.load();
                }
            });
            fileWatchService.start();
            log.info("Succeed to start AclWatcherService");
            this.isWatchStart = true;
        }
        catch (Exception e) {
            log.error("Failed to start AclWatcherService", (Throwable)e);
        }
    }

    void checkPerm(PlainAccessResource needCheckedAccess, PlainAccessResource ownedAccess) {
        if (Permission.needAdminPerm(needCheckedAccess.getRequestCode()) && !ownedAccess.isAdmin()) {
            throw new AclException(String.format("Need admin permission for request code=%d, but accessKey=%s is not", needCheckedAccess.getRequestCode(), ownedAccess.getAccessKey()));
        }
        Map<String, Byte> needCheckedPermMap = needCheckedAccess.getResourcePermMap();
        Map<String, Byte> ownedPermMap = ownedAccess.getResourcePermMap();
        if (needCheckedPermMap == null) {
            return;
        }
        if (ownedPermMap == null && ownedAccess.isAdmin()) {
            return;
        }
        for (Map.Entry<String, Byte> needCheckedEntry : needCheckedPermMap.entrySet()) {
            String resource = needCheckedEntry.getKey();
            Byte neededPerm = needCheckedEntry.getValue();
            boolean isGroup = PlainAccessResource.isRetryTopic(resource);
            if (ownedPermMap == null || !ownedPermMap.containsKey(resource)) {
                byte ownedPerm;
                byte by = ownedPerm = isGroup ? ownedAccess.getDefaultGroupPerm() : ownedAccess.getDefaultTopicPerm();
                if (Permission.checkPermission(neededPerm, ownedPerm)) continue;
                throw new AclException(String.format("No default permission for %s", PlainAccessResource.printStr(resource, isGroup)));
            }
            if (Permission.checkPermission(neededPerm, ownedPermMap.get(resource))) continue;
            throw new AclException(String.format("No default permission for %s", PlainAccessResource.printStr(resource, isGroup)));
        }
    }

    void clearPermissionInfo() {
        this.plainAccessResourceMap.clear();
        this.globalWhiteRemoteAddressStrategy.clear();
    }

    public void checkPlainAccessConfig(PlainAccessConfig plainAccessConfig) throws AclException {
        if (plainAccessConfig.getAccessKey() == null || plainAccessConfig.getSecretKey() == null || plainAccessConfig.getAccessKey().length() <= 6 || plainAccessConfig.getSecretKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s and secretKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey(), plainAccessConfig.getSecretKey()));
        }
    }

    public PlainAccessResource buildPlainAccessResource(PlainAccessConfig plainAccessConfig) throws AclException {
        this.checkPlainAccessConfig(plainAccessConfig);
        PlainAccessResource plainAccessResource = new PlainAccessResource();
        plainAccessResource.setAccessKey(plainAccessConfig.getAccessKey());
        plainAccessResource.setSecretKey(plainAccessConfig.getSecretKey());
        plainAccessResource.setWhiteRemoteAddress(plainAccessConfig.getWhiteRemoteAddress());
        plainAccessResource.setAdmin(plainAccessConfig.isAdmin());
        plainAccessResource.setDefaultGroupPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultGroupPerm()));
        plainAccessResource.setDefaultTopicPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultTopicPerm()));
        Permission.parseResourcePerms(plainAccessResource, false, plainAccessConfig.getGroupPerms());
        Permission.parseResourcePerms(plainAccessResource, true, plainAccessConfig.getTopicPerms());
        plainAccessResource.setRemoteAddressStrategy(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(plainAccessResource.getWhiteRemoteAddress()));
        return plainAccessResource;
    }

    public void validate(PlainAccessResource plainAccessResource) {
        for (RemoteAddressStrategy remoteAddressStrategy : this.globalWhiteRemoteAddressStrategy) {
            if (!remoteAddressStrategy.match(plainAccessResource)) continue;
            return;
        }
        if (plainAccessResource.getAccessKey() == null) {
            throw new AclException(String.format("No accessKey is configured", new Object[0]));
        }
        if (!this.plainAccessResourceMap.containsKey(plainAccessResource.getAccessKey())) {
            throw new AclException(String.format("No acl config for %s", plainAccessResource.getAccessKey()));
        }
        PlainAccessResource ownedAccess = this.plainAccessResourceMap.get(plainAccessResource.getAccessKey());
        if (ownedAccess.getRemoteAddressStrategy().match(plainAccessResource)) {
            return;
        }
        String signature = AclUtils.calSignature(plainAccessResource.getContent(), ownedAccess.getSecretKey());
        if (!signature.equals(plainAccessResource.getSignature())) {
            throw new AclException(String.format("Check signature failed for accessKey=%s", plainAccessResource.getAccessKey()));
        }
        this.checkPerm(plainAccessResource, ownedAccess);
    }

    public boolean isWatchStart() {
        return this.isWatchStart;
    }
}

