/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.Permission;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategyFactory;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.srvutil.FileWatchService;

public class PlainPermissionLoader {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");
    private static final String DEFAULT_PLAIN_ACL_FILE = "/conf/plain_acl.yml";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private String fileHome = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));
    private String fileName = System.getProperty("rocketmq.acl.plain.file", "/conf/plain_acl.yml");
    private Map<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
    private List<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
    private RemoteAddressStrategyFactory remoteAddressStrategyFactory = new RemoteAddressStrategyFactory();
    private boolean isWatchStart;

    public PlainPermissionLoader() {
        this.load();
        this.watch();
    }

    public void load() {
        JSONArray accounts;
        HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        JSONObject plainAclConfData = AclUtils.getYamlDataObject(this.fileHome + File.separator + this.fileName, JSONObject.class);
        if (plainAclConfData == null || plainAclConfData.isEmpty()) {
            throw new AclException(String.format("%s file  is not data", this.fileHome + File.separator + this.fileName));
        }
        log.info("Broker plain acl conf data is : ", (Object)plainAclConfData.toString());
        JSONArray globalWhiteRemoteAddressesList = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
        if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
            for (int i = 0; i < globalWhiteRemoteAddressesList.size(); ++i) {
                globalWhiteRemoteAddressStrategy.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(globalWhiteRemoteAddressesList.getString(i)));
            }
        }
        if ((accounts = plainAclConfData.getJSONArray("accounts")) != null && !accounts.isEmpty()) {
            List plainAccessConfigList = accounts.toJavaList(PlainAccessConfig.class);
            for (PlainAccessConfig plainAccessConfig : plainAccessConfigList) {
                PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
            }
        }
        this.globalWhiteRemoteAddressStrategy = globalWhiteRemoteAddressStrategy;
        this.plainAccessResourceMap = plainAccessResourceMap;
    }

    private void watch() {
        try {
            String watchFilePath = this.fileHome + this.fileName;
            FileWatchService fileWatchService = new FileWatchService(new String[]{watchFilePath}, new FileWatchService.Listener(){

                public void onChanged(String path) {
                    log.info("The plain acl yml changed, reload the context");
                    PlainPermissionLoader.this.load();
                }
            });
            fileWatchService.start();
            log.info("Succeed to start AclWatcherService");
            this.isWatchStart = true;
        }
        catch (Exception e) {
            log.error("Failed to start AclWatcherService", (Throwable)e);
        }
    }

    void checkPerm(PlainAccessResource needCheckedAccess, PlainAccessResource ownedAccess) {
        if (Permission.needAdminPerm(needCheckedAccess.getRequestCode()) && !ownedAccess.isAdmin()) {
            throw new AclException(String.format("Need admin permission for request code=%d, but accessKey=%s is not", needCheckedAccess.getRequestCode(), ownedAccess.getAccessKey()));
        }
        Map<String, Byte> needCheckedPermMap = needCheckedAccess.getResourcePermMap();
        Map<String, Byte> ownedPermMap = ownedAccess.getResourcePermMap();
        if (needCheckedPermMap == null) {
            return;
        }
        if (ownedPermMap == null && ownedAccess.isAdmin()) {
            return;
        }
        for (Map.Entry<String, Byte> needCheckedEntry : needCheckedPermMap.entrySet()) {
            String resource = needCheckedEntry.getKey();
            Byte neededPerm = needCheckedEntry.getValue();
            boolean isGroup = PlainAccessResource.isRetryTopic(resource);
            if (ownedPermMap == null || !ownedPermMap.containsKey(resource)) {
                byte ownedPerm;
                byte by = ownedPerm = isGroup ? ownedAccess.getDefaultGroupPerm() : ownedAccess.getDefaultTopicPerm();
                if (Permission.checkPermission(neededPerm, ownedPerm)) continue;
                throw new AclException(String.format("No default permission for %s", PlainAccessResource.printStr(resource, isGroup)));
            }
            if (Permission.checkPermission(neededPerm, ownedPermMap.get(resource))) continue;
            throw new AclException(String.format("No default permission for %s", PlainAccessResource.printStr(resource, isGroup)));
        }
    }

    void clearPermissionInfo() {
        this.plainAccessResourceMap.clear();
        this.globalWhiteRemoteAddressStrategy.clear();
    }

    public PlainAccessResource buildPlainAccessResource(PlainAccessConfig plainAccessConfig) throws AclException {
        if (plainAccessConfig.getAccessKey() == null || plainAccessConfig.getSecretKey() == null || plainAccessConfig.getAccessKey().length() <= 6 || plainAccessConfig.getSecretKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s and secretKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey(), plainAccessConfig.getSecretKey()));
        }
        PlainAccessResource plainAccessResource = new PlainAccessResource();
        plainAccessResource.setAccessKey(plainAccessConfig.getAccessKey());
        plainAccessResource.setSecretKey(plainAccessConfig.getSecretKey());
        plainAccessResource.setWhiteRemoteAddress(plainAccessConfig.getWhiteRemoteAddress());
        plainAccessResource.setAdmin(plainAccessConfig.isAdmin());
        plainAccessResource.setDefaultGroupPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultGroupPerm()));
        plainAccessResource.setDefaultTopicPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultTopicPerm()));
        Permission.parseResourcePerms(plainAccessResource, false, plainAccessConfig.getGroupPerms());
        Permission.parseResourcePerms(plainAccessResource, true, plainAccessConfig.getTopicPerms());
        plainAccessResource.setRemoteAddressStrategy(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(plainAccessResource.getWhiteRemoteAddress()));
        return plainAccessResource;
    }

    public void validate(PlainAccessResource plainAccessResource) {
        for (RemoteAddressStrategy remoteAddressStrategy : this.globalWhiteRemoteAddressStrategy) {
            if (!remoteAddressStrategy.match(plainAccessResource)) continue;
            return;
        }
        if (plainAccessResource.getAccessKey() == null) {
            throw new AclException(String.format("No accessKey is configured", new Object[0]));
        }
        if (!this.plainAccessResourceMap.containsKey(plainAccessResource.getAccessKey())) {
            throw new AclException(String.format("No acl config for %s", plainAccessResource.getAccessKey()));
        }
        PlainAccessResource ownedAccess = this.plainAccessResourceMap.get(plainAccessResource.getAccessKey());
        if (ownedAccess.getRemoteAddressStrategy().match(plainAccessResource)) {
            return;
        }
        String signature = AclUtils.calSignature(plainAccessResource.getContent(), ownedAccess.getSecretKey());
        if (!signature.equals(plainAccessResource.getSignature())) {
            throw new AclException(String.format("Check signature failed for accessKey=%s", plainAccessResource.getAccessKey()));
        }
        this.checkPerm(plainAccessResource, ownedAccess);
    }

    public boolean isWatchStart() {
        return this.isWatchStart;
    }

    static class PlainAccessConfig {
        private String accessKey;
        private String secretKey;
        private String whiteRemoteAddress;
        private boolean admin;
        private String defaultTopicPerm;
        private String defaultGroupPerm;
        private List<String> topicPerms;
        private List<String> groupPerms;

        PlainAccessConfig() {
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getWhiteRemoteAddress() {
            return this.whiteRemoteAddress;
        }

        public void setWhiteRemoteAddress(String whiteRemoteAddress) {
            this.whiteRemoteAddress = whiteRemoteAddress;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public void setAdmin(boolean admin) {
            this.admin = admin;
        }

        public String getDefaultTopicPerm() {
            return this.defaultTopicPerm;
        }

        public void setDefaultTopicPerm(String defaultTopicPerm) {
            this.defaultTopicPerm = defaultTopicPerm;
        }

        public String getDefaultGroupPerm() {
            return this.defaultGroupPerm;
        }

        public void setDefaultGroupPerm(String defaultGroupPerm) {
            this.defaultGroupPerm = defaultGroupPerm;
        }

        public List<String> getTopicPerms() {
            return this.topicPerms;
        }

        public void setTopicPerms(List<String> topicPerms) {
            this.topicPerms = topicPerms;
        }

        public List<String> getGroupPerms() {
            return this.groupPerms;
        }

        public void setGroupPerms(List<String> groupPerms) {
            this.groupPerms = groupPerms;
        }
    }
}

