/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kafka;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.kafka.client.ServiceKafkaClient;
import org.apache.ranger.services.kafka.client.ServiceKafkaConnectionMgr;

public class RangerServiceKafka
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceKafka.class);

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public HashMap<String, Object> validateConfig() throws Exception {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceKafka.validateConfig(" + this.serviceName + ")"));
        }
        if (this.configs != null) {
            try {
                ret = ServiceKafkaConnectionMgr.connectionTest(this.serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error((Object)("<== RangerServiceKafka.validateConfig Error:" + e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceKafka.validateConfig(" + this.serviceName + "): ret=" + ret));
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceKafka.lookupResource(" + this.serviceName + ")"));
        }
        if (this.configs != null) {
            ServiceKafkaClient serviceKafkaClient = ServiceKafkaConnectionMgr.getKafkaClient(this.serviceName, this.configs);
            ret = serviceKafkaClient.getResources(context);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceKafka.lookupResource(" + this.serviceName + "): ret=" + ret));
        }
        return ret;
    }
}

